/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask.probability;

import blue.soundObject.jmask.probability.ProbabilityGenerator;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Random;

public class Linear
implements ProbabilityGenerator {
    public static final int DECREASING = 0;
    public static final int INCREASING = 1;
    private int direction = 0;

    public Linear() {
    }

    public Linear(Linear linear) {
        this.direction = linear.direction;
    }

    public static ProbabilityGenerator loadFromXML(Element data) {
        Linear retVal = new Linear();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeName = node.getName();
            if (!nodeName.equals("direction")) continue;
            retVal.direction = XMLUtilities.readInt(node);
        }
        return retVal;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("probabilityGenerator");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement(XMLUtilities.writeInt("direction", this.getDirection()));
        return retVal;
    }

    @Override
    public String getName() {
        return "Linear";
    }

    @Override
    public double getValue(double time, Random rnd) {
        double x1 = rnd.nextDouble();
        double x2 = rnd.nextDouble();
        double retVal = this.direction == 0 ? (x1 < x2 ? x1 : x2) : (x1 > x2 ? x1 : x2);
        return retVal;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    @Override
    public Linear deepCopy() {
        return new Linear(this);
    }
}

