/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.orchestra.blueSynthBuilder.BSBCompilationUnit;
import blue.orchestra.blueSynthBuilder.BSBGroup;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.GridSettings;
import blue.orchestra.blueSynthBuilder.UniqueNameManager;
import blue.utility.ObjectUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.HashSet;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class BSBGraphicInterface {
    BSBGroup rootGroup;
    UniqueNameManager nameManager = new UniqueNameManager();
    private BooleanProperty editEnabled = new SimpleBooleanProperty(true);
    private GridSettings gridSettings;
    private ObservableSet<BSBObject> allSet = FXCollections.observableSet(new HashSet());

    public BSBGraphicInterface() {
        this.gridSettings = new GridSettings();
        this.nameManager.setDefaultPrefix("bsbObj");
        this.setRootGroup(new BSBGroup());
        this.rootGroup.setAllSet(this.allSet);
        this.nameManager.setUniqueNameCollection(this.rootGroup);
    }

    public BSBGraphicInterface(BSBGraphicInterface bsbInterface) {
        this.gridSettings = new GridSettings(bsbInterface.getGridSettings());
        this.nameManager.setDefaultPrefix("bsbObj");
        this.setRootGroup(new BSBGroup(bsbInterface.rootGroup));
        this.rootGroup.setAllSet(this.allSet);
        this.nameManager.setUniqueNameCollection(this.rootGroup);
        this.setEditEnabled(bsbInterface.isEditEnabled());
    }

    public void setupForCompilation(BSBCompilationUnit compilationUnit) {
        this.rootGroup.setupForCompilation(compilationUnit);
    }

    public static BSBGraphicInterface loadFromXML(Element data) throws Exception {
        BSBGraphicInterface graphicInterface = new BSBGraphicInterface();
        Elements giNodes = data.getElements();
        String editEnabledStr = data.getAttributeValue("editEnabled");
        if (editEnabledStr != null) {
            graphicInterface.setEditEnabled(Boolean.valueOf(editEnabledStr));
        }
        GridSettings gridSettings = null;
        while (giNodes.hasMoreElements()) {
            String name;
            Element node = giNodes.next();
            switch (name = node.getName()) {
                case "bsbObject": {
                    BSBObject obj = (BSBObject)ObjectUtilities.loadFromXML(node);
                    if (obj instanceof BSBGroup) {
                        graphicInterface.setRootGroup((BSBGroup)obj);
                        break;
                    }
                    graphicInterface.getRootGroup().addBSBObject(obj);
                    break;
                }
                case "gridSettings": {
                    gridSettings = GridSettings.loadFromXML(node);
                }
            }
        }
        if (gridSettings == null) {
            graphicInterface.getGridSettings().setGridStyle(GridSettings.GridStyle.NONE);
            graphicInterface.getGridSettings().setSnapEnabled(false);
        } else {
            graphicInterface.setGridSettings(gridSettings);
        }
        return graphicInterface;
    }

    public Element saveAsXML() {
        Element retVal = new Element("graphicInterface");
        retVal.setAttribute("editEnabled", Boolean.toString(this.isEditEnabled()));
        retVal.addElement(this.gridSettings.saveAsXML());
        retVal.addElement(this.rootGroup.saveAsXML());
        return retVal;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public final void setEditEnabled(boolean value) {
        this.editEnabled.set(value);
    }

    public final boolean isEditEnabled() {
        return this.editEnabled.get();
    }

    public final BooleanProperty editEnabledProperty() {
        return this.editEnabled;
    }

    public GridSettings getGridSettings() {
        return this.gridSettings;
    }

    public void setGridSettings(GridSettings gridSettings) {
        this.gridSettings = gridSettings;
    }

    public BSBGroup getRootGroup() {
        return this.rootGroup;
    }

    private void setRootGroup(BSBGroup group) {
        if (this.rootGroup != null) {
            this.rootGroup.setAllSet(null);
            this.allSet.clear();
        }
        this.rootGroup = group;
        group.setUniqueNameManager(this.nameManager);
        this.nameManager.setUniqueNameCollection(this.rootGroup);
        group.setAllSet(this.allSet);
    }

    public ObservableSet<BSBObject> getAllSet() {
        return this.allSet;
    }
}

