/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.filemanager;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class FileManagerRoots {
    List<File> staticRoots = new ArrayList<File>();
    List<File> customRoots = new ArrayList<File>();
    transient List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public FileManagerRoots() {
        this.staticRoots.addAll(Arrays.asList(File.listRoots()));
        this.staticRoots.add(new File(System.getProperty("user.home")));
        this.loadCustomRoots();
    }

    public List<File> getRoots() {
        ArrayList<File> retVal = new ArrayList<File>();
        retVal.addAll(this.staticRoots);
        retVal.addAll(this.customRoots);
        return retVal;
    }

    public boolean staticRootsContains(File f) {
        return this.staticRoots.contains(f);
    }

    public boolean customRootsContains(File file) {
        return this.customRoots.contains(file);
    }

    public boolean contains(File f) {
        return this.staticRoots.contains(f) || this.customRoots.contains(f);
    }

    public void addRoot(File f) {
        if (!f.isDirectory() || this.contains(f)) {
            return;
        }
        this.customRoots.add(f);
        this.fireChange(new ChangeEvent(this));
        this.saveCustomRoots();
    }

    public void removeRoot(File f) {
        if (this.customRoots.contains(f)) {
            this.customRoots.remove(f);
            this.fireChange(new ChangeEvent(this));
            this.saveCustomRoots();
        }
    }

    public void addChangeListener(ChangeListener cl) {
        this.listeners.add(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listeners.remove(cl);
    }

    public void fireChange(ChangeEvent ce) {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(ce);
        }
    }

    private void loadCustomRoots() {
        String root;
        Preferences p = NbPreferences.forModule(FileManagerRoots.class);
        int i = 0;
        while ((root = p.get("customRoot" + i, null)) != null) {
            File f = new File(root);
            if (f.exists() && f.isDirectory()) {
                this.customRoots.add(f);
            }
            ++i;
        }
    }

    private void saveCustomRoots() {
        Preferences p = NbPreferences.forModule(FileManagerRoots.class);
        try {
            p.clear();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        int i = 0;
        for (File f : this.customRoots) {
            p.put("customRoot" + i, f.getAbsolutePath());
            ++i;
        }
        try {
            p.flush();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

