/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score;

import blue.BlueData;
import blue.automation.AutomationManager;
import blue.components.AlphaMarquee;
import blue.gui.MyScrollPaneLayout;
import blue.gui.ScrollerButton;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.score.Score;
import blue.score.ScoreObject;
import blue.score.TimeState;
import blue.score.layers.Layer;
import blue.score.layers.LayerGroup;
import blue.score.tempo.Tempo;
import blue.services.render.RenderTimeManager;
import blue.services.render.RenderTimeManagerListener;
import blue.settings.PlaybackSettings;
import blue.soundObject.PolyObject;
import blue.soundObject.SoundObject;
import blue.ui.components.IconFactory;
import blue.ui.core.score.LayerHeightWheelListener;
import blue.ui.core.score.ModeManager;
import blue.ui.core.score.ModeSelectionPanel;
import blue.ui.core.score.NoteProcessorDialog;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScoreControllerListener;
import blue.ui.core.score.ScoreMode;
import blue.ui.core.score.ScoreMouseListener;
import blue.ui.core.score.ScoreMouseWheelListener;
import blue.ui.core.score.ScoreNavigatorDialog;
import blue.ui.core.score.ScoreObjectBar;
import blue.ui.core.score.ScoreObjectView;
import blue.ui.core.score.ScorePath;
import blue.ui.core.score.TimeBar;
import blue.ui.core.score.TimePointer;
import blue.ui.core.score.TimelinePropertiesPanel;
import blue.ui.core.score.layers.LayerGroupPanel;
import blue.ui.core.score.layers.LayerGroupUIProviderManager;
import blue.ui.core.score.layers.SoundObjectProvider;
import blue.ui.core.score.manager.LayerGroupManagerDialog;
import blue.ui.core.score.manager.ScoreManagerDialog;
import blue.ui.core.score.tempo.TempoEditor;
import blue.ui.core.score.tempo.TempoEditorControl;
import blue.ui.utilities.LinearLayout;
import blue.util.ObservableListEvent;
import blue.util.ObservableListListener;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="ScoreTopComponent", persistenceType=0)
public final class ScoreTopComponent
extends TopComponent
implements ObservableListListener<LayerGroup<? extends Layer>>,
RenderTimeManagerListener,
PropertyChangeListener,
SoundObjectProvider,
ScoreControllerListener {
    private final InstanceContent content = new InstanceContent();
    private static ScoreTopComponent instance;
    private NoteProcessorDialog npcDialog = null;
    SoundObject bufferSoundObject;
    BlueData data;
    ScoreObjectBar scoreObjectBar = new ScoreObjectBar();
    TimeBar timeBar = new TimeBar();
    Border libraryBorder = new LineBorder(Color.GREEN);
    JPanel leftPanel = new JPanel(new BorderLayout());
    JViewport layerHeaderViewPort = new JViewport();
    JPanel layerHeaderPanel = new JPanel();
    JLayeredPane scorePanel = new JLayeredPane();
    JPanel layerPanel = new JPanel();
    Point syncPosition = new Point(0, 0);
    TimePointer renderStartPointer = new TimePointer(Color.GREEN);
    TimePointer renderLoopPointer = new TimePointer(Color.YELLOW);
    TimePointer renderTimePointer = new TimePointer(Color.ORANGE);
    double renderStart = -1.0;
    double timePointer = -1.0;
    JToggleButton snapButton = new JToggleButton();
    JCheckBox checkBox = new JCheckBox();
    TimelinePropertiesPanel timeProperties = new TimelinePropertiesPanel();
    TempoEditorControl tempoControlPanel = new TempoEditorControl();
    TempoEditor tempoEditor = new TempoEditor();
    ScoreNavigatorDialog navigator = null;
    volatile boolean checkingSize = false;
    AlphaMarquee marquee = new AlphaMarquee();
    ScoreMouseWheelListener mouseWheelListener;
    LayerHeightWheelListener layerHeightWheelListener;
    ScoreMouseListener listener = new ScoreMouseListener(this, this.content);
    TimeState currentTimeState = null;
    RenderTimeManager renderTimeManager = (RenderTimeManager)Lookup.getDefault().lookup(RenderTimeManager.class);
    PropertyChangeListener layerPanelWidthListener = evt -> SwingUtilities.invokeLater(this::checkSize);
    private JScrollPane scrollPane;
    private JPanel topPanel;
    private JSplitPane topSplitPane;

    private ScoreTopComponent() {
        this.initComponents();
        this.associateLookup((Lookup)new AbstractLookup((AbstractLookup.Content)this.content));
        this.setName(NbBundle.getMessage(ScoreTopComponent.class, (String)"CTL_ScoreTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ScoreTopComponent.class, (String)"HINT_ScoreTopComponent"));
        this.init();
        ScoreController scoreController = ScoreController.getInstance();
        scoreController.addScoreControllerListener(this.scoreObjectBar);
        scoreController.addScoreControllerListener(this);
        scoreController.setLookupAndContent(this.getLookup(), this.content);
        scoreController.setScrollPane(this.scrollPane);
        BlueProjectManager.getInstance().addPropertyChangeListener(evt -> {
            if ("currentProject".equals(evt.getPropertyName())) {
                this.reinitialize();
            }
        });
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(ae -> {
            this.syncPosition.setLocation(0, ae.getValue());
            this.layerHeaderViewPort.setViewPosition(this.syncPosition);
        });
        this.renderTimeManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.renderTimeManager.addRenderTimeManagerListener((RenderTimeManagerListener)this);
        this.reinitialize();
        this.layerPanel.addMouseListener(this.listener);
        this.layerPanel.addMouseMotionListener(this.listener);
        this.layerHeaderViewPort.addMouseWheelListener(e -> {
            if (!e.isShiftDown()) {
                for (MouseWheelListener listener1 : this.scrollPane.getMouseWheelListeners()) {
                    listener1.mouseWheelMoved(e);
                }
            }
        });
        FileObject[] files = FileUtil.getConfigFile((String)"blue/score/shortcuts").getChildren();
        InputMap inputMap = this.scorePanel.getInputMap(1);
        ActionMap actionMap = this.scorePanel.getActionMap();
        for (FileObject fObj : files) {
            Action a = (Action)FileUtil.getConfigObject((String)fObj.getPath(), Action.class);
            KeyStroke ks = Utilities.stringToKey((String)fObj.getName());
            inputMap.put(ks, a.getValue("Name"));
            actionMap.put(a.getValue("Name"), a);
        }
    }

    protected void checkSize() {
        if (!this.checkingSize) {
            this.checkingSize = true;
            int height = (this.layerPanel.getComponentCount() - 1) * 36;
            int width = this.scrollPane.getViewport().getWidth();
            for (int i = 0; i < this.layerPanel.getComponentCount(); ++i) {
                Component c = this.layerPanel.getComponent(i);
                Dimension d = c.getPreferredSize();
                width = width > d.width ? width : d.width;
                height += d.height;
            }
            if (width != this.getWidth() || height != this.getHeight()) {
                Dimension d = new Dimension(width, height);
                this.layerPanel.setSize(d);
                for (int i = 0; i < this.layerPanel.getComponentCount(); ++i) {
                    Component c = this.layerPanel.getComponent(i);
                    Dimension d2 = c.getPreferredSize();
                    c.setSize(width, d2.height);
                }
                this.layerPanel.revalidate();
            }
            this.checkingSize = false;
        }
    }

    public synchronized void reinitialize() {
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        BlueData currentData = null;
        if (project != null) {
            currentData = project.getData();
        }
        if (this.currentTimeState != null) {
            this.currentTimeState.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (this.data != null) {
            this.data.removePropertyChangeListener((PropertyChangeListener)this);
            this.data.getScore().removeListener((ObservableListListener)this);
            this.content.remove((Object)this.data.getScore());
        }
        this.clearAll();
        this.data = currentData;
        AutomationManager.getInstance().setData(this.data);
        for (ScoreObject scoreObj : this.getLookup().lookupAll(ScoreObject.class)) {
            this.content.remove((Object)scoreObj);
        }
        if (this.data != null) {
            Tempo tempo = this.data.getScore().getTempo();
            this.tempoControlPanel.setTempo(tempo);
            this.tempoEditor.setTempo(tempo);
            this.timeBar.setData(this.data);
            this.data.addPropertyChangeListener((PropertyChangeListener)this);
            Score score = this.data.getScore();
            score.addListener((ObservableListListener)this);
            ScoreController.getInstance().setScore(score);
            this.content.add((Object)score);
        }
        this.layerHeaderPanel.repaint();
    }

    private void addPanelsForLayerGroup(int index, LayerGroup layerGroup, TimeState timeState) {
        final JComponent comp = LayerGroupUIProviderManager.getInstance().getLayerGroupPanel(layerGroup, timeState, this.data, this.content);
        final JComponent comp2 = LayerGroupUIProviderManager.getInstance().getLayerGroupHeaderPanel(layerGroup, timeState, this.data, this.content);
        if (comp != null && comp2 != null) {
            comp.putClientProperty("layerGroup", layerGroup);
            if (index < 0 || index > this.layerPanel.getComponentCount() - 1) {
                this.layerPanel.add(comp);
                this.layerHeaderPanel.add(comp2);
            } else {
                this.layerPanel.add((Component)comp, index);
                this.layerHeaderPanel.add((Component)comp2, index);
            }
            Dimension d = new Dimension(comp2.getWidth(), comp.getHeight());
            comp2.setSize(d);
            comp.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    SwingUtilities.invokeLater(() -> {
                        Dimension d1 = new Dimension(ScoreTopComponent.this.leftPanel.getWidth(), comp.getHeight());
                        comp2.setSize(d1);
                        comp2.revalidate();
                    });
                }
            });
            comp.addPropertyChangeListener("preferredSize", this.layerPanelWidthListener);
        }
    }

    private void removePanelsForLayerGroups(int startIndex, int endIndex) {
        for (int i = 0; i <= endIndex - startIndex; ++i) {
            Component comp = this.layerPanel.getComponent(startIndex);
            this.layerPanel.remove(startIndex);
            this.layerHeaderPanel.remove(startIndex);
        }
        this.layerPanel.revalidate();
        this.layerPanel.repaint();
        this.layerHeaderPanel.revalidate();
        this.layerHeaderPanel.repaint();
    }

    public void clearAll() {
        this.scrollPane.revalidate();
    }

    private void formInit() {
        this.scrollPane.setLayout(new MyScrollPaneLayout());
        JPanel horizontalViewChanger = new JPanel(new GridLayout(1, 2));
        ScrollerButton plusHorz = new ScrollerButton("+");
        ScrollerButton minusHorz = new ScrollerButton("-");
        plusHorz.setActionCommand("plusHorizontal");
        minusHorz.setActionCommand("minusHorizontal");
        horizontalViewChanger.add(plusHorz);
        horizontalViewChanger.add(minusHorz);
        ActionListener al = e -> {
            String command;
            switch (command = e.getActionCommand()) {
                case "minusHorizontal": {
                    this.currentTimeState.lowerPixelSecond();
                    break;
                }
                case "plusHorizontal": {
                    this.currentTimeState.raisePixelSecond();
                }
            }
        };
        plusHorz.addActionListener(al);
        minusHorz.addActionListener(al);
        this.scrollPane.add((Component)horizontalViewChanger, "HorizontalRight");
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.tempoControlPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        JButton manageButton = new JButton("Manage");
        manageButton.addActionListener(e -> {
            JDialog dialog;
            ScorePath path = ScoreController.getInstance().getScorePath();
            if (path.getLastLayerGroup() == null) {
                ScoreManagerDialog dlg = new ScoreManagerDialog(WindowManager.getDefault().getMainWindow(), true);
                dlg.setScore(this.data.getScore());
                dlg.setSize(600, 500);
                dialog = dlg;
            } else {
                LayerGroupManagerDialog dlg = new LayerGroupManagerDialog(WindowManager.getDefault().getMainWindow(), true);
                dlg.setLayerGroup(path.getLastLayerGroup());
                dlg.setSize(300, 500);
                dialog = dlg;
            }
            GUI.centerOnScreen((Component)dialog);
            dialog.setVisible(true);
        });
        manageButton.setPreferredSize(new Dimension(100, 20));
        JPanel bottomHeaderPanel = new JPanel();
        bottomHeaderPanel.setPreferredSize(new Dimension(100, 14));
        this.layerHeaderViewPort.setBorder(null);
        this.layerHeaderViewPort.setView(this.layerHeaderPanel);
        JPanel leftHeaderView = new JPanel(new BorderLayout());
        leftHeaderView.add((Component)this.tempoControlPanel, "North");
        leftHeaderView.add((Component)manageButton, "South");
        this.leftPanel.add((Component)leftHeaderView, "North");
        this.leftPanel.add((Component)this.layerHeaderViewPort, "Center");
        this.leftPanel.add((Component)bottomHeaderPanel, "South");
        this.tempoControlPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ScoreTopComponent.this.layerHeaderPanel.setSize(ScoreTopComponent.this.layerHeaderViewPort.getWidth(), ScoreTopComponent.this.layerHeaderPanel.getHeight());
                ScoreTopComponent.this.leftPanel.revalidate();
            }
        });
        final JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.setBackground(Color.BLACK);
        headerPanel.add((Component)this.tempoEditor, "Center");
        headerPanel.add((Component)this.timeBar, "South");
        this.tempoEditor.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                headerPanel.revalidate();
            }
        });
        ImageIcon icon = new ImageIcon(ImageUtilities.loadImage((String)"blue/resources/images/ZoomIn16.gif"));
        JButton zoomButton = new JButton(icon);
        zoomButton.addActionListener(e -> {
            if (this.navigator == null) {
                this.navigator = new ScoreNavigatorDialog(WindowManager.getDefault().getMainWindow());
                this.navigator.setJScrollPane(this.scrollPane);
                this.navigator.setLayerPanel(this.layerPanel);
            }
            this.navigator.setVisible(true);
        });
        this.scrollPane.setColumnHeaderView(headerPanel);
        this.scrollPane.setCorner("LOWER_RIGHT_CORNER", zoomButton);
        this.scrollPane.setCorner("UPPER_RIGHT_CORNER", this.snapButton);
        this.layerPanel.setBackground(Color.BLACK);
        this.layerPanel.setOpaque(true);
        this.layerPanel.setLayout((LayoutManager)new LinearLayout(36));
        this.layerHeaderPanel.setLayout((LayoutManager)new LinearLayout(36));
        this.scorePanel.add((Component)this.layerPanel, JLayeredPane.DEFAULT_LAYER);
        this.scrollPane.getViewport().setView(this.scorePanel);
        this.scrollPane.getViewport().setScrollMode(1);
        this.scrollPane.getViewport().setBackground(Color.BLACK);
        this.topSplitPane.add((Component)this.scrollPane, "right");
        this.topSplitPane.add((Component)this.leftPanel, "left");
        this.topSplitPane.setDividerLocation(175);
        this.timeProperties.setVisible(false);
        this.timeProperties.setPreferredSize(new Dimension(150, 40));
        this.timeProperties.setVisible(false);
        this.timeProperties.setPreferredSize(new Dimension(150, 40));
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.add((Component)new ModeSelectionPanel(), "West");
        this.topPanel.add((Component)this.scoreObjectBar, "Center");
        this.add(this.timeProperties, "East");
        this.snapButton.addActionListener(e -> this.timeProperties.setVisible(!this.timeProperties.isVisible()));
        this.scorePanel.add((Component)this.renderStartPointer, JLayeredPane.DRAG_LAYER);
        this.scorePanel.add((Component)this.renderLoopPointer, JLayeredPane.DRAG_LAYER);
        this.scorePanel.add((Component)this.renderTimePointer, JLayeredPane.DRAG_LAYER);
    }

    private void init() {
        this.snapButton.setIcon(IconFactory.getLeftArrowIcon());
        this.snapButton.setSelectedIcon(IconFactory.getRightArrowIcon());
        this.snapButton.setFocusable(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.layerPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int newHeight = ScoreTopComponent.this.layerPanel.getHeight();
                Dimension d = new Dimension(ScoreTopComponent.this.layerPanel.getWidth(), 20);
                ScoreTopComponent.this.timeBar.setMinimumSize(d);
                ScoreTopComponent.this.timeBar.setPreferredSize(d);
                ScoreTopComponent.this.timeBar.setSize(d);
                ScoreTopComponent.this.timeBar.repaint();
                ScoreTopComponent.this.scorePanel.setSize(ScoreTopComponent.this.layerPanel.getSize());
                ScoreTopComponent.this.scorePanel.setPreferredSize(ScoreTopComponent.this.layerPanel.getSize());
                ScoreTopComponent.this.renderStartPointer.setSize(1, newHeight);
                ScoreTopComponent.this.renderLoopPointer.setSize(1, newHeight);
                ScoreTopComponent.this.renderTimePointer.setSize(1, newHeight);
            }
        });
        try {
            this.formInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mouseWheelListener = new ScoreMouseWheelListener(this.scrollPane);
        this.layerHeightWheelListener = new LayerHeightWheelListener(this.layerPanel);
        this.layerPanel.addMouseWheelListener(this.layerHeightWheelListener);
        ModeManager.getInstance().setMode(ScoreMode.SCORE);
        ModeManager.getInstance().addModeListener(mode -> this.getMarquee().setVisible(false));
    }

    public int getHorizontalScrollValue() {
        return this.scrollPane.getHorizontalScrollBar().getValue();
    }

    public int getVerticalScrollValue() {
        return this.scrollPane.getVerticalScrollBar().getValue();
    }

    public void setHorizontalScrollValue(int value) {
        this.scrollPane.getHorizontalScrollBar().setValue(value);
    }

    public void setVerticalScrollValue(int value) {
        this.scrollPane.getVerticalScrollBar().setValue(value);
    }

    private void initComponents() {
        this.topSplitPane = new JSplitPane();
        this.scrollPane = new JScrollPane();
        this.topPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.topSplitPane.setDividerLocation(160);
        this.scrollPane.setBorder(null);
        this.topSplitPane.setRightComponent(this.scrollPane);
        this.add(this.topSplitPane, "Center");
        this.add(this.topPanel, "First");
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public void updateRenderStartPointerX(int x, boolean fireUpdate) {
        boolean left = x < this.renderStartPointer.getX();
        this.renderStartPointer.setLocation(x, 0);
        if (fireUpdate) {
            JViewport viewPort = (JViewport)this.scorePanel.getParent();
            Rectangle rect = left ? new Rectangle(x - 20, viewPort.getViewPosition().y, 1, 1) : new Rectangle(x + 20, viewPort.getViewPosition().y, 1, 1);
            this.scrollRectToVisible(rect);
        }
    }

    public void updateRenderLoopPointerX(int newX) {
        this.renderLoopPointer.setLocation(newX, 0);
    }

    private void updateRenderTimePointer() {
        ScorePath path = ScoreController.getInstance().getScorePath();
        if (path.getLastLayerGroup() != null) {
            return;
        }
        if (!this.renderTimeManager.isCurrentProjectRendering()) {
            return;
        }
        double latency = PlaybackSettings.getInstance().getPlaybackLatencyCorrection();
        if (this.renderStart < 0.0 || this.timePointer < latency) {
            this.renderTimePointer.setLocation(-1, 0);
        } else {
            int x = (int)((this.renderStart + this.timePointer - latency) * (double)this.data.getScore().getTimeState().getPixelSecond());
            this.renderTimePointer.setLocation(x, 0);
        }
    }

    public void renderInitiated() {
    }

    public void renderEnded() {
    }

    public void renderTimeUpdated(double timePointer) {
        this.timePointer = timePointer;
        this.updateRenderTimePointer();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.renderTimeManager) {
            if (evt.getPropertyName().equals("renderStart")) {
                this.renderStart = (Double)evt.getNewValue();
                this.timePointer = -1.0;
                this.updateRenderTimePointer();
            }
        } else if (evt.getSource() == this.currentTimeState) {
            if (evt.getPropertyName().equals("pixelSecond")) {
                double val = this.data.getRenderStartTime();
                int newX = (int)(val * (double)this.currentTimeState.getPixelSecond());
                this.updateRenderStartPointerX(newX, true);
                val = this.data.getRenderEndTime();
                newX = (int)(val * (double)this.currentTimeState.getPixelSecond());
                this.updateRenderLoopPointerX(newX);
            }
        } else if (evt.getSource() == this.data) {
            boolean isRenderStartTime = evt.getPropertyName().equals("renderStartTime");
            boolean isRenderLoopTime = evt.getPropertyName().equals("renderLoopTime");
            if (isRenderStartTime || isRenderLoopTime) {
                if (this.data.getScore() == null) {
                    return;
                }
                double val = (Double)evt.getNewValue();
                TimeState timeState = this.data.getScore().getTimeState();
                int newX = (int)(val * (double)timeState.getPixelSecond());
                if (isRenderStartTime) {
                    this.updateRenderStartPointerX(newX, true);
                } else if (isRenderLoopTime) {
                    this.updateRenderLoopPointerX(newX);
                }
            }
        }
    }

    public void scoreBarScoreSelected(Score score, int scrollX, int scrollY) {
        if (this.currentTimeState != null) {
            this.currentTimeState.removePropertyChangeListener((PropertyChangeListener)this);
        }
        ScoreController.getInstance().setSelectedScoreObjects(null);
        this.clearAll();
        if (score != null) {
            this.layerPanel.removeAll();
            this.layerHeaderPanel.removeAll();
            for (LayerGroup layerGroup : score) {
                this.addPanelsForLayerGroup(-1, layerGroup, score.getTimeState());
            }
            this.checkSize();
            this.layerPanel.revalidate();
            this.layerHeaderPanel.revalidate();
            TimeState timeState = score.getTimeState();
            this.tempoEditor.setTimeState(timeState);
            this.tempoEditor.setVisible(true);
            this.tempoControlPanel.setVisible(true);
            this.timeBar.setRootTimeline(true);
            this.timeBar.setTimeState(timeState);
            this.timeProperties.setTimeState(timeState);
            this.mouseWheelListener.setTimeState(timeState);
            this.currentTimeState = timeState;
            timeState.addPropertyChangeListener((PropertyChangeListener)this);
            this.scrollPane.repaint();
            ModeManager.getInstance().setMode(ModeManager.getInstance().getMode());
            int startTime = (int)(this.data.getRenderStartTime() * (double)timeState.getPixelSecond());
            int endTime = (int)(this.data.getRenderEndTime() * (double)timeState.getPixelSecond());
            this.renderStartPointer.setVisible(true);
            this.renderLoopPointer.setVisible(true);
            this.renderTimePointer.setVisible(true);
            this.scorePanel.add((Component)this.marquee, new Integer(500));
            this.marquee.setVisible(false);
            this.updateRenderStartPointerX(startTime, false);
            this.updateRenderLoopPointerX(endTime);
            this.renderTimePointer.setLocation(-1, 0);
            this.updateRenderTimePointer();
            this.layerHeaderPanel.repaint();
            this.setHorizontalScrollValue(scrollX);
            this.setVerticalScrollValue(scrollY);
        }
    }

    public void scoreBarLayerGroupSelected(LayerGroup layerGroup, int scrollX, int scrollY) {
        if (!(layerGroup instanceof PolyObject)) {
            return;
        }
        ScoreController.getInstance().setSelectedScoreObjects(null);
        PolyObject pObj = (PolyObject)layerGroup;
        this.tempoEditor.setVisible(false);
        this.tempoControlPanel.setVisible(false);
        if (this.currentTimeState != null) {
            this.currentTimeState.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.clearAll();
        if (layerGroup != null) {
            this.layerPanel.removeAll();
            this.layerHeaderPanel.removeAll();
            this.addPanelsForLayerGroup(-1, layerGroup, pObj.getTimeState());
            this.checkSize();
            this.layerPanel.revalidate();
            this.layerHeaderPanel.revalidate();
            TimeState timeState = pObj.getTimeState();
            this.tempoEditor.setTimeState(timeState);
            this.tempoEditor.setVisible(true);
            this.tempoControlPanel.setVisible(true);
            this.timeBar.setRootTimeline(false);
            this.timeBar.setTimeState(timeState);
            this.timeProperties.setTimeState(timeState);
            this.mouseWheelListener.setTimeState(timeState);
            this.currentTimeState = timeState;
            timeState.addPropertyChangeListener((PropertyChangeListener)this);
            this.scrollPane.repaint();
            ModeManager.getInstance().setMode(ModeManager.getInstance().getMode());
            this.renderStartPointer.setVisible(false);
            this.renderLoopPointer.setVisible(false);
            this.renderTimePointer.setVisible(false);
            this.layerHeaderPanel.repaint();
            this.setHorizontalScrollValue(scrollX);
            this.setVerticalScrollValue(scrollY);
        }
    }

    public JLayeredPane getScorePanel() {
        return this.scorePanel;
    }

    public AlphaMarquee getMarquee() {
        return this.marquee;
    }

    public JPanel getLayerPanel() {
        return this.layerPanel;
    }

    @Override
    public void scorePathChanged(ScorePath path) {
        LayerGroup<? extends Layer> layerGroup = path.getLastLayerGroup();
        if (layerGroup == null) {
            this.scoreBarScoreSelected(path.getScore(), 0, 0);
        } else {
            this.scoreBarLayerGroupSelected(layerGroup, 0, 0);
        }
    }

    public void listChanged(ObservableListEvent<LayerGroup<? extends Layer>> evt) {
        if (evt.getType() == 0) {
            Score score = this.data.getScore();
            for (int i = evt.getStartIndex(); i <= evt.getEndIndex(); ++i) {
                this.addPanelsForLayerGroup(i, (LayerGroup)score.get(i), score.getTimeState());
            }
            this.layerHeaderPanel.revalidate();
            this.checkSize();
        } else if (evt.getType() == 1) {
            this.removePanelsForLayerGroups(evt.getStartIndex(), evt.getEndIndex());
        } else if (evt.getType() == 2) {
            List layerGroups = evt.getAffectedItems();
            JComponent c = (JComponent)this.layerPanel.getComponent(evt.getStartIndex());
            LayerGroup lGroup = (LayerGroup)c.getClientProperty("layerGroup");
            if (layerGroups.get(1) == lGroup) {
                Component comp = this.layerPanel.getComponent(evt.getEndIndex());
                this.layerPanel.remove(comp);
                this.layerPanel.add(comp, evt.getStartIndex());
                Component comp2 = this.layerHeaderPanel.getComponent(evt.getEndIndex());
                this.layerHeaderPanel.remove(comp2);
                this.layerHeaderPanel.add(comp2, evt.getStartIndex());
                this.layerPanel.revalidate();
                this.layerHeaderPanel.revalidate();
                this.layerPanel.repaint();
                this.layerHeaderPanel.repaint();
            } else {
                Component comp = this.layerPanel.getComponent(evt.getStartIndex());
                this.layerPanel.remove(comp);
                this.layerPanel.add(comp, evt.getEndIndex());
                Component comp2 = this.layerHeaderPanel.getComponent(evt.getStartIndex());
                this.layerHeaderPanel.remove(comp2);
                this.layerHeaderPanel.add(comp2, evt.getEndIndex());
                this.layerPanel.revalidate();
                this.layerHeaderPanel.revalidate();
                this.layerPanel.repaint();
                this.layerHeaderPanel.repaint();
            }
        }
    }

    public LayerGroupPanel getLayerGroupPanelAtPoint(MouseEvent e) {
        LayerGroupPanel retVal = null;
        Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.layerPanel);
        Component c = this.layerPanel.getComponentAt(p);
        if (c instanceof LayerGroupPanel) {
            retVal = (LayerGroupPanel)((Object)c);
        }
        return retVal;
    }

    public ScoreObjectView getScoreObjectViewAtPoint(MouseEvent e) {
        LayerGroupPanel retVal = this.getLayerGroupPanelAtPoint(e);
        if (retVal == null) {
            return null;
        }
        return retVal.getScoreObjectViewAtPoint(SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), (JComponent)((Object)retVal)));
    }

    public TimeState getTimeState() {
        return this.currentTimeState;
    }

    public List<LayerGroupPanel> getLayerGroupPanels() {
        ArrayList<LayerGroupPanel> lgPanels = new ArrayList<LayerGroupPanel>();
        for (int i = 0; i < this.layerPanel.getComponentCount(); ++i) {
            Component c = this.layerPanel.getComponent(i);
            if (!(c instanceof LayerGroupPanel)) continue;
            lgPanels.add((LayerGroupPanel)((Object)c));
        }
        return lgPanels;
    }
}

