/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.jmask;

import blue.soundObject.editor.jmask.DurationSettable;
import blue.soundObject.jmask.Random;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RandomEditor
extends JPanel
implements DurationSettable {
    Random random;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSpinner maxSpinner;
    private JSpinner minSpinner;

    public RandomEditor(final Random random) {
        this.random = random;
        this.initComponents();
        this.minSpinner.setModel(new SpinnerNumberModel(random.getMin(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0){

            @Override
            public void setValue(Object value) {
                if (value == null || !(value instanceof Number)) {
                    throw new IllegalArgumentException("illegal value");
                }
                double val = (Double)value;
                if (val > random.getMax()) {
                    throw new IllegalArgumentException("illegal value");
                }
                super.setValue(value);
            }
        });
        this.maxSpinner.setModel(new SpinnerNumberModel(random.getMax(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0){

            @Override
            public void setValue(Object value) {
                if (value == null || !(value instanceof Number)) {
                    throw new IllegalArgumentException("illegal value");
                }
                double val = (Double)value;
                if (val < random.getMin()) {
                    throw new IllegalArgumentException("illegal value");
                }
                super.setValue(value);
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.minSpinner = new JSpinner();
        this.jLabel3 = new JLabel();
        this.maxSpinner = new JSpinner();
        this.jLabel1.setText("Random");
        this.jLabel2.setText("Min");
        this.minSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RandomEditor.this.minSpinnerStateChanged(evt);
            }
        });
        this.jLabel3.setText("Max");
        this.maxSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RandomEditor.this.maxSpinnerStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minSpinner, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxSpinner, -2, 117, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.maxSpinner, this.minSpinner);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.minSpinner, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.maxSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void maxSpinnerStateChanged(ChangeEvent evt) {
        double val = (Double)this.maxSpinner.getValue();
        if (val >= this.random.getMin()) {
            this.random.setMax(val);
        }
    }

    private void minSpinnerStateChanged(ChangeEvent evt) {
        double val = (Double)this.minSpinner.getValue();
        if (val <= this.random.getMax()) {
            this.random.setMin(val);
        }
    }

    @Override
    public void setDuration(double duration) {
    }
}

