/*
 * Decompiled with CFR 0.152.
 */
package blue.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class TreeHilightDropListener
implements DropTargetListener {
    private Component oldGlassPane;
    private Point from;
    private Point to;
    JPanel glassPane = new JPanel(){

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.red);
            if (TreeHilightDropListener.this.from == null || TreeHilightDropListener.this.to == null) {
                return;
            }
            int x1 = ((TreeHilightDropListener)TreeHilightDropListener.this).from.x;
            int x2 = ((TreeHilightDropListener)TreeHilightDropListener.this).to.x;
            int y1 = ((TreeHilightDropListener)TreeHilightDropListener.this).from.y;
            g.drawLine(x1 + 2, y1, x2 - 2, y1);
            g.drawLine(x1 + 2, y1 + 1, x2 - 2, y1 + 1);
            g.drawLine(x1, y1 - 2, x1, y1 + 3);
            g.drawLine(x1 + 1, y1 - 1, x1 + 1, y1 + 2);
            g.drawLine(x2, y1 - 2, x2, y1 + 3);
            g.drawLine(x2 - 1, y1 - 1, x2 - 1, y1 + 2);
        }
    };
    private int hotspot = 5;
    protected TreePath treePath = null;
    protected Boolean before = null;

    private void updateLine(JTree tree, Point pt) {
        this.treePath = tree.getPathForLocation(pt.x, pt.y);
        if (this.treePath == null) {
            this.to = null;
            this.from = null;
            this.before = null;
            tree.clearSelection();
        } else {
            Rectangle bounds = tree.getPathBounds(this.treePath);
            if (pt.y <= bounds.y + this.hotspot) {
                this.from = bounds.getLocation();
                this.to = new Point(this.from.x + bounds.width, this.from.y);
                this.before = Boolean.TRUE;
            } else if (pt.y >= bounds.y + bounds.height - this.hotspot) {
                this.from = new Point(bounds.x, bounds.y + bounds.height);
                this.to = new Point(this.from.x + bounds.width, this.from.y);
                this.before = Boolean.FALSE;
            } else {
                this.to = null;
                this.from = null;
                this.before = null;
            }
            if (this.from != null && this.to != null) {
                this.from = SwingUtilities.convertPoint(tree, this.from, this.glassPane);
                this.to = SwingUtilities.convertPoint(tree, this.to, this.glassPane);
                tree.clearSelection();
            } else {
                tree.setSelectionPath(this.treePath);
            }
        }
        this.glassPane.getRootPane().repaint();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        JTree tree = (JTree)dtde.getDropTargetContext().getComponent();
        Point location = dtde.getLocation();
        JRootPane rootPane = tree.getRootPane();
        this.oldGlassPane = rootPane.getGlassPane();
        rootPane.setGlassPane(this.glassPane);
        this.glassPane.setOpaque(false);
        this.glassPane.setVisible(true);
        this.updateLine(tree, location);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        JTree tree = (JTree)dtde.getDropTargetContext().getComponent();
        Point location = dtde.getLocation();
        this.updateLine(tree, location);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    private void resetGlassPane(DropTargetEvent dte) {
        JTree tree = (JTree)dte.getDropTargetContext().getComponent();
        JRootPane rootPane = tree.getRootPane();
        rootPane.setGlassPane(this.oldGlassPane);
        this.oldGlassPane.setVisible(false);
        rootPane.repaint();
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.resetGlassPane(dte);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        this.resetGlassPane(dtde);
    }
}

