/*
 * Decompiled with CFR 0.152.
 */
package viz.panel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import viz.DensiTree;
import viz.panel.ImportRootCanalDialog;
import viz.panel.RoundedButton;
import viz.util.Util;

public class ShowPanel
extends JPanel
implements ChangeListener {
    public static final String HELP_CONSENSUS_TREES = "Display consensus trees. There is one consensus tree for every topology in the tree set. The height of the nodes are the average of the heights for that topology.";
    public static final String HELP_ALL_TREES = "Show all trees in the tree set.";
    public static final String HELP_ROOT_CANAL = "Show root canal tree. This is a single summary tree representing the complete tree set. There are many ways to construct a summary tree.";
    public static final String HELP_ROOT_CANAL_NUMBER = "Select root canal tree to display.";
    public static final String HELP_IMPORT = "Import root canal tree from Newick or from the summary_tree program.";
    public static final String HELP_ROOT_AT_TOP = "Display the root at the top of the display instead of on the left hand side.";
    public static final String HELP_EDIT_TREE = "Display edit tree for manipulating order of tree and position of internal nodes. Works only with default drawing style.";
    private static final long serialVersionUID = 1L;
    DensiTree m_dt;
    JCheckBox chckbxShowEditTree = new JCheckBox("Edit Tree");
    JComboBox<String> comboBox = new JComboBox();
    JCheckBox checkBoxShowRotoCanal;
    RoundedButton btnImport;

    public ShowPanel(DensiTree dt) {
        this.m_dt = dt;
        this.m_dt.addChangeListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWeights = new double[]{0.0, 1.0};
        this.setLayout(gridBagLayout);
        JCheckBox checkBox_1 = new JCheckBox("Consensus Trees");
        checkBox_1.setSelected(this.m_dt.m_bViewCTrees);
        checkBox_1.addActionListener(e -> {
            boolean bPrev = this.m_dt.m_bViewCTrees;
            this.m_dt.m_bViewCTrees = ((JCheckBox)e.getSource()).isSelected();
            if (bPrev != this.m_dt.m_bViewCTrees) {
                this.m_dt.makeDirty();
            }
        });
        GridBagConstraints gbc_checkBox_1 = new GridBagConstraints();
        gbc_checkBox_1.gridwidth = 2;
        gbc_checkBox_1.insets = new Insets(0, 0, 5, 0);
        gbc_checkBox_1.anchor = 18;
        gbc_checkBox_1.gridx = 0;
        gbc_checkBox_1.gridy = 0;
        this.add((Component)checkBox_1, gbc_checkBox_1);
        JCheckBox checkBox = new JCheckBox("All Trees");
        checkBox.setSelected(this.m_dt.m_bViewAllTrees);
        checkBox.addActionListener(e -> {
            boolean bPrev = this.m_dt.m_bViewAllTrees;
            this.m_dt.m_bViewAllTrees = ((JCheckBox)e.getSource()).isSelected();
            if (bPrev != this.m_dt.m_bViewAllTrees) {
                this.m_dt.makeDirty();
            }
        });
        GridBagConstraints gbc_checkBox = new GridBagConstraints();
        gbc_checkBox.gridwidth = 2;
        gbc_checkBox.insets = new Insets(0, 0, 5, 0);
        gbc_checkBox.anchor = 18;
        gbc_checkBox.gridx = 0;
        gbc_checkBox.gridy = 1;
        this.add((Component)checkBox, gbc_checkBox);
        this.checkBoxShowRotoCanal = new JCheckBox("Root Canal");
        this.checkBoxShowRotoCanal.setSelected(this.m_dt.m_bShowRootCanalTopology);
        this.checkBoxShowRotoCanal.addActionListener(e -> {
            boolean bPrev = this.m_dt.m_bShowRootCanalTopology;
            this.m_dt.m_bShowRootCanalTopology = ((JCheckBox)e.getSource()).isSelected();
            if (bPrev != this.m_dt.m_bShowRootCanalTopology) {
                this.m_dt.makeDirty();
            }
        });
        JSeparator separator = new JSeparator();
        GridBagConstraints gbc_separator = new GridBagConstraints();
        gbc_separator.fill = 2;
        gbc_separator.gridwidth = 2;
        gbc_separator.insets = new Insets(0, 0, 5, 0);
        gbc_separator.gridx = 0;
        gbc_separator.gridy = 2;
        this.add((Component)separator, gbc_separator);
        GridBagConstraints gbc_checkBox_2 = new GridBagConstraints();
        gbc_checkBox_2.gridwidth = 2;
        gbc_checkBox_2.insets = new Insets(0, 0, 5, 0);
        gbc_checkBox_2.anchor = 18;
        gbc_checkBox_2.gridx = 0;
        gbc_checkBox_2.gridy = 3;
        this.add((Component)this.checkBoxShowRotoCanal, gbc_checkBox_2);
        JCheckBox checkBox_3 = new JCheckBox("Root At Top");
        checkBox_3.setSelected(this.m_dt.m_treeDrawer.m_bRootAtTop);
        checkBox_3.addActionListener(e -> {
            boolean bPrev = this.m_dt.m_treeDrawer.m_bRootAtTop;
            this.m_dt.m_treeDrawer.m_bRootAtTop = ((JCheckBox)e.getSource()).isSelected();
            if (bPrev != this.m_dt.m_treeDrawer.m_bRootAtTop) {
                this.m_dt.fitToScreen();
            }
        });
        this.btnImport = new RoundedButton("import");
        this.btnImport.addActionListener(e -> {
            ImportRootCanalDialog dlg = new ImportRootCanalDialog(this.m_dt);
            if (dlg.showDialog(null)) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.comboBox.getModel();
                model.addElement(String.valueOf(this.comboBox.getItemCount() + 1));
                this.comboBox.setSelectedIndex(this.comboBox.getItemCount() - 1);
                this.m_dt.calcPositions();
                this.m_dt.calcLines();
                this.m_dt.makeDirty();
            }
        });
        ArrayList<String> labels = new ArrayList<String>();
        int i = 0;
        while (i < this.m_dt.m_summaryTree.size()) {
            labels.add("" + (i + 1));
            ++i;
        }
        this.comboBox = new JComboBox<String>(labels.toArray(new String[0]));
        this.comboBox.addActionListener(e -> {
            int i = this.comboBox.getSelectedIndex();
            if (this.m_dt.m_summaryTree != null && i >= 0 && i < this.m_dt.m_summaryTree.size() - 1) {
                this.m_dt.m_rootcanaltree = this.m_dt.m_summaryTree.get(i);
                this.m_dt.calcLines();
                this.m_dt.makeDirty();
            }
        });
        GridBagConstraints gbc_comboBox = new GridBagConstraints();
        gbc_comboBox.insets = new Insets(0, 0, 5, 5);
        gbc_comboBox.fill = 2;
        gbc_comboBox.gridx = 0;
        gbc_comboBox.gridy = 4;
        this.add(this.comboBox, gbc_comboBox);
        GridBagConstraints gbc_btnImport = new GridBagConstraints();
        gbc_btnImport.insets = new Insets(0, 0, 5, 0);
        gbc_btnImport.gridx = 1;
        gbc_btnImport.gridy = 4;
        this.add((Component)this.btnImport, gbc_btnImport);
        JSeparator separator_1 = new JSeparator();
        GridBagConstraints gbc_separator_1 = new GridBagConstraints();
        gbc_separator_1.fill = 2;
        gbc_separator_1.gridwidth = 2;
        gbc_separator_1.insets = new Insets(0, 0, 5, 5);
        gbc_separator_1.gridx = 0;
        gbc_separator_1.gridy = 5;
        this.add((Component)separator_1, gbc_separator_1);
        GridBagConstraints gbc_checkBox_3 = new GridBagConstraints();
        gbc_checkBox_3.gridwidth = 2;
        gbc_checkBox_3.insets = new Insets(0, 0, 5, 0);
        gbc_checkBox_3.anchor = 18;
        gbc_checkBox_3.gridx = 0;
        gbc_checkBox_3.gridy = 6;
        this.add((Component)checkBox_3, gbc_checkBox_3);
        this.chckbxShowEditTree.addActionListener(e -> {
            boolean bPrev = this.m_dt.m_bViewEditTree;
            this.m_dt.m_bViewEditTree = ((JCheckBox)e.getSource()).isSelected();
            if (bPrev != this.m_dt.m_bViewEditTree) {
                this.m_dt.makeDirty();
            }
        });
        GridBagConstraints gbc_chckbxShowEditTree = new GridBagConstraints();
        gbc_chckbxShowEditTree.gridwidth = 2;
        gbc_chckbxShowEditTree.anchor = 17;
        gbc_chckbxShowEditTree.gridx = 0;
        gbc_chckbxShowEditTree.gridy = 7;
        this.add((Component)this.chckbxShowEditTree, gbc_chckbxShowEditTree);
        this.stateChanged(null);
        checkBox_1.setToolTipText(Util.formatToolTipAsHtml(HELP_CONSENSUS_TREES));
        checkBox.setToolTipText(Util.formatToolTipAsHtml(HELP_ALL_TREES));
        checkBox_3.setToolTipText(Util.formatToolTipAsHtml(HELP_ROOT_AT_TOP));
        this.chckbxShowEditTree.setToolTipText(Util.formatToolTipAsHtml(HELP_EDIT_TREE));
        this.comboBox.setToolTipText(Util.formatToolTipAsHtml(HELP_ROOT_CANAL_NUMBER));
        this.checkBoxShowRotoCanal.setToolTipText(Util.formatToolTipAsHtml(HELP_ROOT_CANAL));
        this.btnImport.setToolTipText(Util.formatToolTipAsHtml(HELP_IMPORT));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.chckbxShowEditTree.setEnabled(this.m_dt.m_Xmode == 0);
        if (this.m_dt.m_summaryTree != null && this.m_dt.m_summaryTree.size() > 0) {
            int i = 0;
            while (i < this.m_dt.m_summaryTree.size() && i < this.comboBox.getItemCount()) {
                if (this.m_dt.m_rootcanaltree == this.m_dt.m_summaryTree.get(i)) {
                    this.comboBox.setSelectedIndex(i);
                }
                ++i;
            }
            if (this.comboBox.getItemCount() != this.m_dt.m_summaryTree.size()) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.comboBox.getModel();
                model.removeAllElements();
                int i2 = 0;
                while (i2 < this.m_dt.m_summaryTree.size()) {
                    model.addElement("" + (i2 + 1));
                    ++i2;
                }
            }
        }
        this.comboBox.setEnabled(this.m_dt.m_rootcanaltree != null);
        this.checkBoxShowRotoCanal.setEnabled(this.m_dt.m_rootcanaltree != null);
        this.btnImport.setEnabled(this.m_dt.m_rootcanaltree != null);
        System.err.println("rootcanaltree = " + (this.m_dt.m_rootcanaltree != null));
    }
}

