/*
 * Decompiled with CFR 0.152.
 */
package viz.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import viz.DensiTree;
import viz.panel.RoundedButton;
import viz.util.Util;

public class GeoPanel
extends JPanel {
    public static final String HELP_SHOW_GEO_INFO = "Show lines linking tip labels with geographic location of tip sample. Line only show up if goegraphic locations are specified using the 'load locations' function.";
    public static final String HELP_LINE_WIDTH = "Width of the line used to link tips with geo locations.";
    public static final String HELP_LOAD_LOCATIONS = "Load locations from KML file. The locations can be specified in google earth and saved in a KML file.";
    public static final String HELP_COLOR = "Color of the line used to link tips with geo locations.";
    private static final long serialVersionUID = 1L;
    DensiTree m_dt;
    SpinnerNumberModel model;

    public GeoPanel(DensiTree dt) {
        this.m_dt = dt;
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[3];
        gridBagLayout.rowHeights = new int[6];
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JCheckBox chckbxShowGeoInfo = new JCheckBox("<html>Show geo info<br>(if any)</html>");
        chckbxShowGeoInfo.setToolTipText(Util.formatToolTipAsHtml(HELP_SHOW_GEO_INFO));
        chckbxShowGeoInfo.setSelected(this.m_dt.m_bDrawGeo);
        chckbxShowGeoInfo.addActionListener(e -> {
            boolean bPrev = this.m_dt.m_bDrawGeo;
            this.m_dt.m_bDrawGeo = ((JCheckBox)e.getSource()).isSelected();
            if (bPrev != this.m_dt.m_bDrawGeo) {
                this.m_dt.makeDirty();
            }
        });
        GridBagConstraints gbc_chckbxShowGeoInfo = new GridBagConstraints();
        gbc_chckbxShowGeoInfo.gridwidth = 2;
        gbc_chckbxShowGeoInfo.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxShowGeoInfo.gridx = 0;
        gbc_chckbxShowGeoInfo.gridy = 0;
        this.add((Component)chckbxShowGeoInfo, gbc_chckbxShowGeoInfo);
        JLabel lblLineWidth = new JLabel("Line width");
        lblLineWidth.setToolTipText(Util.formatToolTipAsHtml(HELP_LINE_WIDTH));
        GridBagConstraints gbc_lblLineWidth = new GridBagConstraints();
        gbc_lblLineWidth.anchor = 13;
        gbc_lblLineWidth.insets = new Insets(0, 0, 5, 5);
        gbc_lblLineWidth.gridx = 0;
        gbc_lblLineWidth.gridy = 2;
        this.add((Component)lblLineWidth, gbc_lblLineWidth);
        this.model = new SpinnerNumberModel(this.m_dt.m_nGeoWidth, 1, 100, 1);
        JSpinner spinner = new JSpinner(this.model);
        spinner.setToolTipText(Util.formatToolTipAsHtml(HELP_LINE_WIDTH));
        GridBagConstraints gbc_spinner = new GridBagConstraints();
        gbc_spinner.anchor = 17;
        gbc_spinner.insets = new Insets(0, 0, 5, 0);
        gbc_spinner.gridx = 1;
        gbc_spinner.gridy = 2;
        this.add((Component)spinner, gbc_spinner);
        this.model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    String str = GeoPanel.this.model.getValue().toString();
                    GeoPanel.this.m_dt.m_nGeoWidth = Integer.parseInt(str);
                    GeoPanel.this.m_dt.m_Panel.clearImage();
                    GeoPanel.this.m_dt.repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        RoundedButton btnLoadLocations = new RoundedButton("<html>Load<br>locations</html>");
        btnLoadLocations.setToolTipText(Util.formatToolTipAsHtml(HELP_LOAD_LOCATIONS));
        btnLoadLocations.setText("<html>Load locations</html>");
        btnLoadLocations.addActionListener(e -> this.m_dt.a_loadkml.actionPerformed(e));
        GridBagConstraints gbc_btnLoadLocations = new GridBagConstraints();
        gbc_btnLoadLocations.gridwidth = 2;
        gbc_btnLoadLocations.fill = 2;
        gbc_btnLoadLocations.insets = new Insets(0, 0, 5, 5);
        gbc_btnLoadLocations.gridx = 0;
        gbc_btnLoadLocations.gridy = 3;
        this.add((Component)btnLoadLocations, gbc_btnLoadLocations);
        RoundedButton btnLineColor = new RoundedButton("Color");
        btnLineColor.setToolTipText(Util.formatToolTipAsHtml(HELP_COLOR));
        btnLineColor.addActionListener(e -> {
            Color newColor = JColorChooser.showDialog(this.m_dt.m_Panel, this.getName(), this.m_dt.m_color[DensiTree.GEOCOLOR]);
            if (newColor != null) {
                this.m_dt.m_color[DensiTree.GEOCOLOR] = newColor;
                this.m_dt.makeDirty();
            }
            this.m_dt.repaint();
        });
        GridBagConstraints gbc_btnLineColor = new GridBagConstraints();
        gbc_btnLineColor.gridwidth = 2;
        gbc_btnLineColor.fill = 2;
        gbc_btnLineColor.gridx = 0;
        gbc_btnLineColor.gridy = 4;
        this.add((Component)btnLineColor, gbc_btnLineColor);
    }
}

