/*
 * Decompiled with CFR 0.152.
 */
package viz.graphics;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import viz.graphics.BufferedImageF;

public class BranchDrawer {
    static final int MAX_LINE_WIDTH = 400;

    public void draw(BufferedImageF image, int color, Graphics2D g, int x1, int y1, int x2, int y2, float fBottomWidth, float fTopWidth) {
        if (x1 == -1 || x2 == -1 || y1 == -1 || y2 == -1) {
            x1 = Math.max(x1, 0);
            x2 = Math.max(x2, 0);
            y1 = Math.max(y1, 0);
            y2 = Math.max(y2, 0);
            if (x1 < 2 && x2 < 2 && y1 < 2 && y2 < 2) {
                return;
            }
        }
        if (Math.abs(x1 - x2) < 2 && Math.abs(y1 - y2) < 2) {
            return;
        }
        int nRed = color >> 16 & 0xFF;
        int nGreen = color >> 8 & 0xFF;
        int nBlue = color >> 0 & 0xFF;
        float fAlpha = ((AlphaComposite)g.getComposite()).getAlpha();
        float fLineWidth = Math.min(((BasicStroke)g.getStroke()).getLineWidth(), 400.0f);
        this.lineAA(image, x1, y1, x2, y2, fAlpha, nRed <<= 16, nGreen <<= 16, nBlue <<= 16, fLineWidth);
    }

    void lineAA(BufferedImageF image, int x1, int y1, int x2, int y2, float fAlpha, int nRed, int nGreen, int nBlue, float fLineWidth) {
        int i;
        int i2;
        int h;
        boolean steep;
        boolean bl = steep = Math.abs(y2 - y1) > Math.abs(x2 - x1);
        if (steep) {
            h = x1;
            x1 = y1;
            y1 = h;
            h = x2;
            x2 = y2;
            y2 = h;
        }
        if (x2 < x1) {
            h = x1;
            x1 = x2;
            x2 = h;
            h = y1;
            y1 = y2;
            y2 = h;
        }
        float dx = x2 - x1;
        float dy = y2 - y1;
        float gradient = dy / dx;
        int xend = this.round(x1);
        float yend = (int)((float)y1 + gradient * (float)(xend - x1));
        float xgap = this.rfpart((float)x1 + 0.5f);
        int xpxl1 = x1;
        int ypxl1 = y1;
        if (steep) {
            image.plot(ypxl1, xpxl1, this.rfpart(yend) * xgap * fAlpha, nRed, nGreen, nBlue);
            i2 = 1;
            while (i2 < (int)fLineWidth) {
                image.plot(ypxl1 + i2, xpxl1, fAlpha, nRed, nGreen, nBlue);
                ++i2;
            }
            image.plot(ypxl1 + (int)fLineWidth, xpxl1, this.fpart(yend) * xgap * fAlpha, nRed, nGreen, nBlue);
        } else {
            image.plot(xpxl1, ypxl1, this.rfpart(yend) * xgap * fAlpha, nRed, nGreen, nBlue);
            i2 = 1;
            while (i2 < (int)fLineWidth) {
                image.plot(xpxl1, ypxl1 + i2, fAlpha, nRed, nGreen, nBlue);
                ++i2;
            }
            image.plot(xpxl1, ypxl1 + (int)fLineWidth, this.fpart(yend) * xgap * fAlpha, nRed, nGreen, nBlue);
        }
        float intery = (float)y1 + gradient;
        xend = this.round(x2);
        yend = (float)y2 + gradient * (float)(xend - x2);
        xgap = this.fpart((float)x2 + 0.5f);
        int xpxl2 = x2;
        int ypxl2 = y2;
        if (steep) {
            image.plot(ypxl2, xpxl2, this.rfpart(yend) * xgap * fAlpha, nRed, nGreen, nBlue);
            i = 1;
            while (i < (int)fLineWidth) {
                image.plot(ypxl2 + i, xpxl2, fAlpha, nRed, nGreen, nBlue);
                ++i;
            }
            image.plot(ypxl2, xpxl2 + (int)fLineWidth, this.fpart(yend) * xgap * fAlpha, nRed, nGreen, nBlue);
        } else {
            image.plot(xpxl2, ypxl2, this.rfpart(yend) * xgap * fAlpha, nRed, nGreen, nBlue);
            i = 1;
            while (i < (int)fLineWidth) {
                image.plot(xpxl2, ypxl2 + i, fAlpha, nRed, nGreen, nBlue);
                ++i;
            }
            image.plot(xpxl2, ypxl2 + (int)fLineWidth, this.fpart(yend) * xgap * fAlpha, nRed, nGreen, nBlue);
        }
        int x = xpxl1 + 1;
        while (x < xpxl2) {
            int i3;
            int y;
            if (steep) {
                y = (int)intery;
                image.plot(y, x, this.rfpart(intery) * fAlpha, nRed, nGreen, nBlue);
                i3 = 1;
                while (i3 < (int)fLineWidth) {
                    image.plot(y + i3, x, fAlpha, nRed, nGreen, nBlue);
                    ++i3;
                }
                image.plot(y + (int)fLineWidth, x, this.fpart(intery) * fAlpha, nRed, nGreen, nBlue);
            } else {
                y = (int)intery;
                image.plot(x, (int)intery, this.rfpart(intery) * fAlpha, nRed, nGreen, nBlue);
                i3 = 1;
                while (i3 < (int)fLineWidth) {
                    image.plot(x, y + i3, fAlpha, nRed, nGreen, nBlue);
                    ++i3;
                }
                image.plot(x, y + (int)fLineWidth, this.fpart(intery) * fAlpha, nRed, nGreen, nBlue);
            }
            intery += gradient;
            ++x;
        }
    }

    float fpart(float x) {
        return x - (float)((int)x);
    }

    float rfpart(float x) {
        return 1.0f - this.fpart(x);
    }

    int round(double x) {
        return (int)(x + 0.5);
    }
}

