/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.DifferentiableUnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverImpl;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverUtils;

public class NewtonSolver
extends UnivariateRealSolverImpl {
    @Deprecated
    public NewtonSolver(DifferentiableUnivariateRealFunction differentiableUnivariateRealFunction) {
        super(differentiableUnivariateRealFunction, 100, 1.0E-6);
    }

    public NewtonSolver() {
        super(100, 1.0E-6);
    }

    @Override
    @Deprecated
    public double solve(double d, double d2) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve(this.f, d, d2);
    }

    @Override
    @Deprecated
    public double solve(double d, double d2, double d3) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve(this.f, d, d2, d3);
    }

    @Override
    public double solve(UnivariateRealFunction univariateRealFunction, double d, double d2) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve(univariateRealFunction, d, d2, UnivariateRealSolverUtils.midpoint(d, d2));
    }

    @Override
    public double solve(UnivariateRealFunction univariateRealFunction, double d, double d2, double d3) throws MaxIterationsExceededException, FunctionEvaluationException {
        try {
            UnivariateRealFunction univariateRealFunction2 = ((DifferentiableUnivariateRealFunction)univariateRealFunction).derivative();
            this.clearResult();
            this.verifySequence(d, d3, d2);
            double d4 = d3;
            for (int i = 0; i < this.maximalIterationCount; ++i) {
                double d5 = d4 - univariateRealFunction.value(d4) / univariateRealFunction2.value(d4);
                if (Math.abs(d5 - d4) <= this.absoluteAccuracy) {
                    this.setResult(d5, i);
                    return d5;
                }
                d4 = d5;
            }
            throw new MaxIterationsExceededException(this.maximalIterationCount);
        }
        catch (ClassCastException classCastException) {
            throw MathRuntimeException.createIllegalArgumentException("function is not differentiable", new Object[0]);
        }
    }
}

