/*
 * Decompiled with CFR 0.152.
 */
package jam.panels;

import jam.util.IconUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class SplitterHandlePanel
extends JPanel {
    private final JButton handleButton;
    private final JSplitPane splitPane;
    private static BufferedImage backgroundImage = null;
    private static Icon addIcon = IconUtils.getIcon(SplitterHandlePanel.class, "images/splitter/add.png");
    private static Icon handleIcon = IconUtils.getIcon(SplitterHandlePanel.class, "images/splitter/handle.png");

    static {
        try {
            backgroundImage = IconUtils.getBufferedImage(SplitterHandlePanel.class, "images/splitter/background.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SplitterHandlePanel(JSplitPane splitPane) {
        this(splitPane, true);
    }

    public SplitterHandlePanel(JSplitPane splitPane, boolean useActionButton) {
        this.splitPane = splitPane;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JButton addButton = new JButton("+");
        addButton.putClientProperty("JButton.buttonType", "toolbar");
        if (addIcon != null) {
            addButton.setIcon(addIcon);
            addButton.setText(null);
            addButton.setPreferredSize(new Dimension(addIcon.getIconWidth(), addIcon.getIconHeight()));
        }
        addButton.setBorderPainted(false);
        addButton.setOpaque(false);
        addButton.setContentAreaFilled(false);
        JPanel blankPanel = new JPanel(new BorderLayout()){

            @Override
            public void paint(Graphics graphics) {
                graphics.drawImage(backgroundImage, 0, 0, this.getWidth(), this.getHeight(), null);
                super.paint(graphics);
            }
        };
        blankPanel.setOpaque(false);
        this.handleButton = new JButton("|||");
        this.handleButton.putClientProperty("JButton.buttonType", "toolbar");
        if (handleIcon != null) {
            this.handleButton.setIcon(handleIcon);
            this.handleButton.setText(null);
            this.handleButton.setPreferredSize(new Dimension(handleIcon.getIconWidth(), handleIcon.getIconHeight()));
        }
        this.handleButton.setBorderPainted(false);
        this.handleButton.setOpaque(false);
        this.handleButton.setContentAreaFilled(false);
        new DragHandler(this.handleButton);
        this.add((Component)addButton, "West");
        this.add((Component)blankPanel, "Center");
        this.add((Component)this.handleButton, "East");
    }

    public class DragHandler
    extends MouseAdapter {
        private JComponent component;
        private int dividerLocation;
        private int pressedLocation;

        public DragHandler(JComponent component) {
            this.component = component;
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
        }

        public void dispose() {
            this.component.removeMouseListener(this);
            this.component.removeMouseMotionListener(this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.dividerLocation = SplitterHandlePanel.this.splitPane.getDividerLocation();
            this.pressedLocation = e.getX();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int x = this.dividerLocation + (e.getX() - this.pressedLocation);
            int min = SplitterHandlePanel.this.splitPane.getMinimumDividerLocation();
            int max = SplitterHandlePanel.this.splitPane.getMaximumDividerLocation();
            final int newLocation = x < min ? min : (x > max ? max : x);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SplitterHandlePanel.this.splitPane.setDividerLocation(newLocation);
                }
            });
        }
    }
}

