/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree.coalescent;

import beast.core.CalculationNode;
import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.evolution.tree.coalescent.PopulationFunction;
import java.util.List;

@Description(value="Scale a demographic function by a constant factor")
public class ScaledPopulationFunction
extends PopulationFunction.Abstract {
    public final Input<PopulationFunction> popParameterInput = new Input("population", "population function to scale. ", Input.Validate.REQUIRED);
    public final Input<RealParameter> scaleFactorInput = new Input("factor", "scale population by this facor.", Input.Validate.REQUIRED);

    @Override
    public List<String> getParameterIds() {
        List<String> list = this.popParameterInput.get().getParameterIds();
        list.add(this.scaleFactorInput.get().getID());
        return list;
    }

    @Override
    public double getPopSize(double d) {
        return this.popParameterInput.get().getPopSize(d) * this.scaleFactorInput.get().getValue();
    }

    @Override
    public double getIntensity(double d) {
        double d2 = this.popParameterInput.get().getIntensity(d);
        double d3 = this.scaleFactorInput.get().getValue();
        return d2 / d3;
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new RuntimeException("unimplemented");
    }

    @Override
    protected boolean requiresRecalculation() {
        return ((CalculationNode)((Object)this.popParameterInput.get())).isDirtyCalculation() || this.scaleFactorInput.get().somethingIsDirty();
    }
}

