/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.core.Input;
import beast.core.util.Log;
import beast.evolution.alignment.Taxon;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.operators.TreeOperator;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.util.Randomizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Description(value="Tree operator which randomly changes the height of a node, then reconstructs the tree from node heights.")
public class NodeReheight
extends TreeOperator {
    public final Input<TaxonSet> taxonSetInput = new Input("taxonset", "taxon set describing species tree taxa and their gene trees", Input.Validate.REQUIRED);
    public final Input<List<Tree>> geneTreesInput = new Input("genetree", "list of gene trees that constrain species tree movement", new ArrayList());
    Node[] m_nodes;
    List<Map<Integer, Integer>> m_taxonMap;
    int nrOfGeneTrees;
    int nrOfSpecies;

    @Override
    public void initAndValidate() {
        Object object;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        List<Taxon> list = this.taxonSetInput.get().taxonsetInput.get();
        if (list.size() <= 1) {
            Log.err.println("NodeReheight operator requires at least 2 taxa while the taxon set (id=" + this.taxonSetInput.get().getID() + ") has only " + list.size() + " taxa. " + "If the XML file was set up in BEAUti, this probably means a taxon assignment needs to be set up in the taxonset panel.");
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Taxon bEASTObject = list.get(i);
            object = (TaxonSet)bEASTObject;
            for (Taxon taxon : ((TaxonSet)object).taxonsetInput.get()) {
                hashMap.put(taxon.getID(), i);
            }
        }
        this.m_taxonMap = new ArrayList<Map<Integer, Integer>>();
        for (Tree tree : this.geneTreesInput.get()) {
            object = new HashMap();
            this.setupTaxaMap(tree.getRoot(), (Map<Integer, Integer>)object, hashMap);
            this.m_taxonMap.add((Map<Integer, Integer>)object);
        }
        this.nrOfGeneTrees = this.geneTreesInput.get().size();
        this.nrOfSpecies = ((Tree)this.treeInput.get()).getLeafNodeCount();
    }

    private void setupTaxaMap(Node node, Map<Integer, Integer> map, Map<String, Integer> map2) {
        if (node.isLeaf()) {
            map.put(node.getNr(), map2.get(node.getID()));
        } else {
            this.setupTaxaMap(node.getLeft(), map, map2);
            this.setupTaxaMap(node.getRight(), map, map2);
        }
    }

    @Override
    public double proposal() {
        Tree tree = (Tree)this.treeInput.get();
        this.m_nodes = tree.getNodesAsArray();
        int n = tree.getNodeCount();
        tree.startEditing(this);
        this.reorder(tree.getRoot());
        double[] dArray = new double[n];
        int[] nArray = new int[n];
        this.collectHeights(tree.getRoot(), dArray, nArray, 0);
        int n2 = Randomizer.nextInt(dArray.length);
        while (this.m_nodes[nArray[n2]].isLeaf()) {
            n2 = Randomizer.nextInt(dArray.length);
        }
        double d = this.calcMaxHeight(nArray, n2);
        dArray[n2] = Randomizer.nextDouble() * d;
        this.m_nodes[nArray[n2]].setHeight(dArray[n2]);
        Node node = this.reconstructTree(dArray, nArray, 0, dArray.length, new boolean[dArray.length]);
        assert (this.checkConsistency(node, new boolean[dArray.length]));
        node.setParent(null);
        tree.setRoot(node);
        return 0.0;
    }

    private boolean checkConsistency(Node node, boolean[] blArray) {
        if (blArray[node.getNr()]) {
            return false;
        }
        blArray[node.getNr()] = true;
        if (node.isLeaf()) {
            return true;
        }
        return this.checkConsistency(node.getLeft(), blArray) && this.checkConsistency(node.getRight(), blArray);
    }

    private double calcMaxHeight(int[] nArray, int n) {
        Node[] nodeArray;
        int n2;
        double[][] dArray = new double[this.nrOfSpecies][this.nrOfSpecies];
        for (n2 = 0; n2 < this.nrOfSpecies; ++n2) {
            Arrays.fill(dArray[n2], Double.POSITIVE_INFINITY);
        }
        for (n2 = 0; n2 < this.nrOfGeneTrees; ++n2) {
            nodeArray = this.geneTreesInput.get().get(n2);
            this.findMaximaInGeneTree(nodeArray.getRoot(), new boolean[this.nrOfSpecies], this.m_taxonMap.get(n2), dArray);
        }
        boolean[] blArray = new boolean[this.nrOfSpecies];
        nodeArray = ((Tree)this.treeInput.get()).getNodesAsArray();
        for (int i = 0; i < n; ++i) {
            Node node = nodeArray[nArray[i]];
            if (!node.isLeaf()) continue;
            blArray[node.getNr()] = true;
        }
        boolean[] blArray2 = new boolean[this.nrOfSpecies];
        for (int i = n + 1; i < nodeArray.length; ++i) {
            Node node = nodeArray[nArray[i]];
            if (!node.isLeaf()) continue;
            blArray2[node.getNr()] = true;
        }
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.nrOfSpecies; ++i) {
            if (!blArray[i]) continue;
            for (int j = 0; j < this.nrOfSpecies; ++j) {
                if (j == i || !blArray2[j]) continue;
                int n3 = Math.min(i, j);
                int n4 = Math.max(i, j);
                d = Math.min(d, dArray[n3][n4]);
            }
        }
        return d;
    }

    private void findMaximaInGeneTree(Node node, boolean[] blArray, Map<Integer, Integer> map, double[][] dArray) {
        if (node.isLeaf()) {
            int n = map.get(node.getNr());
            blArray[n] = true;
        } else {
            int n;
            boolean[] blArray2 = new boolean[this.nrOfSpecies];
            this.findMaximaInGeneTree(node.getLeft(), blArray2, map, dArray);
            boolean[] blArray3 = new boolean[this.nrOfSpecies];
            this.findMaximaInGeneTree(node.getRight(), blArray3, map, dArray);
            for (n = 0; n < this.nrOfSpecies; ++n) {
                if (!blArray2[n]) continue;
                for (int i = 0; i < this.nrOfSpecies; ++i) {
                    if (i == n || !blArray3[i]) continue;
                    int n2 = Math.min(n, i);
                    int n3 = Math.max(n, i);
                    dArray[n2][n3] = Math.min(dArray[n2][n3], node.getHeight());
                }
            }
            for (n = 0; n < this.nrOfSpecies; ++n) {
                blArray[n] = blArray2[n] | blArray3[n];
            }
        }
    }

    private Node reconstructTree(double[] dArray, int[] nArray, int n, int n2, boolean[] blArray) {
        int n3;
        int n4 = -1;
        double d = Double.NEGATIVE_INFINITY;
        for (int i = n; i < n2; ++i) {
            if (!(d < dArray[i]) || this.m_nodes[nArray[i]].isLeaf()) continue;
            d = dArray[i];
            n4 = i;
        }
        if (n4 < 0) {
            return null;
        }
        Node node = this.m_nodes[nArray[n4]];
        int n5 = -1;
        d = Double.NEGATIVE_INFINITY;
        for (n3 = n; n3 < n4; ++n3) {
            if (!(d < dArray[n3]) || blArray[n3]) continue;
            d = dArray[n3];
            n5 = n3;
        }
        n3 = -1;
        d = Double.NEGATIVE_INFINITY;
        for (int i = n4 + 1; i < n2; ++i) {
            if (!(d < dArray[i]) || blArray[i]) continue;
            d = dArray[i];
            n3 = i;
        }
        node.setLeft(this.m_nodes[nArray[n5]]);
        node.getLeft().setParent(node);
        node.setRight(this.m_nodes[nArray[n3]]);
        node.getRight().setParent(node);
        if (node.getLeft().isLeaf()) {
            dArray[n5] = Double.NEGATIVE_INFINITY;
        }
        if (node.getRight().isLeaf()) {
            dArray[n3] = Double.NEGATIVE_INFINITY;
        }
        blArray[n5] = true;
        blArray[n3] = true;
        dArray[n4] = Double.NEGATIVE_INFINITY;
        this.reconstructTree(dArray, nArray, n, n4, blArray);
        this.reconstructTree(dArray, nArray, n4, n2, blArray);
        return node;
    }

    private int collectHeights(Node node, double[] dArray, int[] nArray, int n) {
        if (node.isLeaf()) {
            dArray[n] = node.getHeight();
            nArray[n] = node.getNr();
            ++n;
        } else {
            n = this.collectHeights(node.getLeft(), dArray, nArray, n);
            dArray[n] = node.getHeight();
            nArray[n] = node.getNr();
            ++n;
            n = this.collectHeights(node.getRight(), dArray, nArray, n);
        }
        return n;
    }

    private void reorder(Node node) {
        if (!node.isLeaf()) {
            if (Randomizer.nextBoolean()) {
                Node node2 = node.getLeft();
                node.setLeft(node.getRight());
                node.setRight(node2);
            }
            this.reorder(node.getLeft());
            this.reorder(node.getRight());
        }
    }
}

