/*
 * Decompiled with CFR 0.152.
 */
package beast.app.tools;

import beast.app.util.Utils;
import beast.core.util.Log;
import beast.util.AddOnManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AppStore {
    public static final String DEFAULT_ICON = "beast/app/tools/images/utility.png";
    private final String ALL = "-all-";
    JComboBox<String> packageComboBox;
    DefaultListModel<PackageApp> model = new DefaultListModel();
    JList<PackageApp> listApps;
    JButton launchButton = new JButton("Launch");
    JDialog mainDialog;

    public JDialog launchGUI() {
        this.mainDialog = new JDialog();
        this.mainDialog.setTitle("BEAST 2 Package Application Launcher");
        Box box = Box.createHorizontalBox();
        JLabel jLabel = new JLabel("Filter: ");
        this.packageComboBox = new JComboBox<String>(new String[]{"-all-"});
        this.packageComboBox.setToolTipText("Show application of the installed package(s)");
        this.packageComboBox.addActionListener(actionEvent -> {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.getSelectedItem() != null) {
                this.resetAppList(jComboBox.getSelectedItem().toString());
            }
        });
        jLabel.setLabelFor(this.packageComboBox);
        box.add(jLabel);
        box.add(this.packageComboBox);
        this.mainDialog.getContentPane().add("North", box);
        Component component = this.createList();
        this.mainDialog.getContentPane().add("Center", component);
        Box box2 = this.createButtonBox();
        this.mainDialog.getContentPane().add((Component)box2, "South");
        int n = UIManager.getFont("Label.font").getSize();
        this.mainDialog.setSize(600 * n / 13, 400 * n / 13);
        this.mainDialog.setLocationRelativeTo(null);
        return this.mainDialog;
    }

    private Component createList() {
        Box box = Box.createVerticalBox();
        box.add(Box.createGlue());
        this.listApps = new JList<PackageApp>(this.model){
            private static final long serialVersionUID = 1L;

            @Override
            public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
                int n3;
                if (n == 1 && n2 < 0 && (n3 = this.getFirstVisibleIndex()) != -1) {
                    Rectangle rectangle2 = this.getCellBounds(n3, n3);
                    if (rectangle2.y == rectangle.y && n3 != 0) {
                        Point point = rectangle2.getLocation();
                        --point.y;
                        int n4 = this.locationToIndex(point);
                        Rectangle rectangle3 = this.getCellBounds(n4, n4);
                        if (rectangle3 == null || rectangle3.y >= rectangle2.y) {
                            return 0;
                        }
                        return rectangle3.height;
                    }
                }
                return super.getScrollableUnitIncrement(rectangle, n, n2);
            }
        };
        this.listApps.setSelectionMode(0);
        this.listApps.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent(jList, object, n, bl, bl2);
                jLabel.setIcon(((PackageApp)object).icon);
                jLabel.setHorizontalTextPosition(0);
                jLabel.setVerticalTextPosition(3);
                return jLabel;
            }
        });
        this.listApps.setLayoutOrientation(2);
        this.listApps.setVisibleRowCount(-1);
        this.listApps.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    AppStore.this.launchButton.doClick();
                }
            }
        });
        this.resetAppList();
        JScrollPane jScrollPane = new JScrollPane(this.listApps);
        jScrollPane.setPreferredSize(new Dimension(660, 400));
        jScrollPane.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel("List of available package applications");
        jLabel.setLabelFor(this.listApps);
        box.add(jLabel);
        box.add(jScrollPane);
        return box;
    }

    private void resetAppList() {
        TreeSet<String> treeSet = new TreeSet<String>();
        this.model.clear();
        try {
            List<PackageApp> list = this.getPackageApps();
            Iterator<PackageApp> object = list.iterator();
            while (object.hasNext()) {
                PackageApp packageApp = object.next();
                this.model.addElement(packageApp);
                treeSet.add(packageApp.packageName);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.listApps.setSelectedIndex(0);
        this.packageComboBox.removeAllItems();
        this.packageComboBox.addItem("-all-");
        for (String string : treeSet) {
            this.packageComboBox.addItem(string);
        }
    }

    private void resetAppList(String string) {
        this.model.clear();
        try {
            List<PackageApp> list = this.getPackageApps();
            for (PackageApp packageApp : list) {
                if (!string.equals("-all-") && !string.equalsIgnoreCase(packageApp.packageName)) continue;
                this.model.addElement(packageApp);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.listApps.setSelectedIndex(0);
    }

    private Box createButtonBox() {
        Box box = Box.createHorizontalBox();
        box.add(Box.createGlue());
        this.launchButton.addActionListener(actionEvent -> {
            PackageApp packageApp = this.listApps.getSelectedValue();
            if (packageApp != null) {
                try {
                    new PackageAppThread(packageApp).start();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Launch failed because: " + exception.getMessage());
                }
            }
        });
        box.add(this.launchButton);
        JButton jButton = new JButton("Close");
        jButton.addActionListener(actionEvent -> this.mainDialog.dispose());
        box.add(Box.createGlue());
        box.add(jButton);
        box.add(Box.createGlue());
        return box;
    }

    List<PackageApp> getPackageApps() {
        ArrayList<PackageApp> arrayList = new ArrayList<PackageApp>();
        List<String> list = AddOnManager.getBeastDirectories();
        for (String string : list) {
            File file = new File(string + "/version.xml");
            if (!file.exists() || !file.isFile()) continue;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                Document document = documentBuilderFactory.newDocumentBuilder().parse(file);
                document.normalize();
                Element element = document.getDocumentElement();
                NodeList nodeList = document.getElementsByTagName("addonapp");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element2 = (Element)nodeList.item(i);
                    PackageApp packageApp = new PackageApp();
                    packageApp.packageName = element.getAttribute("name");
                    packageApp.jarDir = string;
                    packageApp.className = element2.getAttribute("class");
                    packageApp.description = element2.getAttribute("description");
                    packageApp.argumentsString = element2.getAttribute("args");
                    String string2 = element2.getAttribute("icon");
                    packageApp.icon = Utils.getIcon(string2);
                    if (packageApp.icon == null || string2.trim().isEmpty()) {
                        packageApp.icon = Utils.getIcon(DEFAULT_ICON);
                    }
                    arrayList.add(packageApp);
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
        return arrayList;
    }

    public void runAppFromCMD(PackageApp packageApp, String[] stringArray) {
        try {
            int n;
            AddOnManager.loadExternalJars();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (System.getenv("JAVA_HOME") != null) {
                arrayList.add(System.getenv("JAVA_HOME") + File.separatorChar + "bin" + File.separatorChar + "java");
            } else {
                arrayList.add("java");
            }
            if (System.getProperty("java.library.path") != null && System.getProperty("java.library.path").length() > 0) {
                arrayList.add("-Djava.library.path=" + this.sanitise(System.getProperty("java.library.path")));
            }
            arrayList.add("-cp");
            String string = this.sanitise(System.getProperty("java.class.path"));
            arrayList.add(string);
            arrayList.add(packageApp.className);
            for (String object2 : packageApp.getArgs()) {
                arrayList.add(object2);
            }
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    arrayList.add(string2);
                }
            }
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            System.err.println(processBuilder.command());
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((n = bufferedReader.read()) != -1) {
                Log.info.print((char)n);
            }
            bufferedReader.close();
            int n2 = process.waitFor();
            if (n2 != 0) {
                Log.err.println(Utils.toString(process.getErrorStream()));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String sanitise(String string) {
        if (Utils.isWindows()) {
            String string2 = System.getProperty("user.dir");
            string2 = string2.replace("\\", "/");
            string = string.replaceAll(";\\.", ";" + string2 + ".");
            string = string.replace("\\", "/");
        }
        return string;
    }

    private void printUsage(PrintStream printStream) {
        printStream.println("\nAppStore: Run installed BEAST 2 package apps.\n\nUsage:\n\tappstore\n\tappstore -help\n\tappstore -list [package_name]\n\tappstore <app_class_name|app_description>");
    }

    private void printAppList(List<PackageApp> list, PrintStream printStream) {
        int n = list.stream().mapToInt(packageApp -> packageApp.packageName.length()).max().orElse(0);
        n = Math.max(n + 1, 15);
        int n2 = list.stream().mapToInt(packageApp -> {
            String[] stringArray = packageApp.className.split("\\.");
            return stringArray[stringArray.length - 1].length();
        }).max().orElse(0);
        n2 = Math.max(n2 + 1, 15);
        String string = "%-" + n + "." + n + "s|%-" + n2 + "." + n2 + "s|%s\n";
        printStream.format(string, "Package", "Class", "Description");
        printStream.print(String.format(string, "", "", "--------------------").replace(" ", "-"));
        for (PackageApp packageApp2 : list) {
            String[] stringArray = packageApp2.className.split("\\.");
            String string2 = stringArray[stringArray.length - 1];
            printStream.format(string, packageApp2.packageName, string2, packageApp2.description);
        }
    }

    public static void main(String[] stringArray) {
        AppStore appStore = new AppStore();
        if (stringArray.length == 0) {
            Utils.loadUIManager();
            SwingUtilities.invokeLater(() -> appStore.launchGUI().setVisible(true));
        } else if (stringArray[0].startsWith("-")) {
            switch (stringArray[0]) {
                case "-help": {
                    appStore.printUsage(System.out);
                    System.exit(0);
                }
                case "-list": {
                    System.out.println("\nAvailable package apps:\n");
                    if (stringArray.length > 1) {
                        String string = stringArray[1].toLowerCase();
                        ArrayList<PackageApp> arrayList = new ArrayList<PackageApp>();
                        for (PackageApp packageApp : appStore.getPackageApps()) {
                            if (packageApp.packageName.toLowerCase().contains(string)) continue;
                            arrayList.add(packageApp);
                        }
                        appStore.printAppList(arrayList, System.out);
                    } else {
                        appStore.printAppList(appStore.getPackageApps(), System.out);
                    }
                    System.exit(0);
                }
            }
            System.err.print("\nUnsupported option.");
            appStore.printUsage(System.err);
            System.exit(1);
        } else {
            ArrayList<PackageApp> arrayList = new ArrayList<PackageApp>();
            PackageApp packageApp = null;
            for (PackageApp packageApp2 : appStore.getPackageApps()) {
                if (packageApp2.className.equals(stringArray[0]) || packageApp2.description.equals(stringArray[0])) {
                    packageApp = packageApp2;
                    continue;
                }
                if (!packageApp2.className.toLowerCase().contains(stringArray[0].toLowerCase()) && !packageApp2.description.toLowerCase().contains(stringArray[0].toLowerCase())) continue;
                arrayList.add(packageApp2);
            }
            String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            if (packageApp != null) {
                appStore.runAppFromCMD(packageApp, stringArray2);
            } else if (arrayList.size() == 1) {
                appStore.runAppFromCMD((PackageApp)arrayList.get(0), stringArray2);
            } else {
                if (arrayList.isEmpty()) {
                    System.err.println("\nNo apps match.");
                    appStore.printUsage(System.err);
                    System.exit(1);
                } else {
                    System.err.println("\nMultiple apps match:\n");
                    appStore.printAppList(arrayList, System.err);
                }
                System.exit(1);
            }
        }
    }

    class PackageAppThread
    extends Thread {
        PackageApp packageApp;

        PackageAppThread(PackageApp packageApp) {
            this.packageApp = packageApp;
        }

        @Override
        public void run() {
            AppStore.this.runAppFromCMD(this.packageApp, null);
        }
    }

    class PackageApp {
        String packageName;
        String jarDir;
        String description;
        String className;
        String argumentsString;
        ImageIcon icon;

        PackageApp() {
        }

        public String[] getArgs() {
            if (this.argumentsString == null || this.argumentsString.trim().isEmpty()) {
                return new String[0];
            }
            String[] stringArray = this.argumentsString.split(" ", -1);
            return stringArray;
        }

        public String toString() {
            return this.description;
        }
    }
}

