/*
 * Decompiled with CFR 0.152.
 */
package beast.app.draw;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.JLabel;

public class SmallLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    public Color m_circleColor = Color.blue;
    boolean m_bIsEnabled = true;

    public SmallLabel(String string, Color color) {
        super(string);
        this.enableEvents(16L);
        this.setBackground(new Color(208, 208, 255));
        this.setPreferredSize(new Dimension(15, 15));
        this.setSize(15, 15);
        this.setMinimumSize(new Dimension(15, 15));
        this.setMaximumSize(new Dimension(15, 15));
        this.m_circleColor = color;
        super.setVisible(true);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.m_bIsEnabled) {
            int n = 14;
            GradientPaint gradientPaint = new GradientPaint(new Point(0, 0), Color.WHITE, new Point(this.getWidth(), this.getHeight()), this.m_circleColor);
            ((Graphics2D)graphics).setPaint(gradientPaint);
            graphics.fillArc(0, 0, n, n, 0, 360);
            graphics.setColor(this.getBackground().darker().darker().darker());
            graphics.drawArc(0, 0, n, n, 0, 360);
            Font font = this.getFont();
            if (font != null) {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                graphics.setColor(this.getForeground());
                graphics.drawString(this.getText(), n / 2 - fontMetrics.stringWidth(this.getText()) / 2 + 0, n / 2 + fontMetrics.getMaxDescent() + 1);
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        this.m_bIsEnabled = bl;
    }
}

