/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beastapp;

import beast.app.beastapp.WholeNumberField;
import beast.app.util.Utils;
import jam.html.SimpleLinkListener;
import jam.panels.OptionsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BeastDialog {
    private final JFrame frame;
    private final OptionsPanel optionPanel;
    private final WholeNumberField seedText = new WholeNumberField(1L, Long.MAX_VALUE);
    private final JComboBox<String> logginMode = new JComboBox<String>(new String[]{"default: only write new log files", "overwrite: overwrite log files", "resume: appends log to existing files (if any)"});
    private final JCheckBox strictVersionCheckBox = new JCheckBox("Only load packages and versions specified in XML");
    private final JCheckBox beagleCheckBox = new JCheckBox("Use BEAGLE library if available:");
    private final JCheckBox beagleInfoCheckBox = new JCheckBox("Show list of available BEAGLE resources and Quit");
    private final JComboBox<Object> beagleResourceCombo = new JComboBox<Object>(new Object[]{"CPU", "GPU"});
    private final JCheckBox beagleSSECheckBox = new JCheckBox("Use CPU's SSE extensions");
    private final JComboBox<Object> beaglePrecisionCombo = new JComboBox<Object>(new Object[]{"Double", "Single"});
    private final JComboBox<Object> threadsCombo = new JComboBox<Object>(new Object[]{"Automatic", 0, 1, 2, 3, 4, 5, 6, 7, 8});
    private File inputFile = null;

    public BeastDialog(JFrame jFrame, String string, Icon icon) {
        this.frame = jFrame;
        this.optionPanel = new OptionsPanel(12, 12);
        JLabel jLabel = new JLabel(string);
        jLabel.setIcon(icon);
        this.optionPanel.addSpanningComponent(jLabel);
        Font font = UIManager.getFont("Label.font");
        jLabel.setFont(new Font("sans-serif", font.getStyle(), font.getSize()));
        JButton jButton = new JButton("Choose File...");
        JTextField jTextField = new JTextField("not selected", 16);
        jButton.addActionListener(actionEvent -> {
            File file = Utils.getLoadFile("Load xml file", this.inputFile, "Beast xml files", "xml");
            if (file != null) {
                this.inputFile = file;
                jTextField.setText(this.inputFile.getName());
            }
        });
        jTextField.setEditable(false);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)jTextField, "Center");
        jPanel.add((Component)jButton, "East");
        this.optionPanel.addComponentWithLabel("BEAST XML File: ", jPanel);
        this.optionPanel.addComponent(this.logginMode);
        this.optionPanel.addComponent(this.strictVersionCheckBox);
        this.strictVersionCheckBox.setToolTipText("Only check this box to run a file with exactly the same packages and package versions as specified in the 'required' attribute of the beast element in the XML file");
        this.optionPanel.addSeparator();
        this.seedText.setColumns(12);
        this.optionPanel.addComponentWithLabel("Random number seed: ", this.seedText);
        this.optionPanel.addComponentWithLabel("Thread pool size: ", this.threadsCombo);
        this.optionPanel.addSeparator();
        this.optionPanel.addSpanningComponent(this.beagleCheckBox);
        this.beagleCheckBox.setSelected(true);
        OptionsPanel optionsPanel = new OptionsPanel(0, 12);
        optionsPanel.setBorder(new TitledBorder(""));
        OptionsPanel optionsPanel2 = new OptionsPanel(0, 12);
        optionsPanel2.setBorder(BorderFactory.createEmptyBorder());
        final JLabel jLabel2 = optionsPanel2.addComponentWithLabel("Prefer use of: ", this.beagleResourceCombo);
        this.beagleSSECheckBox.setSelected(true);
        final JLabel jLabel3 = optionsPanel2.addComponentWithLabel("Prefer precision: ", this.beaglePrecisionCombo);
        optionsPanel2.addComponent(this.beagleInfoCheckBox);
        optionsPanel.addComponent(optionsPanel2);
        final JEditorPane jEditorPane = new JEditorPane("text/html", "<html><div style=\"font-family:sans-serif;font-size:12;\"><p>BEAGLE is a high-performance phylogenetic library that can make use of<br>additional computational resources such as graphics boards. It must be<br>downloaded and installed independently of BEAST:</p><pre><a href=\"http://beagle-lib.googlecode.com/\">http://beagle-lib.googlecode.com/</a></pre></div>");
        jEditorPane.setOpaque(false);
        jEditorPane.setEditable(false);
        jEditorPane.addHyperlinkListener(new SimpleLinkListener());
        optionsPanel.addComponent(jEditorPane);
        this.optionPanel.addSpanningComponent(optionsPanel);
        this.beagleInfoCheckBox.setEnabled(false);
        this.beagleCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                jEditorPane.setEnabled(BeastDialog.this.beagleCheckBox.isSelected());
                BeastDialog.this.beagleInfoCheckBox.setEnabled(BeastDialog.this.beagleCheckBox.isSelected());
                jLabel2.setEnabled(BeastDialog.this.beagleCheckBox.isSelected());
                BeastDialog.this.beagleResourceCombo.setEnabled(BeastDialog.this.beagleCheckBox.isSelected());
                BeastDialog.this.beagleSSECheckBox.setEnabled(BeastDialog.this.beagleCheckBox.isSelected());
                jLabel3.setEnabled(BeastDialog.this.beagleCheckBox.isSelected());
                BeastDialog.this.beaglePrecisionCombo.setEnabled(BeastDialog.this.beagleCheckBox.isSelected());
            }
        });
        this.beagleCheckBox.setSelected(false);
        this.beagleResourceCombo.setSelectedItem("CPU");
    }

    public boolean showDialog(String string, long l) {
        JOptionPane jOptionPane = new JOptionPane(this.optionPanel, -1, 2, null, new String[]{"Run", "Quit"}, "Run");
        jOptionPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.seedText.setValue(l);
        JDialog jDialog = jOptionPane.createDialog(this.frame, string);
        jDialog.pack();
        jDialog.setVisible(true);
        if (jOptionPane.getValue() == null) {
            System.exit(0);
        }
        return jOptionPane.getValue().equals("Run");
    }

    public long getSeed() {
        return this.seedText.getLongValue();
    }

    public int getLogginMode() {
        return this.logginMode.getSelectedIndex();
    }

    public boolean useStrictVersions() {
        return this.strictVersionCheckBox.isSelected();
    }

    public boolean useBeagle() {
        return this.beagleCheckBox.isSelected();
    }

    public boolean preferBeagleGPU() {
        return this.beagleResourceCombo.getSelectedItem().equals("GPU");
    }

    public boolean preferBeagleCPU() {
        return this.beagleResourceCombo.getSelectedItem().equals("CPU");
    }

    public boolean preferBeagleSSE() {
        return this.preferBeagleCPU();
    }

    public boolean preferBeagleSingle() {
        return this.beaglePrecisionCombo.getSelectedItem().equals("Single");
    }

    public boolean preferBeagleDouble() {
        return this.beaglePrecisionCombo.getSelectedItem().equals("Double");
    }

    public boolean showBeagleInfo() {
        return this.beagleInfoCheckBox.isSelected();
    }

    public int getThreadPoolSize() {
        if (this.threadsCombo.getSelectedIndex() == 0) {
            return -1;
        }
        return (Integer)this.threadsCombo.getSelectedItem();
    }

    public File getInputFile() {
        return this.inputFile;
    }
}

