/*
 * Decompiled with CFR 0.152.
 */
package beagle;

import beagle.Beagle;
import beagle.BeagleException;
import beagle.BeagleFlag;
import beagle.BeagleInfo;
import beagle.BeagleJNIImpl;
import beagle.BeagleJNIWrapper;
import beagle.GeneralBeagleImpl;
import beagle.InstanceDetails;
import beagle.ResourceDetails;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class BeagleFactory {
    private static Map<Integer, ResourceDetails> resourceDetailsMap = new HashMap<Integer, ResourceDetails>();
    private static final String human = "AGAAATATGTCTGATAAAAGAGTTACTTTGATAGAGTAAATAATAGGAGCTTAAACCCCCTTATTTCTACTAGGACTATGAGAATCGAACCCATCCCTGAGAATCCAAAATTCTCCGTGCCACCTATCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTTATACCCTTCCCGTACTAAGAAATTTAGGTTAAATACAGACCAAGAGCCTTCAAAGCCCTCAGTAAGTTG-CAATACTTAATTTCTGTAAGGACTGCAAAACCCCACTCTGCATCAACTGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGACCAATGGGACTTAAACCCACAAACACTTAGTTAACAGCTAAGCACCCTAATCAAC-TGGCTTCAATCTAAAGCCCCGGCAGG-TTTGAAGCTGCTTCTTCGAATTTGCAATTCAATATGAAAA-TCACCTCGGAGCTTGGTAAAAAGAGGCCTAACCCCTGTCTTTAGATTTACAGTCCAATGCTTCA-CTCAGCCATTTTACCACAAAAAAGGAAGGAATCGAACCCCCCAAAGCTGGTTTCAAGCCAACCCCATGGCCTCCATGACTTTTTCAAAAGGTATTAGAAAAACCATTTCATAACTTTGTCAAAGTTAAATTATAGGCT-AAATCCTATATATCTTA-CACTGTAAAGCTAACTTAGCATTAACCTTTTAAGTTAAAGATTAAGAGAACCAACACCTCTTTACAGTGA";
    private static final String chimp = "AGAAATATGTCTGATAAAAGAATTACTTTGATAGAGTAAATAATAGGAGTTCAAATCCCCTTATTTCTACTAGGACTATAAGAATCGAACTCATCCCTGAGAATCCAAAATTCTCCGTGCCACCTATCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTTACACCCTTCCCGTACTAAGAAATTTAGGTTAAGCACAGACCAAGAGCCTTCAAAGCCCTCAGCAAGTTA-CAATACTTAATTTCTGTAAGGACTGCAAAACCCCACTCTGCATCAACTGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGATTAATGGGACTTAAACCCACAAACATTTAGTTAACAGCTAAACACCCTAATCAAC-TGGCTTCAATCTAAAGCCCCGGCAGG-TTTGAAGCTGCTTCTTCGAATTTGCAATTCAATATGAAAA-TCACCTCAGAGCTTGGTAAAAAGAGGCTTAACCCCTGTCTTTAGATTTACAGTCCAATGCTTCA-CTCAGCCATTTTACCACAAAAAAGGAAGGAATCGAACCCCCTAAAGCTGGTTTCAAGCCAACCCCATGACCTCCATGACTTTTTCAAAAGATATTAGAAAAACTATTTCATAACTTTGTCAAAGTTAAATTACAGGTT-AACCCCCGTATATCTTA-CACTGTAAAGCTAACCTAGCATTAACCTTTTAAGTTAAAGATTAAGAGGACCGACACCTCTTTACAGTGA";
    private static final String gorilla = "AGAAATATGTCTGATAAAAGAGTTACTTTGATAGAGTAAATAATAGAGGTTTAAACCCCCTTATTTCTACTAGGACTATGAGAATTGAACCCATCCCTGAGAATCCAAAATTCTCCGTGCCACCTGTCACACCCCATCCTAAGTAAGGTCAGCTAAATAAGCTATCGGGCCCATACCCCGAAAATGTTGGTCACATCCTTCCCGTACTAAGAAATTTAGGTTAAACATAGACCAAGAGCCTTCAAAGCCCTTAGTAAGTTA-CAACACTTAATTTCTGTAAGGACTGCAAAACCCTACTCTGCATCAACTGAACGCAAATCAGCCACTTTAATTAAGCTAAGCCCTTCTAGATCAATGGGACTCAAACCCACAAACATTTAGTTAACAGCTAAACACCCTAGTCAAC-TGGCTTCAATCTAAAGCCCCGGCAGG-TTTGAAGCTGCTTCTTCGAATTTGCAATTCAATATGAAAT-TCACCTCGGAGCTTGGTAAAAAGAGGCCCAGCCTCTGTCTTTAGATTTACAGTCCAATGCCTTA-CTCAGCCATTTTACCACAAAAAAGGAAGGAATCGAACCCCCCAAAGCTGGTTTCAAGCCAACCCCATGACCTTCATGACTTTTTCAAAAGATATTAGAAAAACTATTTCATAACTTTGTCAAGGTTAAATTACGGGTT-AAACCCCGTATATCTTA-CACTGTAAAGCTAACCTAGCGTTAACCTTTTAAGTTAAAGATTAAGAGTATCGGCACCTCTTTGCAGTGA";

    public static String getVersionInformation() {
        BeagleFactory.getBeagleJNIWrapper();
        if (BeagleJNIWrapper.INSTANCE != null) {
            try {
                return BeagleJNIWrapper.INSTANCE.getCitation();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                return "Using BEAGLE library v1.x for accelerated, parallel likelihood evaluation\n2009-2013, BEAGLE Working Group - http://beagle-lib.googlecode.com/\nCitation: Ayres et al (2012) Systematic Biology 61: 170-173 | doi:10.1093/sysbio/syr100";
            }
        }
        return "BEAGLE not installed/found";
    }

    public static String getVersion() {
        BeagleFactory.getBeagleJNIWrapper();
        if (BeagleJNIWrapper.INSTANCE != null) {
            try {
                return BeagleJNIWrapper.INSTANCE.getVersion();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                return "1.x";
            }
        }
        return "BEAGLE not installed/found";
    }

    public static List<ResourceDetails> getResourceDetails() {
        BeagleFactory.getBeagleJNIWrapper();
        return new ArrayList<ResourceDetails>(resourceDetailsMap.values());
    }

    public static ResourceDetails getResourceDetails(int n) {
        BeagleFactory.getBeagleJNIWrapper();
        return resourceDetailsMap.get(n);
    }

    public static Beagle loadBeagleInstance(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int[] nArray, long l, long l2) {
        boolean bl = Boolean.valueOf(System.getProperty("java.only"));
        BeagleFactory.getBeagleJNIWrapper();
        if (!bl && BeagleJNIWrapper.INSTANCE != null) {
            try {
                BeagleJNIImpl beagleJNIImpl = new BeagleJNIImpl(n, n2, n3, n4, n5, n6, n7, n8, n9, nArray, l, l2);
                InstanceDetails instanceDetails = beagleJNIImpl.getDetails();
                if (instanceDetails != null) {
                    return beagleJNIImpl;
                }
            }
            catch (BeagleException beagleException) {
                Logger.getLogger("beagle").info("  " + beagleException.getMessage());
            }
        }
        if (!bl) {
            throw new RuntimeException("No acceptable BEAGLE library plugins found. Make sure that BEAGLE is properly installed or try changing resource requirements.");
        }
        return new GeneralBeagleImpl(n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    private static BeagleJNIWrapper getBeagleJNIWrapper() {
        if (BeagleJNIWrapper.INSTANCE == null) {
            try {
                BeagleJNIWrapper.loadBeagleLibrary();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.err.println("Failed to load BEAGLE library: " + unsatisfiedLinkError.getMessage());
            }
            if (BeagleJNIWrapper.INSTANCE != null) {
                for (ResourceDetails resourceDetails : BeagleJNIWrapper.INSTANCE.getResourceList()) {
                    resourceDetailsMap.put(resourceDetails.getNumber(), resourceDetails);
                }
            }
        }
        return BeagleJNIWrapper.INSTANCE;
    }

    private static int[] getStates(String string) {
        int[] nArray = new int[string.length()];
        block6: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'A': {
                    nArray[i] = 0;
                    continue block6;
                }
                case 'C': {
                    nArray[i] = 1;
                    continue block6;
                }
                case 'G': {
                    nArray[i] = 2;
                    continue block6;
                }
                case 'T': {
                    nArray[i] = 3;
                    continue block6;
                }
                default: {
                    nArray[i] = 4;
                }
            }
        }
        return nArray;
    }

    private static double[] getPartials(String string) {
        double[] dArray = new double[string.length() * 4];
        int n = 0;
        block6: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'A': {
                    dArray[n++] = 1.0;
                    dArray[n++] = 0.0;
                    dArray[n++] = 0.0;
                    dArray[n++] = 0.0;
                    continue block6;
                }
                case 'C': {
                    dArray[n++] = 0.0;
                    dArray[n++] = 1.0;
                    dArray[n++] = 0.0;
                    dArray[n++] = 0.0;
                    continue block6;
                }
                case 'G': {
                    dArray[n++] = 0.0;
                    dArray[n++] = 0.0;
                    dArray[n++] = 1.0;
                    dArray[n++] = 0.0;
                    continue block6;
                }
                case 'T': {
                    dArray[n++] = 0.0;
                    dArray[n++] = 0.0;
                    dArray[n++] = 0.0;
                    dArray[n++] = 1.0;
                    continue block6;
                }
                default: {
                    dArray[n++] = 1.0;
                    dArray[n++] = 1.0;
                    dArray[n++] = 1.0;
                    dArray[n++] = 1.0;
                }
            }
        }
        return dArray;
    }

    public static void main(String[] stringArray) {
        Object object;
        int n = 4;
        int n2 = human.length();
        BeagleInfo.printVersionInformation();
        BeagleInfo.printResourceList();
        System.setProperty("java.only", "true");
        Beagle beagle = BeagleFactory.loadBeagleInstance(3, 5, 3, n, n2, 1, 4, 1, 3, new int[]{1, 0}, 0L, 0L);
        if (beagle == null) {
            System.err.println("Failed to obtain BEAGLE instance");
            System.exit(1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        BeagleFlag[] objectArray = BeagleFlag.values();
        int dArray = objectArray.length;
        for (int dArray2 = 0; dArray2 < dArray; ++dArray2) {
            object = objectArray[dArray2];
            if (!object.isSet(beagle.getDetails().getFlags())) continue;
            stringBuilder.append(" ").append(object.name());
        }
        System.out.println("Instance on resource #" + beagle.getDetails().getResourceNumber() + " flags:" + stringBuilder.toString());
        double[] dArray2 = new double[n2];
        for (dArray = 0; dArray < n2; ++dArray) {
            dArray2[dArray] = 1.0;
        }
        beagle.setPatternWeights(dArray2);
        beagle.setTipStates(0, BeagleFactory.getStates(human));
        beagle.setTipStates(1, BeagleFactory.getStates(chimp));
        beagle.setTipStates(2, BeagleFactory.getStates(gorilla));
        double[] dArray3 = new double[]{1.0};
        beagle.setCategoryRates(dArray3);
        double[] dArray4 = new double[]{1.0};
        beagle.setCategoryWeights(0, dArray4);
        object = new double[]{0.25, 0.25, 0.25, 0.25};
        beagle.setStateFrequencies(0, (double[])object);
        double[] dArray5 = new double[]{1.0, 2.0, 0.0, 0.5, 1.0, -2.0, 0.5, 0.0, 1.0, 2.0, 0.0, -0.5, 1.0, -2.0, -0.5, 0.0};
        double[] dArray6 = new double[]{0.25, 0.25, 0.25, 0.25, 0.125, -0.125, 0.125, -0.125, 0.0, 1.0, 0.0, -1.0, 1.0, 0.0, -1.0, 0.0};
        double[] dArray7 = new double[]{0.0, -1.3333333333333333, -1.3333333333333333, -1.3333333333333333};
        beagle.setEigenDecomposition(0, dArray5, dArray6, dArray7);
        int[] nArray = new int[]{0, 1, 2, 3};
        double[] dArray8 = new double[]{0.1, 0.1, 0.2, 0.1};
        beagle.updateTransitionMatrices(0, nArray, null, null, dArray8, 4);
        beagle.resetScaleFactors(2);
        int[] nArray2 = new int[]{3, 0, 0, 0, 0, 1, 1, 4, 1, 1, 2, 2, 3, 3};
        int[] nArray3 = new int[]{4};
        beagle.updatePartials(nArray2, 2, 2);
        int[] nArray4 = new int[]{2};
        int[] nArray5 = new int[]{0};
        int[] nArray6 = new int[]{0};
        double[] dArray9 = new double[1];
        beagle.calculateRootLogLikelihoods(nArray3, nArray5, nArray6, nArray4, 1, dArray9);
        System.out.println("logL = " + dArray9[0] + " (PAUP logL = -1574.63623)");
    }
}

