/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpbf.model;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.util.IOUtils;

public abstract class HPBFPart {
    private byte[] data;

    public HPBFPart(DirectoryNode baseDir, String[] path) throws IOException {
        DirectoryNode dir = this.getDir(path, baseDir);
        String name = path[path.length - 1];
        if (!dir.hasEntry(name)) {
            throw new IllegalArgumentException("File invalid - failed to find document entry '" + name + "'");
        }
        DocumentInputStream is = dir.createDocumentInputStream(name);
        this.data = IOUtils.toByteArray((InputStream)is);
        is.close();
    }

    private DirectoryNode getDir(String[] path, DirectoryNode baseDir) {
        DirectoryNode dir = baseDir;
        for (int i = 0; i < path.length - 1; ++i) {
            try {
                dir = (DirectoryNode)dir.getEntry(path[i]);
                continue;
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("File invalid - failed to find directory entry '" + path[i] + "'");
            }
        }
        return dir;
    }

    public void writeOut(DirectoryNode baseDir) throws IOException {
        String[] path = this.getPath();
        DirectoryNode dir = baseDir;
        for (int i = 0; i < path.length - 1; ++i) {
            try {
                dir = (DirectoryNode)dir.getEntry(path[i]);
                continue;
            }
            catch (FileNotFoundException e) {
                dir.createDirectory(path[i]);
            }
        }
        this.generateData();
        ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
        dir.createDocument(path[path.length - 1], (InputStream)bais);
    }

    protected abstract void generateData();

    public final byte[] getData() {
        return this.data;
    }

    protected final void setData(byte[] data) {
        this.data = (byte[])data.clone();
    }

    public final String[] getPath() {
        return null;
    }
}

