/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.classification;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.classification.ClassificationResult;
import org.apache.lucene.classification.Classifier;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class BooleanPerceptronClassifier
implements Classifier<Boolean> {
    private final Double threshold;
    private final Terms textTerms;
    private final Analyzer analyzer;
    private final String textFieldName;
    private FST<Long> fst;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BooleanPerceptronClassifier(IndexReader indexReader, Analyzer analyzer, Query query, Integer batchSize, Double threshold, String classFieldName, String textFieldName) throws IOException {
        BytesRef textTerm;
        this.textTerms = MultiFields.getTerms((IndexReader)indexReader, (String)textFieldName);
        if (this.textTerms == null) {
            throw new IOException("term vectors need to be available for field " + textFieldName);
        }
        this.analyzer = analyzer;
        this.textFieldName = textFieldName;
        if (threshold == null || threshold == 0.0) {
            long sumDocFreq = indexReader.getSumDocFreq(textFieldName);
            if (sumDocFreq == -1L) throw new IOException("threshold cannot be assigned since term vectors for field " + textFieldName + " do not exist");
            this.threshold = (double)sumDocFreq / 2.0;
        } else {
            this.threshold = threshold;
        }
        ConcurrentSkipListMap<String, Double> weights = new ConcurrentSkipListMap<String, Double>();
        TermsEnum termsEnum = this.textTerms.iterator();
        while ((textTerm = termsEnum.next()) != null) {
            weights.put(textTerm.utf8ToString(), Double.valueOf(termsEnum.totalTermFreq()));
        }
        this.updateFST(weights);
        IndexSearcher indexSearcher = new IndexSearcher(indexReader);
        int batchCount = 0;
        BooleanQuery.Builder q = new BooleanQuery.Builder();
        q.add(new BooleanClause((Query)new WildcardQuery(new Term(classFieldName, "*")), BooleanClause.Occur.MUST));
        if (query != null) {
            q.add(new BooleanClause(query, BooleanClause.Occur.MUST));
        }
        for (ScoreDoc scoreDoc : indexSearcher.search((Query)q.build(), (int)Integer.MAX_VALUE).scoreDocs) {
            Document doc = indexSearcher.doc(scoreDoc.doc);
            IndexableField textField = doc.getField(textFieldName);
            IndexableField classField = doc.getField(classFieldName);
            if (textField == null || classField == null) continue;
            ClassificationResult<Boolean> classificationResult = this.assignClass(textField.stringValue());
            Boolean assignedClass = classificationResult.getAssignedClass();
            Boolean correctClass = Boolean.valueOf(classField.stringValue());
            long modifier = correctClass.compareTo(assignedClass);
            if (modifier != 0L) {
                this.updateWeights(indexReader, scoreDoc.doc, assignedClass, weights, modifier, batchCount % batchSize == 0);
            }
            ++batchCount;
        }
        weights.clear();
    }

    private void updateWeights(IndexReader indexReader, int docId, Boolean assignedClass, SortedMap<String, Double> weights, double modifier, boolean updateFST) throws IOException {
        BytesRef term;
        TermsEnum cte = this.textTerms.iterator();
        Terms terms = indexReader.getTermVector(docId, this.textFieldName);
        if (terms == null) {
            throw new IOException("term vectors must be stored for field " + this.textFieldName);
        }
        TermsEnum termsEnum = terms.iterator();
        while ((term = termsEnum.next()) != null) {
            cte.seekExact(term);
            if (assignedClass == null) continue;
            long termFreqLocal = termsEnum.totalTermFreq();
            Long previousValue = (Long)Util.get(this.fst, (BytesRef)term);
            String termString = term.utf8ToString();
            weights.put(termString, previousValue == null ? 0.0 : (double)previousValue.longValue() + modifier * (double)termFreqLocal);
        }
        if (updateFST) {
            this.updateFST(weights);
        }
    }

    private void updateFST(SortedMap<String, Double> weights) throws IOException {
        PositiveIntOutputs outputs = PositiveIntOutputs.getSingleton();
        Builder fstBuilder = new Builder(FST.INPUT_TYPE.BYTE1, (Outputs)outputs);
        BytesRefBuilder scratchBytes = new BytesRefBuilder();
        IntsRefBuilder scratchInts = new IntsRefBuilder();
        for (Map.Entry<String, Double> entry : weights.entrySet()) {
            scratchBytes.copyChars((CharSequence)entry.getKey());
            fstBuilder.add(Util.toIntsRef((BytesRef)scratchBytes.get(), (IntsRefBuilder)scratchInts), (Object)entry.getValue().longValue());
        }
        this.fst = fstBuilder.finish();
    }

    @Override
    public ClassificationResult<Boolean> assignClass(String text) throws IOException {
        Long output = 0L;
        try (TokenStream tokenStream = this.analyzer.tokenStream(this.textFieldName, text);){
            CharTermAttribute charTermAttribute = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                String s = charTermAttribute.toString();
                Long d = (Long)Util.get(this.fst, (BytesRef)new BytesRef((CharSequence)s));
                if (d == null) continue;
                output = output + d;
            }
            tokenStream.end();
        }
        double score = 1.0 - Math.exp(-1.0 * Math.abs(this.threshold - output.doubleValue()) / this.threshold);
        return new ClassificationResult<Boolean>((double)output.longValue() >= this.threshold, score);
    }

    @Override
    public List<ClassificationResult<Boolean>> getClasses(String text) throws IOException {
        return null;
    }

    @Override
    public List<ClassificationResult<Boolean>> getClasses(String text, int max) throws IOException {
        return null;
    }
}

