/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.solr.index.SlowCompositeReaderWrapper;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.Insanity;
import org.apache.solr.search.SolrIndexSearcher;

public class ReverseOrdFieldSource
extends ValueSource {
    public final String field;
    private static final int hcode = ReverseOrdFieldSource.class.hashCode();

    public ReverseOrdFieldSource(String field) {
        this.field = field;
    }

    public String description() {
        return "rord(" + this.field + ')';
    }

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        LeafReader r;
        final int off = readerContext.docBase;
        Object o = context.get("searcher");
        if (o instanceof SolrIndexSearcher) {
            SolrIndexSearcher is = (SolrIndexSearcher)o;
            SchemaField sf = is.getSchema().getFieldOrNull(this.field);
            if (sf != null && !sf.hasDocValues() && !sf.multiValued() && sf.getType().getNumberType() != null) {
                List leaves = is.getIndexReader().leaves();
                LeafReader[] insaneLeaves = new LeafReader[leaves.size()];
                int upto = 0;
                for (LeafReaderContext raw : leaves) {
                    insaneLeaves[upto++] = Insanity.wrapInsanity(raw.reader(), this.field);
                }
                r = SlowCompositeReaderWrapper.wrap((IndexReader)new MultiReader((IndexReader[])insaneLeaves));
            } else {
                r = ((SolrIndexSearcher)o).getSlowAtomicReader();
            }
        } else {
            IndexReader topReader = ReaderUtil.getTopLevelContext((IndexReaderContext)readerContext).reader();
            r = SlowCompositeReaderWrapper.wrap(topReader);
        }
        final SortedDocValues sindex = SortedSetSelector.wrap((SortedSetDocValues)DocValues.getSortedSet((LeafReader)r, (String)this.field), (SortedSetSelector.Type)SortedSetSelector.Type.MIN);
        final int end = sindex.getValueCount();
        return new IntDocValues(this){

            public int intVal(int doc) {
                return end - sindex.getOrd(doc + off) - 1;
            }
        };
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != ReverseOrdFieldSource.class) {
            return false;
        }
        ReverseOrdFieldSource other = (ReverseOrdFieldSource)((Object)o);
        return this.field.equals(other.field);
    }

    public int hashCode() {
        return hcode + this.field.hashCode();
    }
}

