/*
 * Decompiled with CFR 0.152.
 */
package Common;

import java.util.Collection;
import java.util.Iterator;

public class BoolVector {
    protected boolean[] data;
    int capacityIncr = 10;
    int elt = 0;

    public BoolVector() {
        this.data = new boolean[10];
    }

    public BoolVector(int size) {
        this.data = new boolean[size];
    }

    public int size() {
        return this.elt;
    }

    public void ensureAdditionalCapacity(int addCapacity) {
        this.ensureCapacity(this.data.length + addCapacity);
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            boolean[] oldData = this.data;
            int newCapacity = oldCapacity + this.capacityIncr;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = new boolean[newCapacity];
            System.arraycopy(oldData, 0, this.data, 0, this.elt);
        }
    }

    public boolean get(int index) {
        if (index >= this.elt) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[index];
    }

    public void Reserve(int s) {
        this.ensureCapacity(s);
    }

    public void add(boolean b) {
        this.ensureCapacity(this.elt + 1);
        this.data[this.elt++] = b;
    }

    public void addAll(Collection c) {
        this.ensureCapacity(this.elt + c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.data[this.elt++] = (Boolean)it.next();
        }
    }

    public void addAll(Boolean[] b) {
        this.ensureCapacity(this.elt + b.length);
        for (int i = 0; i < b.length; ++i) {
            this.data[this.elt++] = b[i];
        }
    }

    public void set(int index, boolean value) {
        if (index >= this.data.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.data[index] = value;
        this.elt = index + 1;
    }

    public void setRange(int start, boolean value) {
        this.setRange(start, this.data.length - start, value);
    }

    public void setRange(int start, int length, boolean value) {
        if (start + length > this.data.length) {
            throw new ArrayIndexOutOfBoundsException("start = " + start + ", length = " + length);
        }
        for (int i = 0; i < length; ++i) {
            this.data[start + i] = value;
        }
        this.elt = start + length;
    }

    public void setBoolVector(BoolVector v) {
        this.data = v.data;
        this.elt = v.elt;
    }

    public void clear() {
        this.elt = 0;
    }

    public boolean isEmpty() {
        return this.elt == 0;
    }
}

