/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.documentation;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.menu.MenuItemProxy;
import VASSAL.tools.menu.MenuManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserHelpFile
extends AbstractBuildable
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(BrowserHelpFile.class);
    public static final String TITLE = "title";
    public static final String CONTENTS = "contents";
    public static final String STARTING_PAGE = "startingPage";
    protected String name;
    protected String startingPage;
    protected Action launch;
    protected URL url;
    protected PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    protected ComponentI18nData myI18nData;
    protected MenuItemProxy launchItem;

    public BrowserHelpFile() {
        this.launch = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserHelpFile.this.launch();
            }
        };
    }

    public void launch() {
        if (this.url == null) {
            this.extractContents();
        }
        if (this.url != null) {
            BrowserSupport.openURL(this.url.toString());
        }
    }

    protected String getContentsResource() {
        return this.name == null ? null : this.name.replace(' ', '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractContents() {
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            try {
                zipInputStream = new ZipInputStream(new BufferedInputStream(GameModule.getGameModule().getDataArchive().getInputStream("help/" + this.getContentsResource())));
            }
            catch (IOException iOException) {
                this.url = new URL(this.startingPage);
                IOUtils.closeQuietly(zipInputStream);
                return;
            }
            File file = File.createTempFile("VASSAL", "help");
            File file2 = file.getParentFile();
            file.delete();
            file2 = new File(file2, "VASSAL");
            file2 = new File(file2, "help");
            file2 = new File(file2, this.getContentsResource());
            if (file2.exists()) {
                this.recursiveDelete(file2);
            }
            file2.mkdirs();
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    new File(file2, zipEntry.getName()).mkdirs();
                    continue;
                }
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(new File(file2, zipEntry.getName()));
                    IOUtils.copy((InputStream)zipInputStream, (OutputStream)fileOutputStream);
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileOutputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
            }
            zipInputStream.close();
            this.url = new File(file2, this.startingPage).toURI().toURL();
            IOUtils.closeQuietly((InputStream)zipInputStream);
        }
        catch (IOException iOException) {
            logger.error("", (Throwable)iOException);
        }
        finally {
            IOUtils.closeQuietly(zipInputStream);
        }
    }

    protected void recursiveDelete(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.recursiveDelete(file2);
            }
        } else {
            file.delete();
        }
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{TITLE, CONTENTS, STARTING_PAGE};
    }

    @Override
    public String getAttributeValueString(String string) {
        if (TITLE.equals(string)) {
            return this.name;
        }
        if (STARTING_PAGE.equals(string)) {
            return this.startingPage;
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (TITLE.equals(string)) {
            this.name = (String)object;
            this.launch.putValue("Name", this.name);
            this.url = null;
            this.getI18nData().setUntranslatedValue(string, this.name);
        } else if (STARTING_PAGE.equals(string)) {
            this.startingPage = (String)object;
            this.url = null;
        }
    }

    @Override
    public void addTo(Buildable buildable) {
        this.launchItem = new MenuItemProxy(this.launch);
        MenuManager.getInstance().addToSection("Documentation.Module", this.launchItem);
        this.launch.setEnabled(true);
    }

    @Override
    public void removeFrom(Buildable buildable) {
        MenuManager.getInstance().removeFromSection("Documentation.Module", this.launchItem);
        this.launch.setEnabled(false);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    @Override
    public String getConfigureName() {
        return this.name;
    }

    @Override
    public Configurer getConfigurer() {
        return new MyConfigurer(new ConfigSupport());
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("HelpMenu.htm", "HtmlHelpFile");
    }

    @Override
    public void remove(Buildable buildable) {
    }

    public static String getConfigureTypeName() {
        return "HTML Help File";
    }

    @Override
    public ComponentI18nData getI18nData() {
        if (this.myI18nData == null) {
            this.myI18nData = new ComponentI18nData(this, "BrowserHelpFile." + this.getConfigureName(), null, new String[]{TITLE}, new boolean[]{true}, new String[]{"Menu Entry:  "});
        }
        return this.myI18nData;
    }

    protected static class MyConfigurer
    extends AutoConfigurer {
        public MyConfigurer(AutoConfigurable autoConfigurable) {
            super(autoConfigurable);
        }

        public Object getValue() {
            if (this.target != null) {
                ((ConfigSupport)this.target).packContents();
            }
            return super.getValue();
        }
    }

    public static class ContentsConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new DirectoryConfigurer(string, string2){

                public Component getControls() {
                    Component component = super.getControls();
                    this.tf.setEditable(false);
                    return component;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConfigSupport
    implements AutoConfigurable {
        public static final String DIR = "dir";
        protected File dir;

        protected ConfigSupport() {
        }

        @Override
        public String[] getAttributeDescriptions() {
            return new String[]{"Menu Entry:  ", "Contents:  ", "Starting Page:  "};
        }

        @Override
        public String[] getAttributeNames() {
            return new String[]{BrowserHelpFile.TITLE, DIR, BrowserHelpFile.STARTING_PAGE};
        }

        @Override
        public Class<?>[] getAttributeTypes() {
            return new Class[]{String.class, ContentsConfig.class, String.class};
        }

        @Override
        public String getAttributeValueString(String string) {
            if (DIR.equals(string)) {
                return this.dir == null ? null : this.dir.getPath();
            }
            return BrowserHelpFile.this.getAttributeValueString(string);
        }

        @Override
        public VisibilityCondition getAttributeVisibility(String string) {
            return null;
        }

        @Override
        public void setAttribute(String string, Object object) {
            if (DIR.equals(string)) {
                this.dir = (File)object;
            } else {
                BrowserHelpFile.this.setAttribute(string, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void packContents() {
            if (this.dir == null) {
                return;
            }
            File file = null;
            try {
                file = File.createTempFile("VASSALhelp", ".zip");
                ZipOutputStream zipOutputStream = null;
                try {
                    zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
                    for (File file2 : this.dir.listFiles()) {
                        this.packFile(file2, "", zipOutputStream);
                    }
                    zipOutputStream.close();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(zipOutputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)zipOutputStream);
                GameModule.getGameModule().getArchiveWriter().addFile(file.getPath(), "help/" + BrowserHelpFile.this.getContentsResource());
            }
            catch (IOException iOException) {
                WriteErrorDialog.error(iOException, file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void packFile(File file, String string, ZipOutputStream zipOutputStream) throws IOException {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file2 = fileArray[n2];
                    this.packFile(file2, string + file.getName() + "/", zipOutputStream);
                    ++n2;
                }
                return;
            }
            ZipEntry zipEntry = new ZipEntry(string + file.getName());
            zipOutputStream.putNextEntry(zipEntry);
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
                fileInputStream.close();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            BrowserHelpFile.this.addPropertyChangeListener(propertyChangeListener);
        }

        public Class<?>[] getAllowableConfigureComponents() {
            return BrowserHelpFile.this.getAllowableConfigureComponents();
        }

        @Override
        public Configurable[] getConfigureComponents() {
            return BrowserHelpFile.this.getConfigureComponents();
        }

        @Override
        public String getConfigureName() {
            return BrowserHelpFile.this.getConfigureName();
        }

        @Override
        public Configurer getConfigurer() {
            return null;
        }

        @Override
        public HelpFile getHelpFile() {
            return BrowserHelpFile.this.getHelpFile();
        }

        @Override
        public void remove(Buildable buildable) {
        }

        @Override
        public void removeFrom(Buildable buildable) {
        }

        @Override
        public void add(Buildable buildable) {
        }

        @Override
        public void addTo(Buildable buildable) {
        }

        @Override
        public void build(Element element) {
        }

        @Override
        public Element getBuildElement(Document document) {
            return null;
        }

        @Override
        public ComponentI18nData getI18nData() {
            return null;
        }
    }
}

