/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.NodeImpl;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLText
extends StyleElement {
    private boolean disable = false;
    private String value = null;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            int n2 = n & 0xFFFFF;
            if (n2 == standardNames.DISABLE_OUTPUT_ESCAPING) {
                string = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string != null) {
            if (string.equals("yes")) {
                this.disable = true;
            } else if (string.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either yes or no");
            }
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        NodeImpl nodeImpl;
        this.checkWithinTemplate();
        if (nodeImpl == null) {
            this.value = "";
        } else {
            this.value = nodeImpl.getStringValue();
            for (nodeImpl = (NodeImpl)this.getFirstChild(); nodeImpl != null; nodeImpl = (NodeImpl)nodeImpl.getNextSibling()) {
                if (nodeImpl.getNodeType() != 1) continue;
                this.compileError("xsl:text must not have any child elements");
            }
        }
    }

    @Override
    public void process(Context context) throws TransformerException {
        if (!this.value.equals("")) {
            Outputter outputter = context.getOutputter();
            if (this.disable) {
                outputter.setEscaping(false);
                outputter.writeContent(this.value);
                outputter.setEscaping(true);
            } else {
                outputter.writeContent(this.value);
            }
        }
    }
}

