/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.LastPositionFinder;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.sort.NodeOrderComparer;
import com.icl.saxon.sort.QuickSort;
import com.icl.saxon.sort.Sortable;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class NodeSetExtent
extends NodeSetValue
implements Sortable,
NodeList {
    private NodeInfo[] value;
    private int length;
    private boolean sorted;
    private boolean reverseSorted;
    private NodeOrderComparer comparer;

    public NodeSetExtent(NodeOrderComparer nodeOrderComparer) {
        this.comparer = nodeOrderComparer;
        this.value = new NodeInfo[0];
        this.length = 0;
        this.sorted = true;
        this.reverseSorted = true;
    }

    public NodeSetExtent(NodeInfo[] nodeInfoArray, NodeOrderComparer nodeOrderComparer) {
        this.value = nodeInfoArray;
        this.length = nodeInfoArray.length;
        this.sorted = this.length < 2;
        this.reverseSorted = this.length < 2;
        this.comparer = nodeOrderComparer;
    }

    public NodeSetExtent(Vector vector, NodeOrderComparer nodeOrderComparer) {
        this.value = new NodeInfo[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            this.value[i] = (NodeInfo)vector.elementAt(i);
        }
        this.length = vector.size();
        this.sorted = this.length < 2;
        this.reverseSorted = this.length < 2;
        this.comparer = nodeOrderComparer;
    }

    public NodeSetExtent(NodeEnumeration nodeEnumeration, NodeOrderComparer nodeOrderComparer) throws XPathException {
        this.comparer = nodeOrderComparer;
        int n = 20;
        this.value = new NodeInfo[n];
        int n2 = 0;
        while (nodeEnumeration.hasMoreElements()) {
            if (n2 >= n) {
                NodeInfo[] nodeInfoArray = new NodeInfo[n *= 2];
                System.arraycopy(this.value, 0, nodeInfoArray, 0, n2);
                this.value = nodeInfoArray;
            }
            this.value[n2++] = nodeEnumeration.nextElement();
        }
        this.sorted = nodeEnumeration.isSorted() || n2 < 2;
        this.reverseSorted = nodeEnumeration.isReverseSorted() || n2 < 2;
        this.length = n2;
    }

    public void append(NodeInfo nodeInfo) {
        this.reverseSorted = false;
        if (this.value.length < this.length + 1) {
            NodeInfo[] nodeInfoArray = new NodeInfo[this.length == 0 ? 10 : this.length * 2];
            System.arraycopy(this.value, 0, nodeInfoArray, 0, this.length);
            this.value = nodeInfoArray;
        }
        if (this.length > 0 && this.value[this.length - 1].isSameNodeInfo(nodeInfo)) {
            return;
        }
        this.value[this.length++] = nodeInfo;
    }

    @Override
    public Expression simplify() {
        if (this.length == 0) {
            return new EmptyNodeSet();
        }
        if (this.length == 1) {
            return new SingletonNodeSet(this.value[0]);
        }
        return this;
    }

    @Override
    public void setSorted(boolean bl) {
        this.sorted = bl;
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public String asString() {
        return this.length > 0 ? this.getFirst().getStringValue() : "";
    }

    @Override
    public boolean asBoolean() throws XPathException {
        return this.length > 0;
    }

    @Override
    public int getCount() {
        this.sort();
        return this.length;
    }

    @Override
    public NodeSetValue sort() {
        if (this.length < 2) {
            this.sorted = true;
        }
        if (this.sorted) {
            return this;
        }
        if (this.reverseSorted) {
            NodeInfo[] nodeInfoArray = new NodeInfo[this.length];
            for (int i = 0; i < this.length; ++i) {
                nodeInfoArray[i] = this.value[this.length - i - 1];
            }
            this.value = nodeInfoArray;
            this.sorted = true;
            this.reverseSorted = false;
        } else {
            QuickSort.sort(this, 0, this.length - 1);
            int n = 1;
            for (int i = 1; i < this.length; ++i) {
                if (this.value[i].isSameNodeInfo(this.value[i - 1])) continue;
                this.value[n++] = this.value[i];
            }
            this.length = n;
            this.sorted = true;
            this.reverseSorted = false;
        }
        return this;
    }

    @Override
    public NodeInfo getFirst() {
        if (this.length == 0) {
            return null;
        }
        if (this.sorted) {
            return this.value[0];
        }
        NodeInfo nodeInfo = this.value[0];
        for (int i = 1; i < this.length; ++i) {
            if (this.comparer.compare(this.value[i], nodeInfo) >= 0) continue;
            nodeInfo = this.value[i];
        }
        return nodeInfo;
    }

    public NodeInfo selectFirst(Context context) {
        return this.getFirst();
    }

    @Override
    public NodeEnumeration enumerate() {
        return new NodeSetValueEnumeration();
    }

    @Override
    public int getLength() {
        return this.getCount();
    }

    @Override
    public Node item(int n) {
        this.sort();
        if (this.length > n && this.value[n] instanceof Node) {
            return (Node)((Object)this.value[n]);
        }
        return null;
    }

    @Override
    public int compare(int n, int n2) {
        return this.comparer.compare(this.value[n], this.value[n2]);
    }

    @Override
    public void swap(int n, int n2) {
        NodeInfo nodeInfo = this.value[n];
        this.value[n] = this.value[n2];
        this.value[n2] = nodeInfo;
    }

    private class NodeSetValueEnumeration
    implements AxisEnumeration,
    LastPositionFinder {
        int index = 0;

        @Override
        public boolean hasMoreElements() {
            return this.index < NodeSetExtent.this.length;
        }

        @Override
        public NodeInfo nextElement() {
            return NodeSetExtent.this.value[this.index++];
        }

        @Override
        public boolean isSorted() {
            return NodeSetExtent.this.sorted;
        }

        @Override
        public boolean isReverseSorted() {
            return NodeSetExtent.this.reverseSorted;
        }

        @Override
        public boolean isPeer() {
            return false;
        }

        @Override
        public int getLastPosition() {
            return NodeSetExtent.this.length;
        }
    }
}

