/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.ContentEmitter;
import com.icl.saxon.Controller;
import com.icl.saxon.TransformerFactoryImpl;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.GeneralOutputter;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

class IdentityTransformer
extends Controller {
    protected IdentityTransformer(TransformerFactoryImpl transformerFactoryImpl) {
        super(transformerFactoryImpl);
    }

    @Override
    public void transform(Source source, Result result) throws TransformerException {
        SAXSource sAXSource = this.getTransformerFactory().getSAXSource(source, false);
        XMLReader xMLReader = sAXSource.getXMLReader();
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new TransformerException("The SAX2 parser does not recognize a required namespace feature");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new TransformerException("The SAX2 parser does not support a required namespace feature");
        }
        if (result instanceof SAXResult) {
            ContentHandler contentHandler = ((SAXResult)result).getHandler();
            xMLReader.setContentHandler(contentHandler);
            if (contentHandler instanceof LexicalHandler) {
                try {
                    xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
            }
            try {
                xMLReader.parse(sAXSource.getInputSource());
            }
            catch (Exception exception) {
                throw new TransformerException(exception);
            }
        }
        NamePool namePool = this.getNamePool();
        Properties properties = this.getOutputProperties();
        GeneralOutputter generalOutputter = new GeneralOutputter(namePool);
        generalOutputter.setOutputDestination(properties, result);
        Emitter emitter = generalOutputter.getEmitter();
        ContentEmitter contentEmitter = new ContentEmitter();
        contentEmitter.setNamePool(namePool);
        contentEmitter.setEmitter(emitter);
        try {
            xMLReader.setContentHandler(contentEmitter);
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", contentEmitter);
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
            xMLReader.parse(sAXSource.getInputSource());
        }
        catch (Exception exception) {
            throw new TransformerException(exception);
        }
        generalOutputter.close();
    }
}

