/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.reflection.AccessibilityChanger;
import org.mockito.internal.util.reflection.FieldInitializationReport;
import org.mockito.internal.util.reflection.FieldReader;
import org.mockito.internal.util.reflection.FieldSetter;

public class FieldInitializer {
    private final Object fieldOwner;
    private final Field field;
    private final ConstructorInstantiator instantiator;

    public FieldInitializer(Object object, Field field) {
        this(object, field, new NoArgConstructorInstantiator(object, field));
    }

    public FieldInitializer(Object object, Field field, ConstructorArgumentResolver constructorArgumentResolver) {
        this(object, field, new ParameterizedConstructorInstantiator(object, field, constructorArgumentResolver));
    }

    private FieldInitializer(Object object, Field field, ConstructorInstantiator constructorInstantiator) {
        if (new FieldReader(object, field).isNull()) {
            this.checkNotLocal(field);
            this.checkNotInner(field);
            this.checkNotInterface(field);
            this.checkNotAbstract(field);
        }
        this.fieldOwner = object;
        this.field = field;
        this.instantiator = constructorInstantiator;
    }

    public FieldInitializationReport initialize() {
        AccessibilityChanger accessibilityChanger = new AccessibilityChanger();
        accessibilityChanger.enableAccess(this.field);
        try {
            FieldInitializationReport fieldInitializationReport = this.acquireFieldInstance();
            return fieldInitializationReport;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MockitoException("Problems initializing field '" + this.field.getName() + "' of type '" + this.field.getType().getSimpleName() + "'", illegalAccessException);
        }
        finally {
            accessibilityChanger.safelyDisableAccess(this.field);
        }
    }

    private void checkNotLocal(Field field) {
        if (field.getType().isLocalClass()) {
            throw new MockitoException("the type '" + field.getType().getSimpleName() + "' is a local class.");
        }
    }

    private void checkNotInner(Field field) {
        if (field.getType().isMemberClass() && !Modifier.isStatic(field.getType().getModifiers())) {
            throw new MockitoException("the type '" + field.getType().getSimpleName() + "' is an inner class.");
        }
    }

    private void checkNotInterface(Field field) {
        if (field.getType().isInterface()) {
            throw new MockitoException("the type '" + field.getType().getSimpleName() + "' is an interface.");
        }
    }

    private void checkNotAbstract(Field field) {
        if (Modifier.isAbstract(field.getType().getModifiers())) {
            throw new MockitoException("the type '" + field.getType().getSimpleName() + " is an abstract class.");
        }
    }

    private FieldInitializationReport acquireFieldInstance() throws IllegalAccessException {
        Object object = this.field.get(this.fieldOwner);
        if (object != null) {
            return new FieldInitializationReport(object, false, false);
        }
        return this.instantiator.instantiate();
    }

    static class ParameterizedConstructorInstantiator
    implements ConstructorInstantiator {
        private final Object testClass;
        private final Field field;
        private final ConstructorArgumentResolver argResolver;
        private final MockUtil mockUtil = new MockUtil();
        private final Comparator<Constructor<?>> byParameterNumber = new Comparator<Constructor<?>>(){

            @Override
            public int compare(Constructor<?> constructor, Constructor<?> constructor2) {
                int n = constructor2.getParameterTypes().length - constructor.getParameterTypes().length;
                if (n == 0) {
                    int n2 = this.countMockableParams(constructor);
                    int n3 = this.countMockableParams(constructor2);
                    return n3 - n2;
                }
                return n;
            }

            private int countMockableParams(Constructor<?> constructor) {
                int n = 0;
                for (Class<?> clazz : constructor.getParameterTypes()) {
                    if (!ParameterizedConstructorInstantiator.this.mockUtil.isTypeMockable(clazz)) continue;
                    ++n;
                }
                return n;
            }
        };

        ParameterizedConstructorInstantiator(Object object, Field field, ConstructorArgumentResolver constructorArgumentResolver) {
            this.testClass = object;
            this.field = field;
            this.argResolver = constructorArgumentResolver;
        }

        @Override
        public FieldInitializationReport instantiate() {
            AccessibilityChanger accessibilityChanger = new AccessibilityChanger();
            Constructor<?> constructor = null;
            try {
                constructor = this.biggestConstructor(this.field.getType());
                accessibilityChanger.enableAccess(constructor);
                Object[] objectArray = this.argResolver.resolveTypeInstances(constructor.getParameterTypes());
                Object obj = constructor.newInstance(objectArray);
                new FieldSetter(this.testClass, this.field).set(obj);
                FieldInitializationReport fieldInitializationReport = new FieldInitializationReport(this.field.get(this.testClass), false, true);
                return fieldInitializationReport;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MockitoException("internal error : argResolver provided incorrect types for constructor " + constructor + " of type " + this.field.getType().getSimpleName(), illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new MockitoException("the constructor of type '" + this.field.getType().getSimpleName() + "' has raised an exception (see the stack trace for cause): " + invocationTargetException.getTargetException().toString(), invocationTargetException);
            }
            catch (InstantiationException instantiationException) {
                throw new MockitoException("InstantiationException (see the stack trace for cause): " + instantiationException.toString(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MockitoException("IllegalAccessException (see the stack trace for cause): " + illegalAccessException.toString(), illegalAccessException);
            }
            finally {
                if (constructor != null) {
                    accessibilityChanger.safelyDisableAccess(constructor);
                }
            }
        }

        private void checkParameterized(Constructor<?> constructor, Field field) {
            if (constructor.getParameterTypes().length == 0) {
                throw new MockitoException("the field " + field.getName() + " of type " + field.getType() + " has no parameterized constructor");
            }
        }

        private Constructor<?> biggestConstructor(Class<?> clazz) {
            List<Constructor<?>> list = Arrays.asList(clazz.getDeclaredConstructors());
            Collections.sort(list, this.byParameterNumber);
            Constructor<?> constructor = list.get(0);
            this.checkParameterized(constructor, this.field);
            return constructor;
        }
    }

    static class NoArgConstructorInstantiator
    implements ConstructorInstantiator {
        private final Object testClass;
        private final Field field;

        NoArgConstructorInstantiator(Object object, Field field) {
            this.testClass = object;
            this.field = field;
        }

        @Override
        public FieldInitializationReport instantiate() {
            AccessibilityChanger accessibilityChanger = new AccessibilityChanger();
            Constructor<?> constructor = null;
            try {
                constructor = this.field.getType().getDeclaredConstructor(new Class[0]);
                accessibilityChanger.enableAccess(constructor);
                Object[] objectArray = new Object[]{};
                Object obj = constructor.newInstance(objectArray);
                new FieldSetter(this.testClass, this.field).set(obj);
                FieldInitializationReport fieldInitializationReport = new FieldInitializationReport(this.field.get(this.testClass), true, false);
                return fieldInitializationReport;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new MockitoException("the type '" + this.field.getType().getSimpleName() + "' has no default constructor", noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new MockitoException("the default constructor of type '" + this.field.getType().getSimpleName() + "' has raised an exception (see the stack trace for cause): " + invocationTargetException.getTargetException().toString(), invocationTargetException);
            }
            catch (InstantiationException instantiationException) {
                throw new MockitoException("InstantiationException (see the stack trace for cause): " + instantiationException.toString(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MockitoException("IllegalAccessException (see the stack trace for cause): " + illegalAccessException.toString(), illegalAccessException);
            }
            finally {
                if (constructor != null) {
                    accessibilityChanger.safelyDisableAccess(constructor);
                }
            }
        }
    }

    private static interface ConstructorInstantiator {
        public FieldInitializationReport instantiate();
    }

    public static interface ConstructorArgumentResolver {
        public Object[] resolveTypeInstances(Class<?> ... var1);
    }
}

