/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.collection;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.collection.AbstractSerializableCollectionDecorator;

public class PredicatedCollection<E>
extends AbstractSerializableCollectionDecorator<E> {
    private static final long serialVersionUID = -5259182142076705162L;
    protected final Predicate<? super E> predicate;

    public static <E> Collection<E> decorate(Collection<E> coll, Predicate<? super E> predicate) {
        return new PredicatedCollection<E>(coll, predicate);
    }

    protected PredicatedCollection(Collection<E> coll, Predicate<? super E> predicate) {
        super(coll);
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate must not be null");
        }
        this.predicate = predicate;
        Iterator<E> it = coll.iterator();
        while (it.hasNext()) {
            this.validate(it.next());
        }
    }

    protected void validate(E object) {
        if (!this.predicate.evaluate(object)) {
            throw new IllegalArgumentException("Cannot add Object '" + object + "' - Predicate rejected it");
        }
    }

    @Override
    public boolean add(E object) {
        this.validate(object);
        return this.getCollection().add(object);
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        Iterator<E> it = coll.iterator();
        while (it.hasNext()) {
            this.validate(it.next());
        }
        return this.getCollection().addAll(coll);
    }
}

