/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;

public class ClassLoaderRepository
implements Repository {
    private ClassLoader loader;
    private Map loadedClasses = new HashMap();

    public ClassLoaderRepository(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public void storeClass(JavaClass clazz) {
        this.loadedClasses.put(clazz.getClassName(), clazz);
        clazz.setRepository(this);
    }

    @Override
    public void removeClass(JavaClass clazz) {
        this.loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public JavaClass findClass(String className) {
        if (this.loadedClasses.containsKey(className)) {
            return (JavaClass)this.loadedClasses.get(className);
        }
        return null;
    }

    @Override
    public JavaClass loadClass(String className) throws ClassNotFoundException {
        String classFile = className.replace('.', '/');
        JavaClass RC = this.findClass(className);
        if (RC != null) {
            return RC;
        }
        try {
            InputStream is = this.loader.getResourceAsStream(classFile + ".class");
            if (is == null) {
                throw new ClassNotFoundException(className + " not found.");
            }
            ClassParser parser2 = new ClassParser(is, className);
            RC = parser2.parse();
            this.storeClass(RC);
            return RC;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.toString());
        }
    }

    @Override
    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        return this.loadClass(clazz.getName());
    }

    @Override
    public void clear() {
        this.loadedClasses.clear();
    }

    @Override
    public ClassPath getClassPath() {
        return null;
    }
}

