/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data.resources;

import lcmc.data.resources.Resource;
import lcmc.utilities.Tools;

public final class NetInterface
extends Resource {
    private static final long serialVersionUID = 1L;
    private String ip = null;
    private String macAddr = null;
    private String netMask = null;
    private final boolean bridge;

    public NetInterface(String line) {
        String[] cols = line.split(" ");
        if (cols.length < 4) {
            Tools.appWarning("cannot parse: " + line);
        }
        String iface = "unknown";
        if (cols.length > 0) {
            iface = cols[0];
        }
        if (cols.length > 1) {
            this.ip = cols[1];
        }
        if (cols.length > 2) {
            this.macAddr = cols[2];
        }
        if (cols.length > 3) {
            this.netMask = cols[3];
        }
        this.bridge = cols.length > 4 && "bridge".equals(cols[4]);
        this.setName(iface);
    }

    public NetInterface(String iface, String ip, String macAddr, String netMask, boolean bridge) {
        super(iface);
        this.ip = ip;
        this.macAddr = macAddr;
        this.netMask = netMask;
        this.bridge = bridge;
    }

    String getMacAddr() {
        return this.macAddr;
    }

    public String getIp() {
        return this.ip;
    }

    public String getNetmask() {
        return this.netMask;
    }

    public String getNetworkIp() {
        if (this.netMask == null) {
            return null;
        }
        String[] ipParts = this.ip.split("\\.");
        String[] netMaskParts = this.netMask.split("\\.");
        String[] networkIpParts = new String[4];
        if (ipParts.length != 4 && netMaskParts.length != 4) {
            return "";
        }
        for (int i = 0; i < 4; ++i) {
            networkIpParts[i] = Integer.toString(Integer.parseInt(ipParts[i]) & Integer.parseInt(netMaskParts[i]));
        }
        return Tools.join(".", networkIpParts);
    }

    @Override
    public String getValue(String parameter) {
        if ("ip".equals(parameter)) {
            return this.ip;
        }
        if ("String".equals(parameter)) {
            return this.ip;
        }
        Tools.appError("Unknown parameter: " + parameter, "");
        return "";
    }

    public String getBindnetaddr() {
        String[] ipParts = this.ip.split("\\.");
        if (this.netMask == null) {
            return null;
        }
        String[] netMaskParts = this.netMask.split("\\.");
        String[] networkIpParts = new String[4];
        if (ipParts.length != 4 && netMaskParts.length != 4) {
            return "";
        }
        for (int i = 0; i < 4; ++i) {
            networkIpParts[i] = Integer.toString(Integer.parseInt(ipParts[i]) & Integer.parseInt(netMaskParts[i]));
        }
        return Tools.join(".", networkIpParts);
    }

    public boolean isBridge() {
        return this.bridge;
    }

    public boolean isLocalHost() {
        return "lo".equals(this.getName());
    }
}

