/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGLensSet;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.graphelements.TGForEachNode;
import com.touchgraph.graphlayout.interaction.GLEditUI;
import com.touchgraph.graphlayout.interaction.GLNavigateUI;
import com.touchgraph.graphlayout.interaction.HVScroll;
import com.touchgraph.graphlayout.interaction.HyperScroll;
import com.touchgraph.graphlayout.interaction.LocalityScroll;
import com.touchgraph.graphlayout.interaction.RotateScroll;
import com.touchgraph.graphlayout.interaction.TGUIManager;
import com.touchgraph.graphlayout.interaction.ZoomScroll;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;

public class GLPanel
extends Panel {
    public String zoomLabel = "Zoom";
    public String rotateLabel = "Rotate";
    public String localityLabel = "Radius";
    public String hyperLabel = "Hyperbolic";
    public HVScroll hvScroll;
    public ZoomScroll zoomScroll;
    public HyperScroll hyperScroll;
    public RotateScroll rotateScroll;
    public LocalityScroll localityScroll;
    public PopupMenu glPopup;
    public Hashtable scrollBarHash;
    protected TGPanel tgPanel;
    protected TGLensSet tgLensSet;
    protected TGUIManager tgUIManager;
    private Scrollbar currentSB = null;
    private Color defaultBackColor = new Color(1, 17, 68);
    private Color defaultBorderBackColor = new Color(2, 53, 129);
    private Color defaultForeColor = new Color(0.95f, 0.85f, 0.55f);

    public GLPanel() {
        this.setBackground(this.defaultBorderBackColor);
        this.setForeground(this.defaultForeColor);
        this.scrollBarHash = new Hashtable();
        this.tgLensSet = new TGLensSet();
        this.tgPanel = new TGPanel();
        this.tgPanel.setBackColor(this.defaultBackColor);
        this.hvScroll = new HVScroll(this.tgPanel, this.tgLensSet);
        this.zoomScroll = new ZoomScroll(this.tgPanel);
        this.hyperScroll = new HyperScroll(this.tgPanel);
        this.rotateScroll = new RotateScroll(this.tgPanel);
        this.localityScroll = new LocalityScroll(this.tgPanel);
        this.initialize();
    }

    public void initialize() {
        this.buildPanel();
        this.buildLens();
        this.tgPanel.setLensSet(this.tgLensSet);
        this.addUIs();
        try {
            this.randomGraph();
        }
        catch (TGException tge) {
            System.err.println(tge.getMessage());
            tge.printStackTrace(System.err);
        }
        this.setVisible(true);
    }

    public TGPanel getTGPanel() {
        return this.tgPanel;
    }

    public HVScroll getHVScroll() {
        return this.hvScroll;
    }

    public HyperScroll getHyperScroll() {
        return this.hyperScroll;
    }

    public void setOffset(Point p) {
        this.hvScroll.setOffset(p);
    }

    public Point getOffset() {
        return this.hvScroll.getOffset();
    }

    public RotateScroll getRotateScroll() {
        return this.rotateScroll;
    }

    public void setRotationAngle(int angle) {
        this.rotateScroll.setRotationAngle(angle);
    }

    public int getRotationAngle() {
        return this.rotateScroll.getRotationAngle();
    }

    public LocalityScroll getLocalityScroll() {
        return this.localityScroll;
    }

    public void setLocalityRadius(int radius) {
        this.localityScroll.setLocalityRadius(radius);
    }

    public int getLocalityRadius() {
        return this.localityScroll.getLocalityRadius();
    }

    public ZoomScroll getZoomScroll() {
        return this.zoomScroll;
    }

    public void setZoomValue(int zoomValue) {
        this.zoomScroll.setZoomValue(zoomValue);
    }

    public int getZoomValue() {
        return this.zoomScroll.getZoomValue();
    }

    public PopupMenu getGLPopup() {
        return this.glPopup;
    }

    public void buildLens() {
        this.tgLensSet.addLens(this.hvScroll.getLens());
        this.tgLensSet.addLens(this.zoomScroll.getLens());
        this.tgLensSet.addLens(this.hyperScroll.getLens());
        this.tgLensSet.addLens(this.rotateScroll.getLens());
        this.tgLensSet.addLens(this.tgPanel.getAdjustOriginLens());
    }

    public void buildPanel() {
        final Scrollbar horizontalSB = this.hvScroll.getHorizontalSB();
        final Scrollbar verticalSB = this.hvScroll.getVerticalSB();
        Scrollbar zoomSB = this.zoomScroll.getZoomSB();
        Scrollbar rotateSB = this.rotateScroll.getRotateSB();
        Scrollbar localitySB = this.localityScroll.getLocalitySB();
        Scrollbar hyperSB = this.hyperScroll.getHyperSB();
        this.setLayout(new BorderLayout());
        Panel scrollPanel = new Panel();
        scrollPanel.setBackground(this.defaultBackColor);
        scrollPanel.setForeground(this.defaultForeColor);
        scrollPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Panel modeSelectPanel = new Panel();
        modeSelectPanel.setBackground(this.defaultBackColor);
        modeSelectPanel.setForeground(this.defaultForeColor);
        modeSelectPanel.setLayout(new FlowLayout(1, 0, 0));
        final Panel topPanel = new Panel();
        topPanel.setBackground(this.defaultBorderBackColor);
        topPanel.setForeground(this.defaultForeColor);
        topPanel.setLayout(new GridBagLayout());
        c.gridy = 0;
        c.fill = 2;
        c.gridx = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridy = 0;
        c.weightx = 1.0;
        this.scrollBarHash.put(this.zoomLabel, zoomSB);
        this.scrollBarHash.put(this.rotateLabel, rotateSB);
        this.scrollBarHash.put(this.localityLabel, localitySB);
        this.scrollBarHash.put(this.hyperLabel, hyperSB);
        Panel scrollselect = this.scrollSelectPanel(new String[]{this.zoomLabel, this.rotateLabel, this.hyperLabel});
        scrollselect.setBackground(this.defaultBorderBackColor);
        scrollselect.setForeground(this.defaultForeColor);
        topPanel.add((Component)scrollselect, c);
        this.add((Component)topPanel, "South");
        c.fill = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        scrollPanel.add((Component)this.tgPanel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 2;
        this.add((Component)scrollPanel, "Center");
        this.glPopup = new PopupMenu();
        this.add(this.glPopup);
        MenuItem menuItem = new MenuItem("Toggle Controls");
        ActionListener toggleControlsAction = new ActionListener(){
            boolean controlsVisible = true;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.controlsVisible = !this.controlsVisible;
                horizontalSB.setVisible(this.controlsVisible);
                verticalSB.setVisible(this.controlsVisible);
                topPanel.setVisible(this.controlsVisible);
                GLPanel.this.doLayout();
            }
        };
        menuItem.addActionListener(toggleControlsAction);
        this.glPopup.add(menuItem);
    }

    protected Panel scrollSelectPanel(final String[] scrollBarNames) {
        int i;
        final Panel sbp = new Panel(new GridBagLayout());
        sbp.setBackground(this.defaultBorderBackColor);
        sbp.setForeground(this.defaultForeColor);
        Panel firstRow = new Panel(new GridBagLayout());
        final CheckboxGroup bg = new CheckboxGroup();
        int cbNumber = scrollBarNames.length;
        Checkbox[] checkboxes = new Checkbox[cbNumber];
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridy = 0;
        c.weightx = 0.0;
        c.fill = 2;
        for (int i2 = 0; i2 < cbNumber; ++i2) {
            checkboxes[i2] = new Checkbox(scrollBarNames[i2], true, bg);
            c.gridx = i2;
            firstRow.add((Component)checkboxes[i2], c);
        }
        checkboxes[0].setState(true);
        c.gridx = cbNumber;
        c.weightx = 1.0;
        Label lbl = new Label("     Right-click nodes and background for more options");
        firstRow.add((Component)lbl, c);
        for (i = 0; i < cbNumber; ++i) {
            class RadioItemListener
            implements ItemListener {
                private String scrollBarName;

                public RadioItemListener(String str2Act) {
                    this.scrollBarName = str2Act;
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Scrollbar selectedSB = (Scrollbar)GLPanel.this.scrollBarHash.get(bg.getSelectedCheckbox().getLabel());
                    if (e.getStateChange() == 1) {
                        for (int i = 0; i < scrollBarNames.length; ++i) {
                            Scrollbar sb = (Scrollbar)GLPanel.this.scrollBarHash.get(scrollBarNames[i]);
                            sb.setVisible(false);
                        }
                        selectedSB.setBounds(GLPanel.this.currentSB.getBounds());
                        if (selectedSB != null) {
                            selectedSB.setVisible(true);
                        }
                        GLPanel.this.currentSB = selectedSB;
                        sbp.invalidate();
                    }
                }
            }
            checkboxes[i].addItemListener(new RadioItemListener(scrollBarNames[0]));
        }
        c.anchor = 18;
        c.insets = new Insets(1, 5, 1, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 10.0;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 17;
        sbp.add((Component)firstRow, c);
        c.gridy = 1;
        c.fill = 2;
        for (i = 0; i < scrollBarNames.length; ++i) {
            Scrollbar sb = (Scrollbar)this.scrollBarHash.get(scrollBarNames[i]);
            if (sb == null) continue;
            if (this.currentSB == null) {
                this.currentSB = sb;
            }
            sbp.add((Component)sb, c);
        }
        return sbp;
    }

    public void addUIs() {
        this.tgUIManager = new TGUIManager();
        GLEditUI editUI = new GLEditUI(this);
        GLNavigateUI navigateUI = new GLNavigateUI(this);
        this.tgUIManager.addUI(editUI, "Edit");
        this.tgUIManager.addUI(navigateUI, "Navigate");
        this.tgUIManager.activate("Navigate");
    }

    public void randomGraph() throws TGException {
        Node n1 = this.tgPanel.addNode();
        n1.setType(0);
        for (int i = 0; i < 249; ++i) {
            this.tgPanel.addNode();
        }
        TGForEachNode fen = new TGForEachNode(){

            @Override
            public void forEachNode(Node n) {
                for (int i = 0; i < 5; ++i) {
                    Node r = GLPanel.this.tgPanel.getGES().getRandomNode();
                    if (r == n || GLPanel.this.tgPanel.findEdge(r, n) != null) continue;
                    GLPanel.this.tgPanel.addEdge(r, n, Edge.DEFAULT_LENGTH);
                }
            }
        };
        this.tgPanel.getGES().forAllNodes(fen);
        this.tgPanel.setLocale(n1, 1);
        this.tgPanel.setSelect(n1);
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getHVScroll().slowScrollToCenter(n1);
    }

    public static void main(String[] args) {
        final GLPanel glPanel = new GLPanel();
        final Frame frame = new Frame("TouchGraph GraphLayout");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frame.remove(glPanel);
                frame.dispose();
            }
        });
        frame.add("Center", glPanel);
        frame.setSize(800, 600);
        frame.setVisible(true);
    }
}

