/*
 * Decompiled with CFR 0.152.
 */
package com.tomtessier.scrollabledesktop;

import com.tomtessier.scrollabledesktop.DesktopConstants;
import com.tomtessier.scrollabledesktop.DesktopMediator;
import java.awt.BorderLayout;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public class JScrollableDesktopPane
extends JPanel
implements DesktopConstants {
    private static int count;
    private DesktopMediator desktopMediator;
    private ImageIcon defaultFrameIcon;

    public JScrollableDesktopPane(JMenuBar mb, ImageIcon defaultFrameIcon) {
        this();
        this.registerMenuBar(mb);
        this.defaultFrameIcon = defaultFrameIcon;
    }

    public JScrollableDesktopPane(JMenuBar mb) {
        this();
        this.registerMenuBar(mb);
    }

    public JScrollableDesktopPane() {
        this.setLayout(new BorderLayout());
        this.desktopMediator = new DesktopMediator(this);
    }

    public JInternalFrame add(JPanel frameContents) {
        return this.add("Untitled " + count++, this.defaultFrameIcon, frameContents, true, -1, -1);
    }

    public JInternalFrame add(String title, JPanel frameContents) {
        return this.add(title, this.defaultFrameIcon, frameContents, true, -1, -1);
    }

    public JInternalFrame add(String title, JPanel frameContents, boolean isClosable) {
        return this.add(title, this.defaultFrameIcon, frameContents, isClosable, -1, -1);
    }

    public JInternalFrame add(String title, ImageIcon icon, JPanel frameContents, boolean isClosable) {
        return this.add(title, icon, frameContents, isClosable, -1, -1);
    }

    public JInternalFrame add(String title, ImageIcon icon, JPanel frameContents, boolean isClosable, int x, int y) {
        return this.desktopMediator.add(title, icon, frameContents, isClosable, x, y);
    }

    public void add(JInternalFrame f) {
        this.add(f, -1, -1);
    }

    public void add(JInternalFrame f, int x, int y) {
        this.desktopMediator.add(f, x, y);
    }

    public void remove(JInternalFrame f) {
        f.dispose();
    }

    public void registerMenuBar(JMenuBar mb) {
        this.desktopMediator.registerMenuBar(mb);
    }

    public void registerDefaultFrameIcon(ImageIcon defaultFrameIcon) {
        this.defaultFrameIcon = defaultFrameIcon;
    }

    public JInternalFrame getSelectedFrame() {
        return this.desktopMediator.getSelectedFrame();
    }

    public void setSelectedFrame(JInternalFrame f) {
        this.desktopMediator.setSelectedFrame(f);
    }

    public void flagContentsChanged(JInternalFrame f) {
        this.desktopMediator.flagContentsChanged(f);
    }
}

