/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.GZIPException;
import com.jcraft.jzlib.Inflate;
import com.jcraft.jzlib.JZlib;
import com.jcraft.jzlib.ZStream;

public final class Inflater
extends ZStream {
    private static final int MAX_WBITS = 15;
    private static final int DEF_WBITS = 15;
    private static final int Z_NO_FLUSH = 0;
    private static final int Z_PARTIAL_FLUSH = 1;
    private static final int Z_SYNC_FLUSH = 2;
    private static final int Z_FULL_FLUSH = 3;
    private static final int Z_FINISH = 4;
    private static final int MAX_MEM_LEVEL = 9;
    private static final int Z_OK = 0;
    private static final int Z_STREAM_END = 1;
    private static final int Z_NEED_DICT = 2;
    private static final int Z_ERRNO = -1;
    private static final int Z_STREAM_ERROR = -2;
    private static final int Z_DATA_ERROR = -3;
    private static final int Z_MEM_ERROR = -4;
    private static final int Z_BUF_ERROR = -5;
    private static final int Z_VERSION_ERROR = -6;
    private boolean finished = false;

    public Inflater() {
        this.init();
    }

    public Inflater(JZlib.WrapperType wrapperType) throws GZIPException {
        this(15, wrapperType);
    }

    public Inflater(int n, JZlib.WrapperType wrapperType) throws GZIPException {
        int n2 = this.init(n, wrapperType);
        if (n2 != 0) {
            throw new GZIPException(n2 + ": " + this.msg);
        }
    }

    public Inflater(int n) throws GZIPException {
        this(n, false);
    }

    public Inflater(boolean bl) throws GZIPException {
        this(15, bl);
    }

    public Inflater(int n, boolean bl) throws GZIPException {
        int n2 = this.init(n, bl);
        if (n2 != 0) {
            throw new GZIPException(n2 + ": " + this.msg);
        }
    }

    public int init() {
        return this.init(15);
    }

    public int init(JZlib.WrapperType wrapperType) {
        return this.init(15, wrapperType);
    }

    public int init(int n, JZlib.WrapperType wrapperType) {
        boolean bl = false;
        if (wrapperType == JZlib.W_NONE) {
            bl = true;
        } else if (wrapperType == JZlib.W_GZIP) {
            n += 16;
        } else if (wrapperType == JZlib.W_ANY) {
            n |= 0x40000000;
        } else if (wrapperType == JZlib.W_ZLIB) {
            // empty if block
        }
        return this.init(n, bl);
    }

    public int init(boolean bl) {
        return this.init(15, bl);
    }

    public int init(int n) {
        return this.init(n, false);
    }

    public int init(int n, boolean bl) {
        this.finished = false;
        this.istate = new Inflate(this);
        return this.istate.inflateInit(bl ? -n : n);
    }

    @Override
    public int inflate(int n) {
        if (this.istate == null) {
            return -2;
        }
        int n2 = this.istate.inflate(n);
        if (n2 == 1) {
            this.finished = true;
        }
        return n2;
    }

    @Override
    public int end() {
        this.finished = true;
        if (this.istate == null) {
            return -2;
        }
        int n = this.istate.inflateEnd();
        return n;
    }

    public int sync() {
        if (this.istate == null) {
            return -2;
        }
        return this.istate.inflateSync();
    }

    public int syncPoint() {
        if (this.istate == null) {
            return -2;
        }
        return this.istate.inflateSyncPoint();
    }

    public int setDictionary(byte[] byArray, int n) {
        if (this.istate == null) {
            return -2;
        }
        return this.istate.inflateSetDictionary(byArray, n);
    }

    @Override
    public boolean finished() {
        return this.istate.mode == 12;
    }
}

