/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.fileaccess;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.slick.fileaccess.FileAccessServiceLick;
import org.jitsi.service.fileaccess.FailSafeTransaction;
import org.jitsi.service.fileaccess.FileAccessService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TestFailSafeTransaction
extends TestCase {
    private FileAccessService fileAccessService = null;
    private static final String origData = "this is a test for the fail safe transaction ability in SIP Communicator";
    private static final String addedData = " which is the greatest IM client in the world !";
    private static final String wrongData = "all the file is damaged now !";
    private static String tempName = "wzsxedcrfv" + System.currentTimeMillis();

    public TestFailSafeTransaction(String name) {
        super(name);
        BundleContext context = FileAccessServiceLick.bc;
        ServiceReference ref = context.getServiceReference(FileAccessService.class.getName());
        this.fileAccessService = (FileAccessService)context.getService(ref);
    }

    public void testCommit() {
        try {
            File temp = File.createTempFile(tempName + "a", null);
            FileOutputStream out = new FileOutputStream(temp);
            out.write(origData.getBytes());
            FailSafeTransaction trans = this.fileAccessService.createFailSafeTransaction(temp);
            trans.beginTransaction();
            out.write(addedData.getBytes());
            trans.commit();
            out.close();
            TestFailSafeTransaction.assertEquals((String)"the file hasn't the right size after a commit", (long)temp.length(), (long)(origData.length() + addedData.length()));
            FileInputStream in = new FileInputStream(temp);
            byte[] buffer = new byte[in.available()];
            in.read(buffer);
            in.close();
            String content = new String(buffer);
            TestFailSafeTransaction.assertEquals((String)"the file content isn't correct", (String)"this is a test for the fail safe transaction ability in SIP Communicator which is the greatest IM client in the world !", (String)content);
            temp.delete();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void testRollback() {
        try {
            File temp = File.createTempFile(tempName + "b", null);
            FileOutputStream out = new FileOutputStream(temp);
            byte[] origDataBytes = origData.getBytes();
            out.write(origDataBytes);
            out.flush();
            FailSafeTransaction trans = this.fileAccessService.createFailSafeTransaction(temp);
            trans.beginTransaction();
            out.write(wrongData.getBytes());
            out.flush();
            trans.rollback();
            out.close();
            TestFailSafeTransaction.assertEquals((String)"the file hasn't the right size after a commit", (long)temp.length(), (long)origDataBytes.length);
            FileInputStream in = new FileInputStream(temp);
            byte[] buffer = new byte[in.available()];
            in.read(buffer);
            in.close();
            String content = new String(buffer);
            TestFailSafeTransaction.assertEquals((String)"the file content isn't correct", (String)origData, (String)content);
            temp.delete();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void testCommitOnReOpen() {
        try {
            File temp = File.createTempFile(tempName + "c", null);
            FileOutputStream out = new FileOutputStream(temp);
            out.write(origData.getBytes());
            FailSafeTransaction trans = this.fileAccessService.createFailSafeTransaction(temp);
            trans.beginTransaction();
            out.write(addedData.getBytes());
            trans.beginTransaction();
            trans.rollback();
            out.close();
            TestFailSafeTransaction.assertEquals((String)"the file hasn't the right size after a commit", (long)temp.length(), (long)(origData.length() + addedData.length()));
            FileInputStream in = new FileInputStream(temp);
            byte[] buffer = new byte[in.available()];
            in.read(buffer);
            in.close();
            String content = new String(buffer);
            TestFailSafeTransaction.assertEquals((String)"the file content isn't correct", (String)"this is a test for the fail safe transaction ability in SIP Communicator which is the greatest IM client in the world !", (String)content);
            temp.delete();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void testRollbackOnFailure() {
        try {
            File temp = File.createTempFile(tempName + "d", null);
            FileOutputStream out = new FileOutputStream(temp);
            byte[] origDataBytes = origData.getBytes();
            out.write(origDataBytes);
            out.flush();
            FailSafeTransaction trans = this.fileAccessService.createFailSafeTransaction(temp);
            FailSafeTransaction trans2 = this.fileAccessService.createFailSafeTransaction(temp);
            trans.beginTransaction();
            out.write(wrongData.getBytes());
            out.flush();
            trans2.restoreFile();
            out.close();
            TestFailSafeTransaction.assertEquals((String)"the file hasn't the right size after a commit", (long)temp.length(), (long)origDataBytes.length);
            FileInputStream in = new FileInputStream(temp);
            byte[] buffer = new byte[in.available()];
            in.read(buffer);
            in.close();
            String content = new String(buffer);
            TestFailSafeTransaction.assertEquals((String)"the file content isn't correct", (String)origData, (String)content);
            temp.delete();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

