/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.replacement.smiley;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.java.sip.communicator.impl.replacement.smiley.Resources;
import net.java.sip.communicator.service.replacement.smilies.Smiley;
import net.java.sip.communicator.service.replacement.smilies.SmiliesReplacementService;
import net.java.sip.communicator.util.GuiUtils;
import net.java.sip.communicator.util.Logger;

public class ReplacementServiceSmileyImpl
implements SmiliesReplacementService {
    private static final Logger logger = Logger.getLogger(ReplacementServiceSmileyImpl.class);
    private static final List<String> smileyStrings = new ArrayList<String>();
    public static final String SMILEY_SOURCE = "SMILEY";
    public static String smileyRegex;

    public String getReplacement(String sourceString) {
        try {
            Smiley smiley = Resources.getSmiley(sourceString.trim());
            if (smiley != null) {
                return smiley.getImagePath();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to get smiley replacement for " + sourceString), (Throwable)e);
        }
        return sourceString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSmileyPattern(Collection<Smiley> smileys) {
        List<String> list = smileyStrings;
        synchronized (list) {
            boolean smileyStringsIsEqual;
            if (smileyRegex == null) {
                smileyStringsIsEqual = false;
            } else {
                smileyStringsIsEqual = true;
                int smileyStringIndex = 0;
                int smileyStringCount = smileyStrings.size();
                block3: for (Smiley smiley : smileys) {
                    for (String smileyString : smiley.getSmileyStrings()) {
                        if (smileyStringIndex < smileyStringCount && smileyString.equals(smileyStrings.get(smileyStringIndex))) {
                            ++smileyStringIndex;
                            continue;
                        }
                        smileyStringsIsEqual = false;
                        break block3;
                    }
                }
                if (smileyStringsIsEqual && smileyStringIndex != smileyStringCount) {
                    smileyStringsIsEqual = false;
                }
            }
            if (!smileyStringsIsEqual) {
                smileyStrings.clear();
                StringBuffer regex = new StringBuffer();
                regex.append("(?<!(alt='|alt=\"))(");
                for (Smiley smiley : smileys) {
                    for (String smileyString : smiley.getSmileyStrings()) {
                        smileyStrings.add(smileyString);
                        regex.append(GuiUtils.replaceSpecialRegExpChars((String)smileyString)).append("|");
                    }
                }
                regex = regex.deleteCharAt(regex.length() - 1);
                regex.append(')');
                smileyRegex = regex.toString();
            }
            return smileyRegex;
        }
    }

    public String getSourceName() {
        return SMILEY_SOURCE;
    }

    public String getPattern() {
        Collection<Smiley> smileys = Resources.getDefaultSmileyPack();
        return ReplacementServiceSmileyImpl.getSmileyPattern(smileys);
    }

    public Collection<Smiley> getSmiliesPack() {
        return Resources.getDefaultSmileyPack();
    }

    public void reloadSmiliesPack() {
        Resources.reloadResources();
    }
}

