/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.io.File;
import java.util.Date;
import net.java.sip.communicator.impl.protocol.icq.FileTransferImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetFileTransferIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ProtocolProviderServiceIcqImpl;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.FileTransfer;
import net.java.sip.communicator.service.protocol.IncomingFileTransferRequest;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.event.FileTransferCreatedEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferRequestEvent;
import net.java.sip.communicator.util.Logger;
import net.kano.joscar.rvcmd.SegmentedFilename;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.FileMapper;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.IncomingFileTransfer;

public class IncomingFileTransferRequestIcqImpl
implements IncomingFileTransferRequest {
    private static final Logger logger = Logger.getLogger(IncomingFileTransferRequestIcqImpl.class);
    private ProtocolProviderServiceIcqImpl icqProvider;
    private OperationSetFileTransferIcqImpl fileTransferOpSet;
    private IncomingFileTransfer incomingFileTransfer = null;
    private Contact sender = null;
    private Date date;
    private String id;

    public IncomingFileTransferRequestIcqImpl(ProtocolProviderServiceIcqImpl icqProvider, OperationSetFileTransferIcqImpl fileTransferOpSet, IncomingFileTransfer fileTransfer, Contact sender, Date date) {
        this.icqProvider = icqProvider;
        this.fileTransferOpSet = fileTransferOpSet;
        this.incomingFileTransfer = fileTransfer;
        this.sender = sender;
        this.date = date;
        this.id = String.valueOf(this.incomingFileTransfer.getRvSessionInfo().getRvSession().getRvSessionId());
    }

    public String getID() {
        return this.id;
    }

    public String getFileName() {
        return this.incomingFileTransfer.getRequestFileInfo().getFilename();
    }

    public String getFileDescription() {
        return this.incomingFileTransfer.getInvitationMessage().getMessage();
    }

    public long getFileSize() {
        return this.incomingFileTransfer.getRequestFileInfo().getTotalFileSize();
    }

    public Contact getSender() {
        return this.sender;
    }

    public FileTransfer acceptFile(File file) {
        this.incomingFileTransfer.setFileMapper(new IcqFileMapper(file));
        FileTransferImpl inFileTransfer = new FileTransferImpl(this.incomingFileTransfer, this.id, this.sender, file, 1);
        FileTransferCreatedEvent event = new FileTransferCreatedEvent((FileTransfer)inFileTransfer, this.date);
        this.fileTransferOpSet.fireFileTransferCreated(event);
        this.incomingFileTransfer.accept();
        inFileTransfer.fireStatusChangeEvent(6);
        return inFileTransfer;
    }

    public void rejectFile() {
        try {
            this.incomingFileTransfer.close();
            this.fileTransferOpSet.fireFileTransferRequestRejected(new FileTransferRequestEvent((OperationSetFileTransfer)this.fileTransferOpSet, (IncomingFileTransferRequest)this, this.date));
        }
        catch (IllegalStateException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Error rejecting file", (Throwable)e);
            }
            return;
        }
    }

    public byte[] getThumbnail() {
        return null;
    }

    private class IcqFileMapper
    implements FileMapper {
        File file = null;

        public IcqFileMapper(File file) {
            this.file = file;
        }

        @Override
        public File getDestinationFile(SegmentedFilename filename) {
            return this.file;
        }

        @Override
        public File getUnspecifiedFilename() {
            return this.file;
        }
    }
}

