/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.globalshortcut;

import java.util.Collection;
import net.java.sip.communicator.impl.globalshortcut.GlobalShortcutServiceImpl;
import net.java.sip.communicator.service.globalshortcut.GlobalShortcutService;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.keybindings.KeybindingsService;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallListener;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class GlobalShortcutActivator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(GlobalShortcutActivator.class);
    protected static GlobalShortcutServiceImpl globalShortcutService = null;
    private static BundleContext bundleContext = null;
    private static KeybindingsService keybindingsService = null;
    private static UIService uiService = null;

    public static KeybindingsService getKeybindingsService() {
        if (keybindingsService == null) {
            keybindingsService = (KeybindingsService)ServiceUtils.getService((BundleContext)bundleContext, KeybindingsService.class);
        }
        return keybindingsService;
    }

    public static UIService getUIService() {
        if (uiService == null) {
            uiService = (UIService)ServiceUtils.getService((BundleContext)bundleContext, UIService.class);
        }
        return uiService;
    }

    public void start(BundleContext bundleContext) throws Exception {
        GlobalShortcutActivator.bundleContext = bundleContext;
        globalShortcutService = new GlobalShortcutServiceImpl();
        globalShortcutService.start();
        bundleContext.registerService(GlobalShortcutService.class, (Object)globalShortcutService, null);
        globalShortcutService.reloadGlobalShortcuts();
        this.registerListenerWithProtocolProviderService();
        bundleContext.addServiceListener(new ServiceListener(){

            public void serviceChanged(ServiceEvent serviceEvent) {
                GlobalShortcutActivator.this.serviceChanged(serviceEvent);
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"GlobalShortcut Service ... [REGISTERED]");
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        globalShortcutService.stop();
        GlobalShortcutActivator.bundleContext = null;
    }

    private void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        if (serviceRef.getBundle().getState() == 16) {
            return;
        }
        Object service = bundleContext.getService(serviceRef);
        if (!(service instanceof ProtocolProviderService)) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                this.handleProviderAdded((ProtocolProviderService)service);
                break;
            }
            case 4: {
                this.handleProviderRemoved((ProtocolProviderService)service);
            }
        }
    }

    public void registerListenerWithProtocolProviderService() {
        Collection ppsRefs = ServiceUtils.getServiceReferences((BundleContext)bundleContext, ProtocolProviderService.class);
        if (!ppsRefs.isEmpty()) {
            for (ServiceReference ppsRef : ppsRefs) {
                ProtocolProviderService pps = (ProtocolProviderService)bundleContext.getService(ppsRef);
                OperationSetBasicTelephony opSet = (OperationSetBasicTelephony)pps.getOperationSet(OperationSetBasicTelephony.class);
                if (opSet == null) continue;
                opSet.addCallListener((CallListener)globalShortcutService.getCallShortcut());
            }
        }
    }

    private void handleProviderAdded(ProtocolProviderService provider) {
        OperationSetBasicTelephony opSet = (OperationSetBasicTelephony)provider.getOperationSet(OperationSetBasicTelephony.class);
        if (opSet != null) {
            opSet.addCallListener((CallListener)globalShortcutService.getCallShortcut());
        }
    }

    private void handleProviderRemoved(ProtocolProviderService provider) {
        OperationSetBasicTelephony opSet = (OperationSetBasicTelephony)provider.getOperationSet(OperationSetBasicTelephony.class);
        if (opSet != null) {
            opSet.removeCallListener((CallListener)globalShortcutService.getCallShortcut());
        }
    }
}

