/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.remotebitrateestimator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.fmj.media.rtp.util.RTPPacket;
import org.ice4j.util.RateStatistics;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.AimdRateControl;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.BandwidthUsage;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.CallStatsObserver;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.InterArrival;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.OverUseDetectorOptions;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.OveruseDetector;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.OveruseEstimator;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RateControlInput;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RemoteBitrateObserver;
import org.jitsi.service.neomedia.rtp.RemoteBitrateEstimator;
import org.jitsi.util.concurrent.RecurringRunnable;

public class RemoteBitrateEstimatorSingleStream
implements CallStatsObserver,
RecurringRunnable,
RemoteBitrateEstimator {
    static final double kTimestampToMs = 0.011111111111111112;
    private final Object critSect = new Object();
    private final long[] deltas = new long[3];
    private final RateStatistics incomingBitrate = new RateStatistics(1000, 8000.0f);
    private final RateControlInput input = new RateControlInput(BandwidthUsage.kBwNormal, 0L, 0.0);
    private long lastProcessTime = -1L;
    private final RemoteBitrateObserver observer;
    private final Map<Integer, Detector> overuseDetectors = new HashMap<Integer, Detector>();
    private long processIntervalMs = 500L;
    private final AimdRateControl remoteRate = new AimdRateControl();
    private Collection<Integer> ssrcs;

    public RemoteBitrateEstimatorSingleStream(RemoteBitrateObserver observer) {
        this.observer = observer;
    }

    private long getExtensionTransmissionTimeOffset(RTPPacket header) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatestEstimate() {
        long bitrateBps;
        Object object = this.critSect;
        synchronized (object) {
            bitrateBps = this.remoteRate.isValidEstimate() ? (this.getSsrcs().isEmpty() ? 0L : this.remoteRate.getLatestEstimate()) : -1L;
        }
        return bitrateBps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Integer> getSsrcs() {
        Object object = this.critSect;
        synchronized (object) {
            if (this.ssrcs == null) {
                this.ssrcs = Collections.unmodifiableCollection(new ArrayList<Integer>(this.overuseDetectors.keySet()));
            }
            return this.ssrcs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeUntilNextRun() {
        if (this.lastProcessTime < 0L) {
            return 0L;
        }
        Object object = this.critSect;
        synchronized (object) {
            return this.lastProcessTime + this.processIntervalMs - System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incomingPacket(long arrivalTimeMs, int payloadSize, int ssrc, long rtpTimestamp, boolean wasPaced) {
        Integer ssrc_ = ssrc;
        long nowMs = System.currentTimeMillis();
        Object object = this.critSect;
        synchronized (object) {
            Detector it = this.overuseDetectors.get(ssrc_);
            if (it == null) {
                it = new Detector(nowMs, new OverUseDetectorOptions(), true);
                this.overuseDetectors.put(ssrc_, it);
                this.ssrcs = null;
            }
            Detector estimator = it;
            estimator.lastPacketTimeMs = nowMs;
            this.incomingBitrate.update(payloadSize, nowMs);
            BandwidthUsage priorState = estimator.detector.getState();
            long[] deltas = this.deltas;
            deltas[0] = 0L;
            deltas[1] = 0L;
            deltas[2] = 0L;
            if (estimator.interArrival.computeDeltas(rtpTimestamp, arrivalTimeMs, payloadSize, deltas)) {
                double timestampDeltaMs = (double)deltas[0] * 0.011111111111111112;
                estimator.estimator.update(deltas[1], timestampDeltaMs, (int)deltas[2], estimator.detector.getState());
                estimator.detector.detect(estimator.estimator.getOffset(), timestampDeltaMs, estimator.estimator.getNumOfDeltas(), nowMs);
            }
            if (estimator.detector.getState() == BandwidthUsage.kBwOverusing) {
                long incomingBitrateBps = this.incomingBitrate.getRate(nowMs);
                if (priorState != BandwidthUsage.kBwOverusing || this.remoteRate.isTimeToReduceFurther(nowMs, incomingBitrateBps)) {
                    this.updateEstimate(nowMs);
                }
            }
        }
    }

    @Override
    public void incomingPacket(long arrivalTimeMs, int payloadSize, RTPPacket header, boolean wasPaced) {
        int ssrc = header.ssrc;
        long rtpTimestamp = header.timestamp + this.getExtensionTransmissionTimeOffset(header);
        this.incomingPacket(arrivalTimeMs, payloadSize, ssrc, rtpTimestamp, wasPaced);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRttUpdate(long avgRttMs, long maxRttMs) {
        Object object = this.critSect;
        synchronized (object) {
            this.remoteRate.setRtt(avgRttMs);
        }
    }

    @Override
    public void run() {
        if (this.getTimeUntilNextRun() <= 0L) {
            long nowMs = System.currentTimeMillis();
            this.updateEstimate(nowMs);
            this.lastProcessTime = nowMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStream(int ssrc) {
        Object object = this.critSect;
        synchronized (object) {
            this.overuseDetectors.remove(ssrc);
            this.ssrcs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMinBitrate(int minBitrateBps) {
        Object object = this.critSect;
        synchronized (object) {
            this.remoteRate.setMinBitrate(minBitrateBps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEstimate(long nowMs) {
        Object object = this.critSect;
        synchronized (object) {
            BandwidthUsage bwState = BandwidthUsage.kBwNormal;
            double sumVarNoise = 0.0;
            Iterator<Detector> it = this.overuseDetectors.values().iterator();
            while (it.hasNext()) {
                Detector overuseDetector = it.next();
                long timeOfLastReceivedPacket = overuseDetector.lastPacketTimeMs;
                if (timeOfLastReceivedPacket >= 0L && nowMs - timeOfLastReceivedPacket > 2000L) {
                    it.remove();
                    this.ssrcs = null;
                    continue;
                }
                sumVarNoise += overuseDetector.estimator.getVarNoise();
                BandwidthUsage overuseDetectorBwState = overuseDetector.detector.getState();
                if (overuseDetectorBwState.ordinal() <= bwState.ordinal()) continue;
                bwState = overuseDetectorBwState;
            }
            if (this.overuseDetectors.isEmpty()) {
                this.remoteRate.reset();
                return;
            }
            double meanNoiseVar = sumVarNoise / (double)this.overuseDetectors.size();
            RateControlInput input = this.input;
            input.bwState = bwState;
            input.incomingBitRate = this.incomingBitrate.getRate(nowMs);
            input.noiseVar = meanNoiseVar;
            this.remoteRate.update(input, nowMs);
            long targetBitrate = this.remoteRate.updateBandwidthEstimate(nowMs);
            if (this.remoteRate.isValidEstimate()) {
                this.processIntervalMs = this.remoteRate.getFeedBackInterval();
                RemoteBitrateObserver observer = this.observer;
                if (observer != null) {
                    observer.onReceiveBitrateChanged(this.getSsrcs(), targetBitrate);
                }
            }
        }
    }

    private static class Detector {
        public OveruseDetector detector;
        public OveruseEstimator estimator;
        public InterArrival interArrival;
        public long lastPacketTimeMs;

        public Detector(long lastPacketTimeMs, OverUseDetectorOptions options, boolean enableBurstGrouping) {
            this.lastPacketTimeMs = lastPacketTimeMs;
            this.interArrival = new InterArrival(450L, 0.011111111111111112, enableBurstGrouping);
            this.estimator = new OveruseEstimator(options);
            this.detector = new OveruseDetector(options);
        }
    }
}

