/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver.expr;

import com.github.zafarkhaja.semver.Parser;
import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.expr.CompositeExpression;
import com.github.zafarkhaja.semver.expr.Expression;
import com.github.zafarkhaja.semver.expr.Lexer;
import com.github.zafarkhaja.semver.expr.UnexpectedTokenException;
import com.github.zafarkhaja.semver.util.Stream;
import com.github.zafarkhaja.semver.util.UnexpectedElementException;
import java.util.EnumSet;
import java.util.Iterator;

public class ExpressionParser
implements Parser<Expression> {
    private final Lexer lexer;
    private Stream<Lexer.Token> tokens;

    ExpressionParser(Lexer lexer) {
        this.lexer = lexer;
    }

    public static Parser<Expression> newInstance() {
        return new ExpressionParser(new Lexer());
    }

    @Override
    public Expression parse(String string) {
        this.tokens = this.lexer.tokenize(string);
        CompositeExpression compositeExpression = this.parseSemVerExpression();
        this.consumeNextToken(Lexer.Token.Type.EOI);
        return compositeExpression;
    }

    private CompositeExpression parseSemVerExpression() {
        CompositeExpression compositeExpression;
        if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.NOT})) {
            this.tokens.consume();
            this.consumeNextToken(Lexer.Token.Type.LEFT_PAREN);
            compositeExpression = CompositeExpression.Helper.not(this.parseSemVerExpression());
            this.consumeNextToken(Lexer.Token.Type.RIGHT_PAREN);
        } else if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.LEFT_PAREN})) {
            this.consumeNextToken(Lexer.Token.Type.LEFT_PAREN);
            compositeExpression = this.parseSemVerExpression();
            this.consumeNextToken(Lexer.Token.Type.RIGHT_PAREN);
        } else {
            compositeExpression = this.parseRange();
        }
        return this.parseMoreExpressions(compositeExpression);
    }

    private CompositeExpression parseMoreExpressions(CompositeExpression compositeExpression) {
        if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.AND})) {
            this.tokens.consume();
            compositeExpression = compositeExpression.and(this.parseSemVerExpression());
        } else if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.OR})) {
            this.tokens.consume();
            compositeExpression = compositeExpression.or(this.parseSemVerExpression());
        }
        return compositeExpression;
    }

    private CompositeExpression parseRange() {
        if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.TILDE})) {
            return this.parseTildeRange();
        }
        if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.CARET})) {
            return this.parseCaretRange();
        }
        if (this.isWildcardRange()) {
            return this.parseWildcardRange();
        }
        if (this.isHyphenRange()) {
            return this.parseHyphenRange();
        }
        if (this.isPartialVersionRange()) {
            return this.parsePartialVersionRange();
        }
        return this.parseComparisonRange();
    }

    private CompositeExpression parseComparisonRange() {
        CompositeExpression compositeExpression;
        Lexer.Token token = this.tokens.lookahead();
        switch (token.type) {
            case EQUAL: {
                this.tokens.consume();
                compositeExpression = CompositeExpression.Helper.eq(this.parseVersion());
                break;
            }
            case NOT_EQUAL: {
                this.tokens.consume();
                compositeExpression = CompositeExpression.Helper.neq(this.parseVersion());
                break;
            }
            case GREATER: {
                this.tokens.consume();
                compositeExpression = CompositeExpression.Helper.gt(this.parseVersion());
                break;
            }
            case GREATER_EQUAL: {
                this.tokens.consume();
                compositeExpression = CompositeExpression.Helper.gte(this.parseVersion());
                break;
            }
            case LESS: {
                this.tokens.consume();
                compositeExpression = CompositeExpression.Helper.lt(this.parseVersion());
                break;
            }
            case LESS_EQUAL: {
                this.tokens.consume();
                compositeExpression = CompositeExpression.Helper.lte(this.parseVersion());
                break;
            }
            default: {
                compositeExpression = CompositeExpression.Helper.eq(this.parseVersion());
            }
        }
        return compositeExpression;
    }

    private CompositeExpression parseTildeRange() {
        this.consumeNextToken(Lexer.Token.Type.TILDE);
        int n = this.intOf(this.consumeNextToken((Lexer.Token.Type[])new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC}).lexeme);
        if (!this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            return CompositeExpression.Helper.gte(this.versionFor(n)).and(CompositeExpression.Helper.lt(this.versionFor(n + 1)));
        }
        this.consumeNextToken(Lexer.Token.Type.DOT);
        int n2 = this.intOf(this.consumeNextToken((Lexer.Token.Type[])new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC}).lexeme);
        if (!this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            return CompositeExpression.Helper.gte(this.versionFor(n, n2)).and(CompositeExpression.Helper.lt(this.versionFor(n, n2 + 1)));
        }
        this.consumeNextToken(Lexer.Token.Type.DOT);
        int n3 = this.intOf(this.consumeNextToken((Lexer.Token.Type[])new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC}).lexeme);
        return CompositeExpression.Helper.gte(this.versionFor(n, n2, n3)).and(CompositeExpression.Helper.lt(this.versionFor(n, n2 + 1)));
    }

    private CompositeExpression parseCaretRange() {
        this.consumeNextToken(Lexer.Token.Type.CARET);
        int n = this.intOf(this.consumeNextToken((Lexer.Token.Type[])new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC}).lexeme);
        if (!this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            return CompositeExpression.Helper.gte(this.versionFor(n)).and(CompositeExpression.Helper.lt(this.versionFor(n + 1)));
        }
        this.consumeNextToken(Lexer.Token.Type.DOT);
        int n2 = this.intOf(this.consumeNextToken((Lexer.Token.Type[])new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC}).lexeme);
        if (!this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            Version version = this.versionFor(n, n2);
            Version version2 = n > 0 ? version.incrementMajorVersion() : version.incrementMinorVersion();
            return CompositeExpression.Helper.gte(version).and(CompositeExpression.Helper.lt(version2));
        }
        this.consumeNextToken(Lexer.Token.Type.DOT);
        int n3 = this.intOf(this.consumeNextToken((Lexer.Token.Type[])new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC}).lexeme);
        Version version = this.versionFor(n, n2, n3);
        CompositeExpression compositeExpression = CompositeExpression.Helper.gte(version);
        if (n > 0) {
            return compositeExpression.and(CompositeExpression.Helper.lt(version.incrementMajorVersion()));
        }
        if (n2 > 0) {
            return compositeExpression.and(CompositeExpression.Helper.lt(version.incrementMinorVersion()));
        }
        if (n3 > 0) {
            return compositeExpression.and(CompositeExpression.Helper.lt(version.incrementPatchVersion()));
        }
        return CompositeExpression.Helper.eq(version);
    }

    private boolean isWildcardRange() {
        return this.isVersionFollowedBy(Lexer.Token.Type.WILDCARD);
    }

    private CompositeExpression parseWildcardRange() {
        if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.WILDCARD})) {
            this.tokens.consume();
            return CompositeExpression.Helper.gte(this.versionFor(0, 0, 0));
        }
        int n = this.intOf(this.consumeNextToken((Lexer.Token.Type[])new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC}).lexeme);
        this.consumeNextToken(Lexer.Token.Type.DOT);
        if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.WILDCARD})) {
            this.tokens.consume();
            return CompositeExpression.Helper.gte(this.versionFor(n)).and(CompositeExpression.Helper.lt(this.versionFor(n + 1)));
        }
        int n2 = this.intOf(this.consumeNextToken((Lexer.Token.Type[])new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC}).lexeme);
        this.consumeNextToken(Lexer.Token.Type.DOT);
        this.consumeNextToken(Lexer.Token.Type.WILDCARD);
        return CompositeExpression.Helper.gte(this.versionFor(n, n2)).and(CompositeExpression.Helper.lt(this.versionFor(n, n2 + 1)));
    }

    private boolean isHyphenRange() {
        return this.isVersionFollowedBy(Lexer.Token.Type.HYPHEN);
    }

    private CompositeExpression parseHyphenRange() {
        CompositeExpression compositeExpression = CompositeExpression.Helper.gte(this.parseVersion());
        this.consumeNextToken(Lexer.Token.Type.HYPHEN);
        return compositeExpression.and(CompositeExpression.Helper.lte(this.parseVersion()));
    }

    private boolean isPartialVersionRange() {
        if (!this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC})) {
            return false;
        }
        EnumSet<Lexer.Token.Type> enumSet = EnumSet.complementOf(EnumSet.of(Lexer.Token.Type.NUMERIC, Lexer.Token.Type.DOT));
        return this.tokens.positiveLookaheadUntil(5, enumSet.toArray(new Lexer.Token.Type[enumSet.size()]));
    }

    private CompositeExpression parsePartialVersionRange() {
        int n = this.intOf(this.consumeNextToken((Lexer.Token.Type[])new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC}).lexeme);
        if (!this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            return CompositeExpression.Helper.gte(this.versionFor(n)).and(CompositeExpression.Helper.lt(this.versionFor(n + 1)));
        }
        this.consumeNextToken(Lexer.Token.Type.DOT);
        int n2 = this.intOf(this.consumeNextToken((Lexer.Token.Type[])new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC}).lexeme);
        return CompositeExpression.Helper.gte(this.versionFor(n, n2)).and(CompositeExpression.Helper.lt(this.versionFor(n, n2 + 1)));
    }

    private Version parseVersion() {
        int n = this.intOf(this.consumeNextToken((Lexer.Token.Type[])new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC}).lexeme);
        int n2 = 0;
        if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            this.tokens.consume();
            n2 = this.intOf(this.consumeNextToken((Lexer.Token.Type[])new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC}).lexeme);
        }
        int n3 = 0;
        if (this.tokens.positiveLookahead(new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            this.tokens.consume();
            n3 = this.intOf(this.consumeNextToken((Lexer.Token.Type[])new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC}).lexeme);
        }
        return this.versionFor(n, n2, n3);
    }

    private boolean isVersionFollowedBy(Stream.ElementType<Lexer.Token> elementType) {
        EnumSet<Lexer.Token.Type> enumSet = EnumSet.of(Lexer.Token.Type.NUMERIC, Lexer.Token.Type.DOT);
        Iterator<Lexer.Token> iterator = this.tokens.iterator();
        Lexer.Token token = null;
        while (iterator.hasNext()) {
            token = iterator.next();
            if (enumSet.contains(token.type)) continue;
            break;
        }
        return elementType.isMatchedBy(token);
    }

    private Version versionFor(int n) {
        return this.versionFor(n, 0, 0);
    }

    private Version versionFor(int n, int n2) {
        return this.versionFor(n, n2, 0);
    }

    private Version versionFor(int n, int n2, int n3) {
        return Version.forIntegers(n, n2, n3);
    }

    private int intOf(String string) {
        return Integer.parseInt(string);
    }

    private Lexer.Token consumeNextToken(Lexer.Token.Type ... typeArray) {
        try {
            return (Lexer.Token)this.tokens.consume(typeArray);
        }
        catch (UnexpectedElementException unexpectedElementException) {
            throw new UnexpectedTokenException(unexpectedElementException);
        }
    }
}

