/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.JavaClassContext;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassParent;
import com.thoughtworks.qdox.model.TypeVariable;
import com.thoughtworks.qdox.model.WildcardType;
import com.thoughtworks.qdox.parser.structs.TypeDef;
import com.thoughtworks.qdox.parser.structs.WildcardTypeDef;
import java.io.Serializable;

public class Type
implements Comparable,
Serializable {
    public static final Type[] EMPTY_ARRAY = new Type[0];
    public static final Type VOID = new Type("void");
    private String name;
    private JavaClassParent context;
    private String fullName;
    private int dimensions;
    private Type[] actualArgumentTypes;

    public Type(String string, String string2, int n, JavaClassParent javaClassParent) {
        this.fullName = string;
        this.name = string2;
        this.dimensions = n;
        this.context = javaClassParent;
    }

    public Type(String string, TypeDef typeDef, int n, JavaClassParent javaClassParent) {
        this.fullName = string;
        this.name = typeDef.name;
        this.dimensions = typeDef.dimensions + n;
        if (typeDef.actualArgumentTypes != null && !typeDef.actualArgumentTypes.isEmpty()) {
            this.actualArgumentTypes = new Type[typeDef.actualArgumentTypes.size()];
            for (int i = 0; i < typeDef.actualArgumentTypes.size(); ++i) {
                this.actualArgumentTypes[i] = Type.createUnresolved((TypeDef)typeDef.actualArgumentTypes.get(i), javaClassParent);
            }
        }
        this.context = javaClassParent;
    }

    public Type(String string, int n, JavaClassParent javaClassParent) {
        this(string, (String)null, n, javaClassParent);
    }

    public Type(String string, int n) {
        this(string, n, null);
    }

    public Type(String string) {
        this(string, 0);
    }

    public static Type createUnresolved(String string, int n, JavaClassParent javaClassParent) {
        return new Type(null, string, n, javaClassParent);
    }

    public static Type createUnresolved(TypeDef typeDef, int n, JavaClassParent javaClassParent) {
        return new Type(null, typeDef, n, javaClassParent);
    }

    public static Type createUnresolved(TypeDef typeDef, JavaClassParent javaClassParent) {
        if (typeDef instanceof WildcardTypeDef) {
            return new WildcardType((WildcardTypeDef)typeDef, javaClassParent);
        }
        return new Type(null, typeDef, 0, javaClassParent);
    }

    public JavaClassParent getJavaClassParent() {
        return this.context;
    }

    public String getFullQualifiedName() {
        return this.getFullyQualifiedName();
    }

    public String getFullyQualifiedName() {
        return this.isResolved() ? this.fullName : this.name;
    }

    public String getValue() {
        String string = this.getFullyQualifiedName();
        return string == null ? "" : string.replaceAll("\\$", ".");
    }

    public String getGenericValue() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.getValue());
        if (this.actualArgumentTypes != null && this.actualArgumentTypes.length > 0) {
            stringBuffer.append("<");
            for (n = 0; n < this.actualArgumentTypes.length; ++n) {
                stringBuffer.append(this.actualArgumentTypes[n].getGenericValue());
                if (n + 1 == this.actualArgumentTypes.length) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(">");
        }
        for (n = 0; n < this.dimensions; ++n) {
            stringBuffer.append("[]");
        }
        return stringBuffer.toString();
    }

    protected String getGenericValue(TypeVariable[] typeVariableArray) {
        StringBuffer stringBuffer = new StringBuffer(this.getResolvedValue(typeVariableArray));
        if (this.actualArgumentTypes != null && this.actualArgumentTypes.length > 0) {
            for (int i = 0; i < this.actualArgumentTypes.length; ++i) {
                stringBuffer.append(this.actualArgumentTypes[i].getResolvedGenericValue(typeVariableArray));
                if (i + 1 == this.actualArgumentTypes.length) continue;
                stringBuffer.append(",");
            }
        }
        return stringBuffer.toString();
    }

    protected String getResolvedValue(TypeVariable[] typeVariableArray) {
        String string = this.getValue();
        for (int i = 0; i < typeVariableArray.length; ++i) {
            if (!typeVariableArray[i].getName().equals(this.getValue())) continue;
            string = typeVariableArray[i].getValue();
            break;
        }
        return string;
    }

    protected String getResolvedGenericValue(TypeVariable[] typeVariableArray) {
        String string = this.getGenericValue(typeVariableArray);
        for (int i = 0; i < typeVariableArray.length; ++i) {
            if (!typeVariableArray[i].getName().equals(this.getValue())) continue;
            string = typeVariableArray[i].getGenericValue();
            break;
        }
        return string;
    }

    public boolean isResolved() {
        if (this.fullName == null && this.context != null) {
            this.fullName = this.context.resolveType(this.name);
        }
        return this.fullName != null;
    }

    public int compareTo(Object object) {
        if (!(object instanceof Type)) {
            return 0;
        }
        return this.getValue().compareTo(((Type)object).getValue());
    }

    public boolean isArray() {
        return this.dimensions > 0;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public Type[] getActualTypeArguments() {
        return this.actualArgumentTypes;
    }

    public String toString() {
        if (this.dimensions == 0) {
            return this.getValue();
        }
        StringBuffer stringBuffer = new StringBuffer(this.getValue());
        for (int i = 0; i < this.dimensions; ++i) {
            stringBuffer.append("[]");
        }
        String string = stringBuffer.toString();
        return string;
    }

    public String toGenericString() {
        if (this.dimensions == 0) {
            return this.getGenericValue();
        }
        StringBuffer stringBuffer = new StringBuffer(this.getGenericValue());
        for (int i = 0; i < this.dimensions; ++i) {
            stringBuffer.append("[]");
        }
        String string = stringBuffer.toString();
        return string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Type type = (Type)object;
        return this.getValue().equals(type.getValue()) && type.getDimensions() == this.getDimensions();
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public JavaClass getJavaClass() {
        JavaClassContext javaClassContext;
        JavaClass javaClass = null;
        JavaClassParent javaClassParent = this.getJavaClassParent();
        if (javaClassParent != null && (javaClass = javaClassParent.getNestedClassByName(this.getFullyQualifiedName())) == null && (javaClassContext = javaClassParent.getJavaClassContext()).getClassLibrary() != null) {
            javaClass = javaClassContext.getClassByName(this.getFullyQualifiedName());
        }
        return javaClass;
    }

    public boolean isA(Type type) {
        if (this.equals(type)) {
            return true;
        }
        JavaClass javaClass = this.getJavaClass();
        if (javaClass != null) {
            Type[] typeArray = javaClass.getImplements();
            for (int i = 0; i < typeArray.length; ++i) {
                if (!typeArray[i].isA(type)) continue;
                return true;
            }
            Type type2 = javaClass.getSuperClass();
            if (type2 != null && type2.isA(type)) {
                return true;
            }
        }
        return false;
    }

    public boolean isPrimitive() {
        String string = this.getValue();
        if (string == null || string.length() == 0 || string.indexOf(46) > -1) {
            return false;
        }
        return "void".equals(string) || "boolean".equals(string) || "byte".equals(string) || "char".equals(string) || "short".equals(string) || "int".equals(string) || "long".equals(string) || "float".equals(string) || "double".equals(string);
    }

    public boolean isVoid() {
        return "void".equals(this.getValue());
    }

    protected int getTypeVariableIndex(JavaClass javaClass) {
        TypeVariable[] typeVariableArray = javaClass.getTypeParameters();
        for (int i = 0; i < typeVariableArray.length; ++i) {
            if (!typeVariableArray[i].getFullyQualifiedName().equals(this.getFullyQualifiedName())) continue;
            return i;
        }
        return -1;
    }

    protected Type resolve(JavaClass javaClass) {
        return this.resolve(javaClass, javaClass);
    }

    protected Type resolve(JavaClass javaClass, JavaClass javaClass2) {
        Type type = this;
        int n = this.getTypeVariableIndex(javaClass);
        if (n >= 0) {
            String string = javaClass.getFullyQualifiedName();
            if (javaClass2.getSuperClass() != null && string.equals(javaClass2.getSuperClass().getFullyQualifiedName())) {
                type = javaClass2.getSuperClass().getActualTypeArguments()[n];
            } else if (javaClass2.getImplementedInterfaces() != null) {
                for (int i = 0; i < javaClass2.getImplementedInterfaces().length; ++i) {
                    if (!string.equals(javaClass2.getImplements()[i].getFullyQualifiedName())) continue;
                    type = javaClass2.getImplements()[i].getActualTypeArguments()[n].resolve(javaClass2.getImplementedInterfaces()[i]);
                    break;
                }
            }
        }
        if (this.actualArgumentTypes != null) {
            type = new Type(this.fullName, this.name, this.dimensions, this.context);
            type.actualArgumentTypes = new Type[this.actualArgumentTypes.length];
            for (int i = 0; i < this.getActualTypeArguments().length; ++i) {
                type.actualArgumentTypes[i] = this.actualArgumentTypes[i].resolve(javaClass, javaClass2);
            }
        }
        return type;
    }
}

