/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.osgi.registry;

import org.apache.geronimo.osgi.registry.Activator;
import org.apache.geronimo.osgi.registry.ProviderRegistryImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class ProviderBundleTrackerCustomizer
implements BundleTrackerCustomizer {
    private Activator activator;
    private Bundle registryBundle;
    private ProviderRegistryImpl registry;

    public ProviderBundleTrackerCustomizer(Activator activator, Bundle bundle, ProviderRegistryImpl providerRegistryImpl) {
        this.activator = activator;
        this.registryBundle = bundle;
        this.registry = providerRegistryImpl;
    }

    public Object addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        this.log(4, "Bundle Considered for class providers: " + bundle.getSymbolicName());
        if (bundle.equals(this.registryBundle)) {
            return null;
        }
        return this.registry.addBundle(bundle);
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, Object object) {
        this.registry.removeBundle(bundle, object);
    }

    private void log(int n, String string) {
        this.activator.log(n, string);
    }

    private void log(int n, String string, Throwable throwable) {
        this.activator.log(n, string, throwable);
    }
}

