/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.InputStreamPumper;
import org.apache.commons.exec.StreamPumper;
import org.apache.commons.exec.util.DebugUtils;

public class PumpStreamHandler
implements ExecuteStreamHandler {
    private static final long STOP_TIMEOUT_ADDITION = 2000L;
    private Thread outputThread;
    private Thread errorThread;
    private Thread inputThread;
    private final OutputStream out;
    private final OutputStream err;
    private final InputStream input;
    private InputStreamPumper inputStreamPumper;
    private long stopTimeout;
    private IOException caught = null;

    public PumpStreamHandler() {
        this(System.out, System.err);
    }

    public PumpStreamHandler(OutputStream outputStream) {
        this(outputStream, outputStream);
    }

    public PumpStreamHandler(OutputStream outputStream, OutputStream outputStream2) {
        this(outputStream, outputStream2, null);
    }

    public PumpStreamHandler(OutputStream outputStream, OutputStream outputStream2, InputStream inputStream) {
        this.out = outputStream;
        this.err = outputStream2;
        this.input = inputStream;
    }

    public void setStopTimeout(long l) {
        this.stopTimeout = l;
    }

    @Override
    public void setProcessOutputStream(InputStream inputStream) {
        if (this.out != null) {
            this.createProcessOutputPump(inputStream, this.out);
        }
    }

    @Override
    public void setProcessErrorStream(InputStream inputStream) {
        if (this.err != null) {
            this.createProcessErrorPump(inputStream, this.err);
        }
    }

    @Override
    public void setProcessInputStream(OutputStream outputStream) {
        if (this.input != null) {
            this.inputThread = this.input == System.in ? this.createSystemInPump(this.input, outputStream) : this.createPump(this.input, outputStream, true);
        } else {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                DebugUtils.handleException("Got exception while closing output stream", iOException);
            }
        }
    }

    @Override
    public void start() {
        if (this.outputThread != null) {
            this.outputThread.start();
        }
        if (this.errorThread != null) {
            this.errorThread.start();
        }
        if (this.inputThread != null) {
            this.inputThread.start();
        }
    }

    @Override
    public void stop() throws IOException {
        if (this.inputStreamPumper != null) {
            this.inputStreamPumper.stopProcessing();
        }
        this.stopThread(this.outputThread, this.stopTimeout);
        this.stopThread(this.errorThread, this.stopTimeout);
        this.stopThread(this.inputThread, this.stopTimeout);
        if (this.err != null && this.err != this.out) {
            try {
                this.err.flush();
            }
            catch (IOException iOException) {
                String string = "Got exception while flushing the error stream : " + iOException.getMessage();
                DebugUtils.handleException(string, iOException);
            }
        }
        if (this.out != null) {
            try {
                this.out.flush();
            }
            catch (IOException iOException) {
                DebugUtils.handleException("Got exception while flushing the output stream", iOException);
            }
        }
        if (this.caught != null) {
            throw this.caught;
        }
    }

    protected OutputStream getErr() {
        return this.err;
    }

    protected OutputStream getOut() {
        return this.out;
    }

    protected void createProcessOutputPump(InputStream inputStream, OutputStream outputStream) {
        this.outputThread = this.createPump(inputStream, outputStream);
    }

    protected void createProcessErrorPump(InputStream inputStream, OutputStream outputStream) {
        this.errorThread = this.createPump(inputStream, outputStream);
    }

    protected Thread createPump(InputStream inputStream, OutputStream outputStream) {
        boolean bl = outputStream instanceof PipedOutputStream;
        return this.createPump(inputStream, outputStream, bl);
    }

    protected Thread createPump(InputStream inputStream, OutputStream outputStream, boolean bl) {
        Thread thread = new Thread((Runnable)new StreamPumper(inputStream, outputStream, bl), "Exec Stream Pumper");
        thread.setDaemon(true);
        return thread;
    }

    protected void stopThread(Thread thread, long l) {
        if (thread != null) {
            try {
                if (l == 0L) {
                    thread.join();
                } else {
                    long l2 = l + 2000L;
                    long l3 = System.currentTimeMillis();
                    thread.join(l2);
                    if (System.currentTimeMillis() >= l3 + l2) {
                        String string = "The stop timeout of " + l + " ms was exceeded";
                        this.caught = new ExecuteException(string, -559038737);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                thread.interrupt();
            }
        }
    }

    private Thread createSystemInPump(InputStream inputStream, OutputStream outputStream) {
        this.inputStreamPumper = new InputStreamPumper(inputStream, outputStream);
        Thread thread = new Thread((Runnable)this.inputStreamPumper, "Exec Input Stream Pumper");
        thread.setDaemon(true);
        return thread;
    }
}

