/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.launcher.CommandLauncher;
import org.apache.commons.exec.launcher.CommandLauncherFactory;

public class DefaultExecutor
implements Executor {
    private ExecuteStreamHandler streamHandler = new PumpStreamHandler();
    private File workingDirectory;
    private ExecuteWatchdog watchdog;
    private int[] exitValues;
    private final CommandLauncher launcher = CommandLauncherFactory.createVMLauncher();
    private ProcessDestroyer processDestroyer;
    private Thread executorThread;
    private IOException exceptionCaught = null;

    public DefaultExecutor() {
        this.exitValues = new int[0];
        this.workingDirectory = new File(".");
    }

    @Override
    public ExecuteStreamHandler getStreamHandler() {
        return this.streamHandler;
    }

    @Override
    public void setStreamHandler(ExecuteStreamHandler executeStreamHandler) {
        this.streamHandler = executeStreamHandler;
    }

    @Override
    public ExecuteWatchdog getWatchdog() {
        return this.watchdog;
    }

    @Override
    public void setWatchdog(ExecuteWatchdog executeWatchdog) {
        this.watchdog = executeWatchdog;
    }

    @Override
    public ProcessDestroyer getProcessDestroyer() {
        return this.processDestroyer;
    }

    @Override
    public void setProcessDestroyer(ProcessDestroyer processDestroyer) {
        this.processDestroyer = processDestroyer;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void setWorkingDirectory(File file) {
        this.workingDirectory = file;
    }

    @Override
    public int execute(CommandLine commandLine) throws ExecuteException, IOException {
        return this.execute(commandLine, (Map<String, String>)null);
    }

    @Override
    public int execute(CommandLine commandLine, Map<String, String> map) throws ExecuteException, IOException {
        if (this.workingDirectory != null && !this.workingDirectory.exists()) {
            throw new IOException(this.workingDirectory + " doesn't exist.");
        }
        return this.executeInternal(commandLine, map, this.workingDirectory, this.streamHandler);
    }

    @Override
    public void execute(CommandLine commandLine, ExecuteResultHandler executeResultHandler) throws ExecuteException, IOException {
        this.execute(commandLine, null, executeResultHandler);
    }

    @Override
    public void execute(final CommandLine commandLine, final Map<String, String> map, final ExecuteResultHandler executeResultHandler) throws ExecuteException, IOException {
        if (this.workingDirectory != null && !this.workingDirectory.exists()) {
            throw new IOException(this.workingDirectory + " doesn't exist.");
        }
        if (this.watchdog != null) {
            this.watchdog.setProcessNotStarted();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n = -559038737;
                try {
                    n = DefaultExecutor.this.executeInternal(commandLine, map, DefaultExecutor.this.workingDirectory, DefaultExecutor.this.streamHandler);
                    executeResultHandler.onProcessComplete(n);
                }
                catch (ExecuteException executeException) {
                    executeResultHandler.onProcessFailed(executeException);
                }
                catch (Exception exception) {
                    executeResultHandler.onProcessFailed(new ExecuteException("Execution failed", n, exception));
                }
            }
        };
        this.executorThread = this.createThread(runnable, "Exec Default Executor");
        this.getExecutorThread().start();
    }

    @Override
    public void setExitValue(int n) {
        this.setExitValues(new int[]{n});
    }

    @Override
    public void setExitValues(int[] nArray) {
        this.exitValues = nArray == null ? null : (int[])nArray.clone();
    }

    @Override
    public boolean isFailure(int n) {
        if (this.exitValues == null) {
            return false;
        }
        if (this.exitValues.length == 0) {
            return this.launcher.isFailure(n);
        }
        for (int n2 : this.exitValues) {
            if (n2 != n) continue;
            return false;
        }
        return true;
    }

    protected Thread createThread(Runnable runnable, String string) {
        return new Thread(runnable, string);
    }

    protected Process launch(CommandLine commandLine, Map<String, String> map, File file) throws IOException {
        if (this.launcher == null) {
            throw new IllegalStateException("CommandLauncher can not be null");
        }
        if (file != null && !file.exists()) {
            throw new IOException(file + " doesn't exist.");
        }
        return this.launcher.exec(commandLine, map, file);
    }

    protected Thread getExecutorThread() {
        return this.executorThread;
    }

    private void closeProcessStreams(Process process) {
        try {
            process.getInputStream().close();
        }
        catch (IOException iOException) {
            this.setExceptionCaught(iOException);
        }
        try {
            process.getOutputStream().close();
        }
        catch (IOException iOException) {
            this.setExceptionCaught(iOException);
        }
        try {
            process.getErrorStream().close();
        }
        catch (IOException iOException) {
            this.setExceptionCaught(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeInternal(CommandLine commandLine, Map<String, String> map, File file, ExecuteStreamHandler executeStreamHandler) throws IOException {
        this.setExceptionCaught(null);
        Process process = this.launch(commandLine, map, file);
        try {
            executeStreamHandler.setProcessInputStream(process.getOutputStream());
            executeStreamHandler.setProcessOutputStream(process.getInputStream());
            executeStreamHandler.setProcessErrorStream(process.getErrorStream());
        }
        catch (IOException iOException) {
            process.destroy();
            throw iOException;
        }
        executeStreamHandler.start();
        try {
            if (this.getProcessDestroyer() != null) {
                this.getProcessDestroyer().add(process);
            }
            if (this.watchdog != null) {
                this.watchdog.start(process);
            }
            int n = -559038737;
            try {
                n = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                process.destroy();
            }
            finally {
                Thread.interrupted();
            }
            if (this.watchdog != null) {
                this.watchdog.stop();
            }
            try {
                executeStreamHandler.stop();
            }
            catch (IOException iOException) {
                this.setExceptionCaught(iOException);
            }
            this.closeProcessStreams(process);
            if (this.getExceptionCaught() != null) {
                throw this.getExceptionCaught();
            }
            if (this.watchdog != null) {
                try {
                    this.watchdog.checkException();
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
            }
            if (this.isFailure(n)) {
                throw new ExecuteException("Process exited with an error: " + n, n);
            }
            int n2 = n;
            return n2;
        }
        finally {
            if (this.getProcessDestroyer() != null) {
                this.getProcessDestroyer().remove(process);
            }
        }
    }

    private void setExceptionCaught(IOException iOException) {
        if (this.exceptionCaught == null) {
            this.exceptionCaught = iOException;
        }
    }

    private IOException getExceptionCaught() {
        return this.exceptionCaught;
    }
}

