/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.easymock.EasyMock;
import org.easymock.internal.ClassInstantiatorFactory;
import org.easymock.internal.IClassInstantiator;
import org.easymock.internal.RecordState;

public class DefaultClassInstantiator
implements IClassInstantiator {
    private static final Class<?>[] EMPTY = new Class[0];

    @Override
    public Object newInstance(Class<?> clazz) throws InstantiationException {
        if (this.isSerializable(clazz)) {
            try {
                return DefaultClassInstantiator.readObject(DefaultClassInstantiator.getSerializedBytes(clazz));
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to instantiate " + clazz.getName() + "'s mock: ", iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Failed to instantiate " + clazz.getName() + "'s mock: ", classNotFoundException);
            }
        }
        Constructor<?> constructor = this.getConstructorToUse(clazz);
        Object[] objectArray = this.getArgsForTypes(constructor.getParameterTypes());
        try {
            return constructor.newInstance(objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException("Failed to instantiate " + clazz.getName() + "'s mock: ", illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Failed to instantiate " + clazz.getName() + "'s mock: ", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Failed to instantiate " + clazz.getName() + "'s mock: ", invocationTargetException);
        }
    }

    private boolean isSerializable(Class<?> clazz) {
        return Serializable.class.isAssignableFrom(clazz);
    }

    public Constructor<?> getConstructorToUse(Class<?> clazz) {
        try {
            return clazz.getConstructor(EMPTY);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (clazz.getConstructors().length == 0) {
                throw new IllegalArgumentException("No visible constructors in class " + clazz.getName());
            }
            return clazz.getConstructors()[0];
        }
    }

    public Object[] getArgsForTypes(Class<?>[] classArray) throws InstantiationException {
        Object[] objectArray = new Object[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i].isPrimitive()) {
                objectArray[i] = RecordState.emptyReturnValueFor(classArray[i]);
                continue;
            }
            if (Modifier.isFinal(classArray[i].getModifiers())) {
                objectArray[i] = this.newInstance(classArray[i]);
                continue;
            }
            Object obj = EasyMock.createNiceMock(classArray[i]);
            EasyMock.replay(obj);
            objectArray[i] = obj;
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getSerializedBytes(Class<?> clazz) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            dataOutputStream.writeShort(-21267);
            dataOutputStream.writeShort(5);
            dataOutputStream.writeByte(115);
            dataOutputStream.writeByte(114);
            dataOutputStream.writeUTF(clazz.getName());
            Long l = DefaultClassInstantiator.getSerializableUID(clazz);
            dataOutputStream.writeLong(l);
            dataOutputStream.writeByte(2);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeByte(120);
            dataOutputStream.writeByte(112);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static Long getSerializableUID(Class<?> clazz) {
        try {
            Field field = clazz.getDeclaredField("serialVersionUID");
            int n = 24;
            if ((field.getModifiers() & n) == n) {
                field.setAccessible(true);
                return field.getLong(null);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Should have been able to get serialVersionUID since it's there");
        }
        return DefaultClassInstantiator.callLongMethod(clazz, ClassInstantiatorFactory.is1_3Specifications() ? "computeSerialVersionUID" : "computeDefaultSUID");
    }

    private static Long callLongMethod(Class<?> clazz, String string) {
        Long l;
        Method method;
        try {
            method = ObjectStreamClass.class.getDeclaredMethod(string, Class.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError("ObjectStreamClass." + string + " seems to have vanished");
        }
        boolean bl = method.isAccessible();
        method.setAccessible(true);
        try {
            l = (Long)method.invoke(null, clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError("ObjectStreamClass." + string + " should have been accessible");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError("ObjectStreamClass." + string + " failled to be called: " + invocationTargetException.getMessage());
        }
        method.setAccessible(bl);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object readObject(byte[] byArray) throws IOException, ClassNotFoundException {
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));){
            Object object = objectInputStream.readObject();
            return object;
        }
    }
}

