/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public class ConstructorArgs {
    private final Constructor<?> constructor;
    private final Object[] initArgs;

    public ConstructorArgs(Constructor<?> constructor, Object ... objectArray) {
        this.constructor = constructor;
        this.initArgs = objectArray;
        this.validateArgs();
    }

    private void validateArgs() {
        Class<?>[] classArray = this.constructor.getParameterTypes();
        if (this.initArgs.length != classArray.length) {
            throw new IllegalArgumentException("Number of provided arguments doesn't match constructor ones");
        }
        for (int i = 0; i < this.initArgs.length; ++i) {
            Class<?> clazz = classArray[i];
            Object object = this.initArgs[i];
            if (clazz.isPrimitive()) {
                if (object == null) {
                    throw new IllegalArgumentException("Null argument for primitive param " + i);
                }
                try {
                    Field field = object.getClass().getDeclaredField("TYPE");
                    Class clazz2 = (Class)field.get(null);
                    if (clazz.equals(clazz2)) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    throw this.throwException(clazz, object);
                }
                throw this.throwException(clazz, object);
            }
            if (object == null || clazz.isAssignableFrom(object.getClass())) continue;
            throw this.throwException(clazz, object);
        }
    }

    private IllegalArgumentException throwException(Class<?> clazz, Object object) {
        return new IllegalArgumentException(object + " isn't of type " + clazz);
    }

    public Object[] getInitArgs() {
        return this.initArgs;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }
}

