/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.asm.optimizer;

import net.sf.cglib.asm.AnnotationVisitor;
import net.sf.cglib.asm.Attribute;
import net.sf.cglib.asm.ClassVisitor;
import net.sf.cglib.asm.FieldVisitor;
import net.sf.cglib.asm.MethodVisitor;
import net.sf.cglib.asm.TypePath;
import net.sf.cglib.asm.optimizer.AnnotationConstantsCollector;
import net.sf.cglib.asm.optimizer.ConstantPool;
import net.sf.cglib.asm.optimizer.FieldConstantsCollector;
import net.sf.cglib.asm.optimizer.MethodConstantsCollector;

public class ClassConstantsCollector
extends ClassVisitor {
    private final ConstantPool cp;

    public ClassConstantsCollector(ClassVisitor classVisitor, ConstantPool constantPool) {
        super(327680, classVisitor);
        this.cp = constantPool;
    }

    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        if ((n2 & 0x20000) != 0) {
            this.cp.newUTF8("Deprecated");
        }
        if ((n2 & 0x1000) != 0) {
            this.cp.newUTF8("Synthetic");
        }
        this.cp.newClass(string);
        if (string2 != null) {
            this.cp.newUTF8("Signature");
            this.cp.newUTF8(string2);
        }
        if (string3 != null) {
            this.cp.newClass(string3);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.cp.newClass(stringArray[i]);
            }
        }
        this.cv.visit(n, n2, string, string2, string3, stringArray);
    }

    public void visitSource(String string, String string2) {
        if (string != null) {
            this.cp.newUTF8("SourceFile");
            this.cp.newUTF8(string);
        }
        if (string2 != null) {
            this.cp.newUTF8("SourceDebugExtension");
        }
        this.cv.visitSource(string, string2);
    }

    public void visitOuterClass(String string, String string2, String string3) {
        this.cp.newUTF8("EnclosingMethod");
        this.cp.newClass(string);
        if (string2 != null && string3 != null) {
            this.cp.newNameType(string2, string3);
        }
        this.cv.visitOuterClass(string, string2, string3);
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.cp.newUTF8(string);
        if (bl) {
            this.cp.newUTF8("RuntimeVisibleAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleAnnotations");
        }
        return new AnnotationConstantsCollector(this.cv.visitAnnotation(string, bl), this.cp);
    }

    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        this.cp.newUTF8(string);
        if (bl) {
            this.cp.newUTF8("RuntimeVisibleTypeAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleTypeAnnotations");
        }
        return new AnnotationConstantsCollector(this.cv.visitAnnotation(string, bl), this.cp);
    }

    public void visitAttribute(Attribute attribute) {
        this.cv.visitAttribute(attribute);
    }

    public void visitInnerClass(String string, String string2, String string3, int n) {
        this.cp.newUTF8("InnerClasses");
        if (string != null) {
            this.cp.newClass(string);
        }
        if (string2 != null) {
            this.cp.newClass(string2);
        }
        if (string3 != null) {
            this.cp.newUTF8(string3);
        }
        this.cv.visitInnerClass(string, string2, string3, n);
    }

    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        if ((n & 0x1000) != 0) {
            this.cp.newUTF8("Synthetic");
        }
        if ((n & 0x20000) != 0) {
            this.cp.newUTF8("Deprecated");
        }
        this.cp.newUTF8(string);
        this.cp.newUTF8(string2);
        if (string3 != null) {
            this.cp.newUTF8("Signature");
            this.cp.newUTF8(string3);
        }
        if (object != null) {
            this.cp.newConst(object);
        }
        return new FieldConstantsCollector(this.cv.visitField(n, string, string2, string3, object), this.cp);
    }

    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        if ((n & 0x1000) != 0) {
            this.cp.newUTF8("Synthetic");
        }
        if ((n & 0x20000) != 0) {
            this.cp.newUTF8("Deprecated");
        }
        this.cp.newUTF8(string);
        this.cp.newUTF8(string2);
        if (string3 != null) {
            this.cp.newUTF8("Signature");
            this.cp.newUTF8(string3);
        }
        if (stringArray != null) {
            this.cp.newUTF8("Exceptions");
            for (int i = 0; i < stringArray.length; ++i) {
                this.cp.newClass(stringArray[i]);
            }
        }
        return new MethodConstantsCollector(this.cv.visitMethod(n, string, string2, string3, stringArray), this.cp);
    }
}

