/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolver;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverFactory;

public class UnivariateRealSolverUtils {
    private static final String NULL_FUNCTION_MESSAGE = "function is null";

    private UnivariateRealSolverUtils() {
    }

    public static double solve(UnivariateRealFunction univariateRealFunction, double d, double d2) throws ConvergenceException, FunctionEvaluationException {
        UnivariateRealSolverUtils.setup(univariateRealFunction);
        return LazyHolder.FACTORY.newDefaultSolver().solve(univariateRealFunction, d, d2);
    }

    public static double solve(UnivariateRealFunction univariateRealFunction, double d, double d2, double d3) throws ConvergenceException, FunctionEvaluationException {
        UnivariateRealSolverUtils.setup(univariateRealFunction);
        UnivariateRealSolver univariateRealSolver = LazyHolder.FACTORY.newDefaultSolver();
        univariateRealSolver.setAbsoluteAccuracy(d3);
        return univariateRealSolver.solve(univariateRealFunction, d, d2);
    }

    public static double[] bracket(UnivariateRealFunction univariateRealFunction, double d, double d2, double d3) throws ConvergenceException, FunctionEvaluationException {
        return UnivariateRealSolverUtils.bracket(univariateRealFunction, d, d2, d3, Integer.MAX_VALUE);
    }

    public static double[] bracket(UnivariateRealFunction univariateRealFunction, double d, double d2, double d3, int n) throws ConvergenceException, FunctionEvaluationException {
        double d4;
        double d5;
        if (univariateRealFunction == null) {
            throw MathRuntimeException.createIllegalArgumentException(NULL_FUNCTION_MESSAGE, new Object[0]);
        }
        if (n <= 0) {
            throw MathRuntimeException.createIllegalArgumentException("bad value for maximum iterations number: {0}", n);
        }
        if (d < d2 || d > d3 || d2 >= d3) {
            throw MathRuntimeException.createIllegalArgumentException("invalid bracketing parameters:  lower bound={0},  initial={1}, upper bound={2}", d2, d, d3);
        }
        double d6 = d;
        double d7 = d;
        int n2 = 0;
        do {
            d6 = Math.max(d6 - 1.0, d2);
            d7 = Math.min(d7 + 1.0, d3);
        } while ((d5 = univariateRealFunction.value(d6)) * (d4 = univariateRealFunction.value(d7)) > 0.0 && ++n2 < n && (d6 > d2 || d7 < d3));
        if (d5 * d4 > 0.0) {
            throw new ConvergenceException("number of iterations={0}, maximum iterations={1}, initial={2}, lower bound={3}, upper bound={4}, final a value={5}, final b value={6}, f(a)={7}, f(b)={8}", n2, n, d, d2, d3, d6, d7, d5, d4);
        }
        return new double[]{d6, d7};
    }

    public static double midpoint(double d, double d2) {
        return (d + d2) * 0.5;
    }

    private static void setup(UnivariateRealFunction univariateRealFunction) {
        if (univariateRealFunction == null) {
            throw MathRuntimeException.createIllegalArgumentException(NULL_FUNCTION_MESSAGE, new Object[0]);
        }
    }

    private static class LazyHolder {
        private static final UnivariateRealSolverFactory FACTORY = UnivariateRealSolverFactory.newInstance();

        private LazyHolder() {
        }
    }
}

