/*
 * Decompiled with CFR 0.152.
 */
package jam.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.plaf.BorderUIResource;
import javax.swing.table.DefaultTableCellRenderer;

public class TableRenderer
extends DefaultTableCellRenderer {
    protected Color bg1 = new Color(237, 243, 254);
    protected Color bg2 = Color.white;
    protected boolean striped;

    public TableRenderer(int alignment, Insets insets) {
        this(true, alignment, insets);
    }

    public TableRenderer(boolean striped, int alignment, Insets insets) {
        this.striped = striped;
        this.setOpaque(true);
        this.setHorizontalAlignment(alignment);
        if (insets != null) {
            this.setBorder(new BorderUIResource.EmptyBorderUIResource(insets));
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value != null) {
            this.setText(value.toString());
        }
        this.setEnabled(table.isEnabled());
        this.setFont(table.getFont());
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            if (this.striped) {
                if (row % 2 == 0) {
                    this.setBackground(this.bg1);
                } else {
                    this.setBackground(this.bg2);
                }
            } else {
                this.setBackground(table.getBackground());
            }
            this.setForeground(table.getForeground());
        }
        return this;
    }
}

