/*
 * Decompiled with CFR 0.152.
 */
package jam.framework;

import jam.framework.AbstractFrame;
import jam.framework.Application;
import jam.framework.MenuBarFactory;
import jam.framework.MenuFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class DefaultFileMenuFactory
implements MenuFactory {
    private final boolean isMultiDocument;

    public DefaultFileMenuFactory(boolean isMultiDocument) {
        this.isMultiDocument = isMultiDocument;
    }

    @Override
    public String getMenuName() {
        return "File";
    }

    @Override
    public void populateMenu(JMenu menu, AbstractFrame frame) {
        JMenuItem item;
        Application application = Application.getApplication();
        menu.setMnemonic('F');
        if (this.isMultiDocument) {
            item = new JMenuItem(application.getNewAction());
            item.setAccelerator(KeyStroke.getKeyStroke(78, MenuBarFactory.MENU_MASK));
            menu.add(item);
        }
        item = new JMenuItem(application.getOpenAction());
        item.setAccelerator(KeyStroke.getKeyStroke(79, MenuBarFactory.MENU_MASK));
        menu.add(item);
        item = new JMenuItem(frame.getSaveAction());
        item.setAccelerator(KeyStroke.getKeyStroke(83, MenuBarFactory.MENU_MASK));
        menu.add(item);
        item = new JMenuItem(frame.getSaveAsAction());
        menu.add(item);
        if (frame.getImportAction() != null || frame.getExportAction() != null) {
            menu.addSeparator();
            if (frame.getImportAction() != null) {
                item = new JMenuItem(frame.getImportAction());
                item.setAccelerator(KeyStroke.getKeyStroke(73, MenuBarFactory.MENU_MASK));
                menu.add(item);
            }
            if (frame.getExportAction() != null) {
                item = new JMenuItem(frame.getExportAction());
                item.setAccelerator(KeyStroke.getKeyStroke(69, MenuBarFactory.MENU_MASK));
                menu.add(item);
            }
        }
        menu.addSeparator();
        item = new JMenuItem(frame.getPrintAction());
        item.setAccelerator(KeyStroke.getKeyStroke(80, MenuBarFactory.MENU_MASK));
        menu.add(item);
        item = new JMenuItem(application.getPageSetupAction());
        menu.add(item);
        menu.addSeparator();
        if (application.getRecentFileMenu() != null) {
            JMenu subMenu = application.getRecentFileMenu();
            menu.add(subMenu);
            menu.addSeparator();
        }
        item = new JMenuItem(application.getExitAction());
        menu.add(item);
    }

    @Override
    public int getPreferredAlignment() {
        return 0;
    }
}

