/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import beast.app.beauti.PartitionContext;
import beast.core.BEASTInterface;
import beast.core.Distribution;
import beast.core.Input;
import beast.core.Logger;
import beast.core.Operator;
import beast.core.Param;
import beast.core.Runnable;
import beast.core.State;
import beast.core.parameter.Map;
import beast.core.parameter.Parameter;
import beast.core.parameter.RealParameter;
import beast.core.util.Log;
import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.Sequence;
import beast.evolution.tree.Tree;
import beast.util.AddOnManager;
import beast.util.Randomizer;
import beast.util.XMLParserException;
import beast.util.XMLParserUtils;
import beast.util.XMLProducer;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLParser {
    static final String DATA_CLASS = Alignment.class.getName();
    static final String SEQUENCE_CLASS = Sequence.class.getName();
    static final String STATE_CLASS = State.class.getName();
    static final String LIKELIHOOD_CLASS = Distribution.class.getName();
    static final String LOG_CLASS = Logger.class.getName();
    static final String OPERATOR_CLASS = Operator.class.getName();
    static final String REAL_PARAMETER_CLASS = RealParameter.class.getName();
    static final String BEAST_INTERFACE_CLASS = BEASTInterface.class.getName();
    static final String INPUT_CLASS = Input.class.getName();
    static final String TREE_CLASS = Tree.class.getName();
    static final String RUNNABLE_CLASS = Runnable.class.getName();
    public static final String BEAST_ELEMENT = "beast";
    public static final String MAP_ELEMENT = "map";
    public static final String DISTRIBUTION_ELEMENT = "distribution";
    public static final String OPERATOR_ELEMENT = "operator";
    public static final String INPUT_ELEMENT = "input";
    public static final String LOG_ELEMENT = "logger";
    public static final String DATA_ELEMENT = "data";
    public static final String SEQUENCE_ELEMENT = "sequence";
    public static final String STATE_ELEMENT = "state";
    public static final String TREE_ELEMENT = "tree";
    public static final String REAL_PARAMETER_ELEMENT = "parameter";
    public static final String RUN_ELEMENT = "run";
    public static final String PLATE_ELEMENT = "plate";
    Runnable m_runnable;
    State m_state;
    Document doc;
    String m_sDataMap;
    HashMap<String, BEASTInterface> IDMap;
    HashMap<String, Integer[]> likelihoodMap;
    HashMap<String, Node> IDNodeMap;
    String unavailablePacakges = "";
    static HashMap<String, String> element2ClassMap = new HashMap();
    static Set<String> reservedElements;
    List<BEASTInterface> beastObjectsWaitingToInit = new ArrayList<BEASTInterface>();
    List<Node> nodesWaitingToInit = new ArrayList<Node>();
    String[] nameSpaces;
    boolean needsInitialisation = true;
    RequiredInputProvider requiredInputProvider = null;
    PartitionContext partitionContext = null;

    public HashMap<String, String> getElement2ClassMap() {
        return element2ClassMap;
    }

    public Runnable parseFile(File file) throws SAXException, IOException, ParserConfigurationException, XMLParserException {
        String string;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.doc = documentBuilderFactory.newDocumentBuilder().parse(file);
        this.doc.normalize();
        XMLParserUtils.processPlates(this.doc, PLATE_ELEMENT);
        int n = file.getName().lastIndexOf(46);
        String string2 = string = n < 0 ? file.getName() : file.getName().substring(0, n);
        if (this.doc.getElementsByTagName(BEAST_ELEMENT).item(0) == null) {
            Log.err.println("Incorrect XML: Could not find 'beast' element in file " + file.getName());
            throw new RuntimeException();
        }
        XMLParserUtils.replaceVariable(this.doc.getElementsByTagName(BEAST_ELEMENT).item(0), "filebase", string);
        XMLParserUtils.replaceVariable(this.doc.getElementsByTagName(BEAST_ELEMENT).item(0), "seed", String.valueOf(Randomizer.getSeed()));
        this.IDMap = new HashMap();
        this.likelihoodMap = new HashMap();
        this.IDNodeMap = new HashMap();
        this.parse();
        if (this.m_runnable != null) {
            return this.m_runnable;
        }
        throw new XMLParserException("Run element does not point to a runnable object.");
    }

    public List<BEASTInterface> parseTemplate(String string, HashMap<String, BEASTInterface> hashMap, boolean bl) throws XMLParserException, SAXException, IOException, ParserConfigurationException {
        this.needsInitialisation = bl;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.doc = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(new StringReader(string)));
        this.doc.normalize();
        XMLParserUtils.processPlates(this.doc, PLATE_ELEMENT);
        this.IDMap = hashMap;
        this.likelihoodMap = new HashMap();
        this.IDNodeMap = new HashMap();
        ArrayList<BEASTInterface> arrayList = new ArrayList<BEASTInterface>();
        NodeList nodeList = this.doc.getElementsByTagName("*");
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new XMLParserException("Expected top level beast element in XML");
        }
        Node node = nodeList.item(0);
        double d = XMLParser.getAttributeAsDouble(node, "version");
        if (!node.getNodeName().equals(BEAST_ELEMENT) || d < 2.0 || d == Double.MAX_VALUE) {
            return arrayList;
        }
        this.initIDNodeMap(node);
        this.parseNameSpaceAndMap(node);
        NodeList nodeList2 = node.getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            if (nodeList2.item(i).getNodeType() != 1) continue;
            Node node2 = nodeList2.item(i);
            Log.warning.println(node2.getNodeName());
            if (node2.getNodeName().equals(MAP_ELEMENT)) continue;
            arrayList.add(this.createObject(node2, BEAST_INTERFACE_CLASS));
        }
        this.initBEASTObjects();
        return arrayList;
    }

    private void initBEASTObjects() throws XMLParserException {
        Node node = null;
        try {
            for (int i = 0; i < this.beastObjectsWaitingToInit.size(); ++i) {
                BEASTInterface bEASTInterface = this.beastObjectsWaitingToInit.get(i);
                node = this.nodesWaitingToInit.get(i);
                bEASTInterface.initAndValidate();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new XMLParserException(node, "validate and intialize error: " + exception.getMessage(), 110);
        }
    }

    public BEASTInterface parseFragment(String string, boolean bl) throws XMLParserException {
        int n;
        this.needsInitialisation = bl;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.doc = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(new StringReader(string)));
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new RuntimeException(exception);
        }
        this.doc.normalize();
        XMLParserUtils.processPlates(this.doc, PLATE_ELEMENT);
        this.IDMap = new HashMap();
        this.likelihoodMap = new HashMap();
        this.IDNodeMap = new HashMap();
        NodeList nodeList = this.doc.getElementsByTagName("*");
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new XMLParserException("Expected top level beast element in XML");
        }
        Node node = nodeList.item(0);
        this.initIDNodeMap(node);
        this.parseNameSpaceAndMap(node);
        NodeList nodeList2 = node.getChildNodes();
        if (nodeList2.getLength() == 0) {
            throw new XMLParserException("Need at least one child element");
        }
        for (n = nodeList2.getLength() - 1; !(n < 0 || nodeList2.item(n).getNodeType() == 1 && nodeList2.item(n).getNodeName().equals(RUN_ELEMENT)); --n) {
        }
        if (n < 0) {
            for (n = nodeList2.getLength() - 1; n >= 0 && nodeList2.item(n).getNodeType() != 1; --n) {
            }
        }
        if (n < 0) {
            throw new XMLParserException("Need at least one child element");
        }
        BEASTInterface bEASTInterface = this.createObject(nodeList2.item(n), BEAST_INTERFACE_CLASS);
        this.initBEASTObjects();
        return bEASTInterface;
    }

    public BEASTInterface parseBareFragment(String string, boolean bl) throws XMLParserException {
        if ((string = string.replaceAll("<\\?xml[^>]*>", "")).contains("<beast")) {
            return this.parseFragment(string, bl);
        }
        return this.parseFragment("<beast>" + string + "</beast>", bl);
    }

    public List<BEASTInterface> parseBareFragments(String string, boolean bl) throws XMLParserException, SAXException, IOException, ParserConfigurationException {
        this.needsInitialisation = bl;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.doc = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(new StringReader(string)));
        this.doc.normalize();
        XMLParserUtils.processPlates(this.doc, PLATE_ELEMENT);
        NodeList nodeList = this.doc.getElementsByTagName("*");
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new XMLParserException("Expected top level beast element in XML");
        }
        Node node = nodeList.item(0);
        this.initIDNodeMap(node);
        this.parseNameSpaceAndMap(node);
        NodeList nodeList2 = node.getChildNodes();
        ArrayList<BEASTInterface> arrayList = new ArrayList<BEASTInterface>();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            if (nodeList2.item(i).getNodeType() != 1) continue;
            BEASTInterface bEASTInterface = this.createObject(nodeList2.item(i), BEAST_INTERFACE_CLASS);
            arrayList.add(bEASTInterface);
        }
        this.initBEASTObjects();
        return arrayList;
    }

    public void parse() throws XMLParserException {
        NodeList nodeList = this.doc.getElementsByTagName("*");
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new XMLParserException("Expected top level beast element in XML");
        }
        Node node = nodeList.item(0);
        double d = XMLParser.getAttributeAsDouble(node, "version");
        if (d < 2.0 || d == Double.MAX_VALUE) {
            throw new XMLParserException(node, "Wrong version: only versions > 2.0 are supported", 101);
        }
        String string = XMLParser.getAttribute(node, "required");
        if (string != null && string.trim().length() > 0) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(":")) {
                String string3;
                String string4;
                int n = (string2 = string2.trim()).lastIndexOf(" ");
                if (n <= 0 || AddOnManager.isInstalled(string4 = string2.substring(0, n), string3 = string2.substring(n + 1))) continue;
                this.unavailablePacakges = this.unavailablePacakges + string2 + ", ";
            }
            if (this.unavailablePacakges.length() > 1) {
                this.unavailablePacakges = this.unavailablePacakges.substring(0, this.unavailablePacakges.length() - 2);
                if (this.unavailablePacakges.contains(",")) {
                    Log.warning("The following packages are required, but not available: " + this.unavailablePacakges);
                } else {
                    Log.warning("The following package is required, but is not available: " + this.unavailablePacakges);
                }
                Log.warning("See http://beast2.org/managing-packages/ for details on how to install packages.");
            }
        }
        this.initIDNodeMap(node);
        this.parseNameSpaceAndMap(node);
        this.parseRunElement(node);
        this.initBEASTObjects();
    }

    void initIDNodeMap(Node node) throws XMLParserException {
        String string = XMLParser.getID(node);
        if (string != null) {
            if (this.IDNodeMap.containsKey(string)) {
                throw new XMLParserException(node, "IDs should be unique. Duplicate id '" + string + "' found", 104);
            }
            this.IDNodeMap.put(string, node);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.initIDNodeMap(nodeList.item(i));
        }
    }

    void parseNameSpaceAndMap(Node node) throws XMLParserException {
        Object object;
        if (this.hasAtt(node, "namespace")) {
            object = XMLParser.getAttribute(node, "namespace");
            this.setNameSpace((String)object);
        } else if (this.nameSpaces == null) {
            this.nameSpaces = new String[1];
            this.nameSpaces[0] = "";
        }
        object = this.doc.getElementsByTagName(MAP_ELEMENT);
        for (int i = 0; i < object.getLength(); ++i) {
            Node node2 = object.item(i);
            String string = XMLParser.getAttribute(node2, "name");
            if (string == null) {
                throw new XMLParserException(node2, "name attribute expected in map element", 300);
            }
            if (element2ClassMap.containsKey(string)) continue;
            String string2 = node2.getTextContent();
            string2 = string2.replaceAll("\\s", "");
            boolean bl = false;
            for (String string3 : this.nameSpaces) {
                try {
                    if (bl || Class.forName(string3 + string2) == null) continue;
                    element2ClassMap.put(string, string2);
                    Log.debug.println(string + " => " + string3 + string2);
                    String string4 = XMLParser.getAttribute(node2, "reserved");
                    if (string4 != null && string4.toLowerCase().equals("true")) {
                        reservedElements.add(string);
                    }
                    bl = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public void setNameSpace(String string) {
        String[] stringArray = string.split(":");
        this.nameSpaces = new String[stringArray.length + 1];
        int n = 0;
        for (String string2 : stringArray) {
            if ((string2 = string2.trim()).length() > 0 && string2.charAt(string2.length() - 1) != '.') {
                string2 = string2 + '.';
            }
            this.nameSpaces[n++] = string2;
        }
        this.nameSpaces[n] = "";
    }

    void parseRunElement(Node node) throws XMLParserException {
        NodeList nodeList = this.doc.getElementsByTagName(RUN_ELEMENT);
        if (nodeList.getLength() == 0) {
            throw new XMLParserException(node, "Expected run element in file", 102);
        }
        if (nodeList.getLength() > 1) {
            throw new XMLParserException(node, "Expected only one mcmc element in file, not " + nodeList.getLength(), 103);
        }
        Node node2 = nodeList.item(0);
        this.m_runnable = (Runnable)this.createObject(node2, RUNNABLE_CLASS);
    }

    boolean checkType(String string, BEASTInterface bEASTInterface, Node node) throws XMLParserException {
        try {
            if (string.equals(INPUT_CLASS) || Class.forName(string).isInstance(bEASTInterface)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XMLParserException(node, "Class not found:" + classNotFoundException.getMessage(), 444);
        }
        return string.equals(RealParameter.class.getName()) && bEASTInterface instanceof Parameter;
    }

    BEASTInterface createObject(Node node, String string) throws XMLParserException {
        Object object;
        String string2;
        String string3 = XMLParser.getID(node);
        if (string3 != null && this.IDMap.containsKey(string3)) {
            BEASTInterface bEASTInterface = this.IDMap.get(string3);
            if (this.checkType(string, bEASTInterface, node)) {
                return bEASTInterface;
            }
            throw new XMLParserException(node, "id=" + string3 + ". Expected object of type " + string + " instead of " + bEASTInterface.getClass().getName(), 105);
        }
        String string4 = XMLParser.getIDRef(node);
        if (string4 != null) {
            if (node.getAttributes().getLength() > 1) {
                int n = (XMLParser.getAttribute(node, "id") == null ? 0 : 1) + (XMLParser.getAttribute(node, "name") == null ? 0 : 1);
                if (node.getAttributes().getLength() > 1 + n) {
                    Log.warning.println("Element " + node.getNodeName() + " found with idref='" + string4 + "'. All other attributes are ignored.\n");
                }
            }
            if (this.IDMap.containsKey(string4)) {
                BEASTInterface bEASTInterface = this.IDMap.get(string4);
                if (string.equals("Alignment") || this.checkType(string, bEASTInterface, node)) {
                    return bEASTInterface;
                }
                this.checkType(string, bEASTInterface, node);
                throw new XMLParserException(node, "id=" + string4 + ". Expected object of type " + string + " instead of " + bEASTInterface.getClass().getName(), 106);
            }
            if (this.IDNodeMap.containsKey(string4)) {
                BEASTInterface bEASTInterface = this.createObject(this.IDNodeMap.get(string4), string);
                if (this.checkType(string, bEASTInterface, node)) {
                    return bEASTInterface;
                }
                throw new XMLParserException(node, "id=" + string4 + ". Expected object of type " + string + " instead of " + bEASTInterface.getClass().getName(), 107);
            }
            throw new XMLParserException(node, "Could not find object associated with idref " + string4, 170);
        }
        String string5 = string;
        String string6 = node.getNodeName();
        if (element2ClassMap.containsKey(string6)) {
            string5 = element2ClassMap.get(string6);
        }
        if ((string2 = XMLParser.getAttribute(node, "spec")) != null) {
            string5 = string2;
        }
        String string7 = null;
        string7 = this.resolveClass(string5);
        if (string7 == null) {
            boolean bl = false;
            for (String string8 : this.nameSpaces) {
                try {
                    if (bl) continue;
                    Class.forName(string8 + string5);
                    string7 = string8 + string5;
                    bl = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (string7 == null) {
            if (this.unavailablePacakges.length() > 2) {
                String string9 = "Class " + string5 + " could not be found.\n" + (this.unavailablePacakges.contains(",") ? "This XML requires the following packages that are not installed: " : "This XML requires the following package that is not installed: ") + this.unavailablePacakges + "\n" + "See http://beast2.org/managing-packages/ for details on how to install packages.\n" + "Or perhaps there is a typo in spec and you meant " + XMLParserUtils.guessClass(string5) + "?";
                throw new XMLParserException(node, string9, 1018);
            }
            throw new XMLParserException(node, "Class could not be found. Did you mean " + XMLParserUtils.guessClass(string5) + "?", 1017);
        }
        try {
            object = Class.forName(string7);
            if (!BEASTInterface.class.isAssignableFrom((Class<?>)object)) {
                throw new XMLParserException(node, "Expected object to be instance of BEASTObject", 108);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new RuntimeException(classNotFoundException);
        }
        object = this.parseInputs(node, string7);
        BEASTInterface bEASTInterface = this.createBeastObject(node, string3, string7, (List<NameValuePair>)object);
        if (this.needsInitialisation) {
            try {
                bEASTInterface.determindClassOfInputs();
                bEASTInterface.validateInputs();
                this.beastObjectsWaitingToInit.add(bEASTInterface);
                this.nodesWaitingToInit.add(node);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                throw new XMLParserException(node, "validate and intialize error: " + illegalArgumentException.getMessage(), 110);
            }
        }
        return bEASTInterface;
    }

    private BEASTInterface createBeastObject(Node node, String string, String string2, List<NameValuePair> list) throws XMLParserException {
        Object object;
        BEASTInterface bEASTInterface = this.useAnnotatedConstructor(node, string, string2, list);
        if (bEASTInterface != null) {
            return bEASTInterface;
        }
        Object var6_6 = null;
        try {
            Iterator<Object> iterator = Class.forName(string2);
            var6_6 = ((Class)((Object)iterator)).newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new XMLParserException(node, "Cannot instantiate class. Please check the spec attribute.", 1006);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new XMLParserException(node, "Cannot access class. Please check the spec attribute.", 1011);
        }
        bEASTInterface = var6_6;
        bEASTInterface.setID(string);
        if (var6_6 instanceof State) {
            this.m_state = var6_6;
        }
        for (NameValuePair object2 : list) {
            if (object2.value instanceof BEASTInterface) {
                this.setInput(node, bEASTInterface, object2.name, (BEASTInterface)object2.value);
                continue;
            }
            if (object2.value instanceof String) {
                this.setInput(node, bEASTInterface, object2.name, (String)object2.value);
                continue;
            }
            throw new RuntimeException("Programmer error: value should be String or BEASTInterface");
        }
        try {
            if (this.requiredInputProvider != null) {
                for (Input input : bEASTInterface.listInputs()) {
                    if (input.get() != null || input.getRule() != Input.Validate.REQUIRED || (object = this.requiredInputProvider.createInput(bEASTInterface, input, this.partitionContext)) == null) continue;
                    input.setValue(object, bEASTInterface);
                }
            }
        }
        catch (Exception exception) {
            throw new XMLParserException(node, exception.getMessage(), 1008);
        }
        if (!(bEASTInterface instanceof Map)) {
            for (NameValuePair nameValuePair : list) {
                object = nameValuePair.name;
                if (((String)object).equals("id") || ((String)object).equals("idref") || ((String)object).equals("spec") || ((String)object).equals("name")) continue;
                try {
                    bEASTInterface.getInput((String)object);
                }
                catch (Exception exception) {
                    throw new XMLParserException(node, exception.getMessage(), 1009);
                }
            }
        }
        for (NameValuePair nameValuePair : list) {
            if (!(nameValuePair.value instanceof BEASTInterface)) continue;
            ((BEASTInterface)nameValuePair.value).getOutputs().add(var6_6);
        }
        this.register(node, bEASTInterface);
        return bEASTInterface;
    }

    private BEASTInterface useAnnotatedConstructor(Node node, String string, String string2, List<NameValuePair> list) throws XMLParserException {
        Constructor<?>[] constructorArray;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        for (Constructor<?> constructor : constructorArray = clazz.getDeclaredConstructors()) {
            Annotation[][] annotationArray = constructor.getParameterAnnotations();
            ArrayList<Param> arrayList = new ArrayList<Param>();
            for (Object object2 : annotationArray) {
                for (Annotation annotation : object2) {
                    if (!(annotation instanceof Param)) continue;
                    arrayList.add((Param)annotation);
                }
            }
            for (NameValuePair nameValuePair : list) {
                nameValuePair.processed = false;
            }
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length <= 0 || arrayList.size() != classArray.length) continue;
            try {
                Object object;
                int n;
                Object object2;
                Object[] objectArray = new Object[classArray.length];
                block10: for (n = 0; n < classArray.length; ++n) {
                    object2 = (Param)arrayList.get(n);
                    object = classArray[n];
                    if (object.getTypeName().equals("java.util.List")) {
                        if (objectArray[n] == null) {
                            objectArray[n] = new ArrayList();
                        }
                        Constructor<?>[] constructorArray2 = XMLParser.getListOfValues((Param)object2, list);
                        ((List)objectArray[n]).addAll(constructorArray2);
                        continue;
                    }
                    objectArray[n] = this.getValue((Param)object2, (Class<?>)classArray[n], list);
                    if (!objectArray[n].getClass().equals(String.class) || classArray[n] == String.class) continue;
                    for (Constructor<?> constructor2 : ((Class)classArray[n]).getDeclaredConstructors()) {
                        Class<?>[] classArray2 = constructor2.getParameterTypes();
                        if (classArray2.length != 1 || classArray2[0] != String.class) continue;
                        Object obj = constructor2.newInstance(objectArray[n]);
                        objectArray[n] = obj;
                        continue block10;
                    }
                }
                n = 1;
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (NameValuePair)object2.next();
                    if (((NameValuePair)object).processed) continue;
                    n = 0;
                }
                if (n == 0) continue;
                try {
                    object2 = constructor.newInstance(objectArray);
                    object = (BEASTInterface)object2;
                    this.register(node, (BEASTInterface)object);
                    return object;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                    throw new XMLParserException(node, "Could not create object: " + exception.getMessage(), 1012);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Object getValue(Param param, Class<?> clazz, List<NameValuePair> list) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<Integer> constructor;
        for (NameValuePair object2 : list) {
            if (!object2.name.equals(param.name())) continue;
            object2.processed = true;
            if (clazz.isAssignableFrom(Integer.class)) {
                return Integer.parseInt((String)object2.value);
            }
            if (clazz.isAssignableFrom(Double.class)) {
                return Double.parseDouble((String)object2.value);
            }
            return object2.value;
        }
        if (!param.optional()) {
            throw new IllegalArgumentException();
        }
        String string = param.defaultValue();
        Object object = string;
        try {
            constructor = clazz.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException obj) {
            try {
                object = string.startsWith("0x") ? Integer.valueOf(Integer.parseInt(string.substring(2), 16)) : Integer.valueOf(Integer.parseInt(string));
                constructor = clazz.getDeclaredConstructor(Integer.TYPE);
            }
            catch (NumberFormatException numberFormatException) {
                object = Double.parseDouble(string);
                constructor = clazz.getDeclaredConstructor(Double.TYPE);
            }
        }
        constructor.setAccessible(true);
        Integer n = constructor.newInstance(object);
        return n;
    }

    static List<Object> getListOfValues(Param param, List<NameValuePair> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (NameValuePair nameValuePair : list) {
            if (!nameValuePair.name.equals(param.name())) continue;
            arrayList.add(nameValuePair.value);
            nameValuePair.processed = true;
        }
        return arrayList;
    }

    @Deprecated
    public static int getLevenshteinDistance(String string, String string2) {
        return XMLParserUtils.getLevenshteinDistance(string, string2);
    }

    private List<NameValuePair> parseInputs(Node node, String string) throws XMLParserException {
        String string2;
        Object object;
        Node node2;
        String string3;
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                String string4 = namedNodeMap.item(i).getNodeName();
                if (string4.equals("id") || string4.equals("idref") || string4.equals("spec") || string4.equals("name")) continue;
                string3 = namedNodeMap.item(i).getNodeValue();
                if (string3.startsWith("@")) {
                    String string5 = string3.substring(1);
                    node2 = this.doc.createElement(INPUT_ELEMENT);
                    node2.setAttribute("idref", string5);
                    node.appendChild(node2);
                    object = this.createObject(node2, BEAST_INTERFACE_CLASS);
                    node.removeChild(node2);
                    arrayList.add(new NameValuePair(string4, object));
                    continue;
                }
                arrayList.add(new NameValuePair(string4, string3));
            }
        }
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        string3 = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node2 = nodeList.item(i);
            if (node2.getNodeType() == 1) {
                Object object2;
                String string6;
                object = node2.getNodeName();
                String string7 = XMLParser.getAttribute(node2, "name");
                if (string7 == null) {
                    string7 = object;
                }
                String string8 = BEAST_INTERFACE_CLASS;
                if (element2ClassMap.containsKey(object)) {
                    string8 = element2ClassMap.get(object);
                }
                if ((string6 = XMLParser.getAttribute(node2, "spec")) != null) {
                    string8 = string6;
                }
                String string9 = null;
                string9 = this.resolveClass(string8);
                if (string9 == null) {
                    string9 = string8;
                }
                boolean bl = false;
                namedNodeMap = node2.getAttributes();
                if (namedNodeMap.getLength() == 0 || ((String)object).equals(INPUT_ELEMENT) && namedNodeMap.getLength() == 1 && string7 != null) {
                    object2 = node2.getChildNodes();
                    boolean bl2 = false;
                    for (int j = 0; j < object2.getLength(); ++j) {
                        if (object2.item(j).getNodeType() != 1) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        String string10 = node2.getTextContent();
                        arrayList.add(new NameValuePair(string7, string10));
                        bl = true;
                    }
                }
                if (!bl && (object2 = this.createObject(node2, string9)) != null) {
                    arrayList.add(new NameValuePair(string7, object2));
                }
                ++n;
                continue;
            }
            if (node2.getNodeType() != 4 && node2.getNodeType() != 3) continue;
            string3 = string3 + node2.getTextContent();
        }
        if (!string3.matches("\\s*")) {
            arrayList.add(new NameValuePair("value", string3));
        }
        if (n == 0 && (string2 = node.getTextContent()) != null && string2.length() > 0 && string2.replaceAll("\\s", "").length() > 0) {
            try {
                arrayList.add(new NameValuePair("value", string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private String resolveClass(String string) {
        for (String string2 : this.nameSpaces) {
            if (!XMLParserUtils.beastObjectNames.contains(string2 + string)) continue;
            String string3 = string2 + string;
            return string3;
        }
        for (String string2 : this.nameSpaces) {
            try {
                if (Class.forName(string2 + string) == null) continue;
                String string4 = string2 + string;
                return string4;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    void setInput(Node node, BEASTInterface bEASTInterface, String string, BEASTInterface bEASTInterface2) throws XMLParserException {
        try {
            Input<?> input = bEASTInterface.getInput(string);
            if (input.get() != input.defaultValue) {
                throw new XMLParserException(node, "\nMultiple entries for input \"" + input.getName() + "\" but only single entry expected " + "in element \"" + node.getNodeName() + "\"", 130);
            }
            bEASTInterface.setInputValue(string, bEASTInterface2);
            return;
        }
        catch (XMLParserException xMLParserException) {
            throw xMLParserException;
        }
        catch (Exception exception) {
            if (string.equals("xml:base")) {
                return;
            }
            if (exception.getMessage().contains("101")) {
                String string2 = "?";
                try {
                    string2 = bEASTInterface.getInput(string).getType().getName().replaceAll(".*\\.", "");
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw new XMLParserException(node, exception.getMessage() + " expected '" + string2 + "' but got '" + bEASTInterface2.getClass().getName().replaceAll(".*\\.", "") + "'", 123);
            }
            throw new XMLParserException(node, exception.getMessage(), 130);
        }
    }

    void setInput(Node node, BEASTInterface bEASTInterface, String string, String string2) throws XMLParserException {
        try {
            bEASTInterface.setInputValue(string, string2);
            return;
        }
        catch (Exception exception) {
            if (string.equals("xml:base")) {
                return;
            }
            try {
                bEASTInterface.setInputValue(string, string2);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
            throw new XMLParserException(node, exception.getMessage(), 124);
        }
    }

    void register(Node node, BEASTInterface bEASTInterface) {
        String string = XMLParser.getID(node);
        if (string != null) {
            this.IDMap.put(string, bEASTInterface);
        }
    }

    public static String getID(Node node) {
        return XMLParser.getAttribute(node, "id");
    }

    public static String getIDRef(Node node) {
        return XMLParser.getAttribute(node, "idref");
    }

    public static String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            String string2 = namedNodeMap.item(i).getNodeName();
            if (!string2.equals(string)) continue;
            return namedNodeMap.item(i).getNodeValue();
        }
        return null;
    }

    public static int getAttributeAsInt(Node node, String string) {
        String string2 = XMLParser.getAttribute(node, string);
        if (string2 == null) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    public static double getAttributeAsDouble(Node node, String string) {
        String string2 = XMLParser.getAttribute(node, string);
        if (string2 == null) {
            return Double.MAX_VALUE;
        }
        return Double.parseDouble(string2);
    }

    boolean hasAtt(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                String string2 = namedNodeMap.item(i).getNodeName();
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public void setRequiredInputProvider(RequiredInputProvider requiredInputProvider, PartitionContext partitionContext) {
        this.requiredInputProvider = requiredInputProvider;
        this.partitionContext = partitionContext;
    }

    public static void main(String[] stringArray) {
        try {
            PrintStream printStream = System.out;
            System.setOut(System.err);
            XMLParser xMLParser = new XMLParser();
            Runnable runnable = xMLParser.parseFile(new File(stringArray[0]));
            System.setOut(printStream);
            System.out.println(new XMLProducer().toXML(runnable));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        element2ClassMap.put(DISTRIBUTION_ELEMENT, LIKELIHOOD_CLASS);
        element2ClassMap.put(OPERATOR_ELEMENT, OPERATOR_CLASS);
        element2ClassMap.put(INPUT_ELEMENT, INPUT_CLASS);
        element2ClassMap.put(LOG_ELEMENT, LOG_CLASS);
        element2ClassMap.put(DATA_ELEMENT, DATA_CLASS);
        element2ClassMap.put(STATE_ELEMENT, STATE_CLASS);
        element2ClassMap.put(SEQUENCE_ELEMENT, SEQUENCE_CLASS);
        element2ClassMap.put(TREE_ELEMENT, TREE_CLASS);
        element2ClassMap.put(REAL_PARAMETER_ELEMENT, REAL_PARAMETER_CLASS);
        reservedElements = new HashSet<String>();
        for (String string : element2ClassMap.keySet()) {
            reservedElements.add(string);
        }
    }

    public static interface RequiredInputProvider {
        public Object createInput(BEASTInterface var1, Input<?> var2, PartitionContext var3);
    }

    public static class NameValuePair {
        String name;
        Object value;
        boolean processed;

        public NameValuePair(String string, Object object) {
            this.name = string;
            this.value = object;
            this.processed = false;
        }
    }
}

