/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.speciation;

import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Input;
import beast.evolution.alignment.TaxonSet;
import beast.math.distributions.ParametricDistribution;

@Description(value="Specification of a single calibration point of the calibrated Yule.")
public class CalibrationPoint
extends BEASTObject {
    public final Input<TaxonSet> taxonsetInput = new Input("taxonset", "Set of taxa. The prior distribution is applied to their TMRCA.", Input.Validate.REQUIRED);
    public final Input<ParametricDistribution> distInput = new Input("distr", "Prior distribution applied to time of clade MRCA", Input.Validate.REQUIRED);
    public final Input<Boolean> forParentInput = new Input<Boolean>("parentOf", "Use time of clade parent. Default is false.", false);
    private TaxonSet t;
    private boolean forPar;
    private ParametricDistribution pd;

    @Override
    public void initAndValidate() {
        this.t = this.taxonsetInput.get();
        this.forPar = this.forParentInput.get();
        this.pd = this.distInput.get();
    }

    public TaxonSet taxa() {
        return this.t;
    }

    public boolean forParent() {
        return this.forPar;
    }

    public ParametricDistribution dist() {
        return this.pd;
    }

    public double logPdf(double d) {
        return this.pd.logDensity(d);
    }
}

